/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.server;

import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ComponentUsageTracker {
    private final Map<Class<? extends EntityComponent>, Map<EntityId, Long>> map = new HashMap<Class<? extends EntityComponent>, Map<EntityId, Long>>();
    private final List<PendingClean> pending = new ArrayList<PendingClean>();

    protected Map<EntityId, Long> getFrameMap(Class<? extends EntityComponent> type, boolean create) {
        Map<EntityId, Long> result = this.map.get(type);
        if (result == null && create) {
            result = new HashMap<EntityId, Long>();
            this.map.put(type, result);
        }
        return result;
    }

    protected void checkPending() {
        if (!this.pending.isEmpty()) {
            throw new IllegalStateException("Cannot update frame tracking while expirations are pending.  Call sweep() first.");
        }
    }

    public Long set(EntityId id, Class<? extends EntityComponent> type, Long frame) {
        this.checkPending();
        return this.getFrameMap(type, true).put(id, frame);
    }

    public void set(Collection<EntityId> ids, Class<? extends EntityComponent> type, Long frame) {
        this.checkPending();
        Map<EntityId, Long> frames = this.getFrameMap(type, true);
        for (EntityId id : ids) {
            frames.put(id, frame);
        }
    }

    public Long getAndExpire(EntityId id, Class<? extends EntityComponent> type, Long current) {
        Map<EntityId, Long> frames = this.getFrameMap(type, false);
        if (frames == null) {
            return null;
        }
        Long last = frames.get(id);
        if (last == null) {
            return null;
        }
        if (last.longValue() == current.longValue()) {
            return current;
        }
        this.pending.add(new PendingClean(id, type, frames));
        frames.put(id, current);
        return last;
    }

    public void sweep() {
        if (this.pending.isEmpty()) {
            return;
        }
        for (PendingClean clean : this.pending) {
            clean.clean();
        }
        this.pending.clear();
    }

    public Long get(EntityId id, Class<? extends EntityComponent> type) {
        Map<EntityId, Long> frames = this.getFrameMap(type, false);
        if (frames == null) {
            return null;
        }
        return frames.get(id);
    }

    private class PendingClean {
        private EntityId id;
        private Class<? extends EntityComponent> type;
        private Map<EntityId, Long> frames;

        public PendingClean(EntityId id, Class<? extends EntityComponent> type, Map<EntityId, Long> frames) {
            this.id = id;
            this.type = type;
            this.frames = frames;
        }

        public void clean() {
            this.frames.remove(this.id);
            if (this.frames.isEmpty()) {
                ComponentUsageTracker.this.map.remove(this.type);
            }
        }
    }
}

