/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ethereal.io;

import com.simsilica.ethereal.io.BitInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BitOutputStream
implements AutoCloseable {
    private final OutputStream out;
    private int currentByte = 0;
    private int bits = 8;

    public BitOutputStream(OutputStream out) {
        this.out = out;
    }

    public int getPendingBits() {
        return this.bits;
    }

    public void writeBits(int value, int count) throws IOException {
        if (count == 0) {
            throw new IllegalArgumentException("Cannot write 0 bits.");
        }
        value &= -1 >>> 32 - count;
        int remaining = count;
        while (remaining > 0) {
            int bitsToCopy = this.bits < remaining ? this.bits : remaining;
            int sourceShift = remaining - bitsToCopy;
            int targetShift = this.bits - bitsToCopy;
            this.currentByte |= value >>> sourceShift << targetShift;
            this.bits -= bitsToCopy;
            value &= -1 >>> 32 - (remaining -= bitsToCopy);
            if (this.bits != 0) continue;
            this.flush();
        }
    }

    public void writeLongBits(long value, int count) throws IOException {
        if (count == 0) {
            throw new IllegalArgumentException("Cannot write 0 bits.");
        }
        value &= -1L >>> 64 - count;
        int remaining = count;
        while (remaining > 0) {
            int bitsToCopy = this.bits < remaining ? this.bits : remaining;
            int sourceShift = remaining - bitsToCopy;
            int targetShift = this.bits - bitsToCopy;
            this.currentByte = (int)((long)this.currentByte | value >>> sourceShift << targetShift);
            this.bits -= bitsToCopy;
            value &= -1L >>> 64 - (remaining -= bitsToCopy);
            if (this.bits != 0) continue;
            this.flush();
        }
    }

    protected void flush() throws IOException {
        this.out.write(this.currentByte);
        this.bits = 8;
        this.currentByte = 0;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    public static void main(String ... args) throws Exception {
        BitOutputStream.test2();
    }

    public static void test2() throws Exception {
        byte[] bytes = new byte[]{18, 52, 86, 120, -102, -68, -34, -1};
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        BitOutputStream out = new BitOutputStream(bOut);
        for (int i = 0; i < bytes.length; ++i) {
            out.writeBits(1, 1);
            out.writeBits(bytes[i], 8);
            out.writeLongBits(1311768467463790320L, 64);
            out.writeLongBits(-1L, 64);
            out.writeLongBits(-9218247941278745378L, 64);
        }
        out.close();
        byte[] toRead = bOut.toByteArray();
        System.out.println("Written length:" + toRead.length);
        ByteArrayInputStream bIn = new ByteArrayInputStream(toRead);
        BitInputStream in = new BitInputStream(bIn);
        for (int i = 0; i < bytes.length; ++i) {
            int test = in.readBits(1);
            int val = in.readBits(8);
            long l1 = in.readLongBits(64);
            long l2 = in.readLongBits(64);
            long l3 = in.readLongBits(64);
            System.out.print("[" + Integer.toHexString(val) + "]");
            System.out.println("(" + Long.toHexString(l1) + ", " + Long.toHexString(l2) + ", " + Long.toHexString(l3) + ")");
        }
        System.out.println();
    }

    public static void test1() throws Exception {
        for (int count = 1; count <= 32; ++count) {
            System.out.println("Count:" + count);
            byte[] bytes = new byte[]{18, 52, 86, 120, -102, -68, -34, -1};
            int total = 64;
            ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
            BitInputStream in = new BitInputStream(bIn);
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            BitOutputStream out = new BitOutputStream(bOut);
            for (int bitsRead = 0; bitsRead <= total - count; bitsRead += count) {
                int val = in.readBits(count);
                out.writeBits(val, count);
            }
            byte[] result = bOut.toByteArray();
            for (int i = 0; i < result.length; ++i) {
                System.out.print("[" + Integer.toHexString(result[i] & 0xFF) + "]");
            }
            System.out.println();
        }
    }
}

