/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.service.rmi;

import com.jme3.network.HostedConnection;
import com.jme3.network.service.rmi.CallType;
import com.jme3.network.service.rmi.ClassInfo;
import com.jme3.network.service.rmi.ClassInfoRegistry;
import com.jme3.network.service.rmi.RemoteObjectHandler;
import com.jme3.network.service.rmi.RmiContext;
import com.jme3.network.service.rpc.RpcConnection;
import com.jme3.network.service.rpc.RpcHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RmiRegistry {
    private static final Logger log = Logger.getLogger(RmiRegistry.class.getName());
    private static final short NEW_CLASS = 0;
    private static final short ADD_OBJECT = 1;
    private static final short REMOVE_OBJECT = 2;
    private RpcConnection rpc;
    private short rmiId;
    private byte defaultChannel;
    private final RmiHandler rmiHandler = new RmiHandler();
    private final ClassInfoRegistry classCache = new ClassInfoRegistry();
    private final AtomicInteger nextObjectId = new AtomicInteger();
    private final ObjectIndex<SharedObject> local = new ObjectIndex();
    private final ObjectIndex<Object> remote = new ObjectIndex();
    private HostedConnection context;

    public RmiRegistry(RpcConnection rpc, short rmiId, byte defaultChannel) {
        this(null, rpc, rmiId, defaultChannel);
    }

    public RmiRegistry(HostedConnection context, RpcConnection rpc, short rmiId, byte defaultChannel) {
        this.context = context;
        this.rpc = rpc;
        this.rmiId = rmiId;
        this.defaultChannel = defaultChannel;
        rpc.registerHandler(rmiId, this.rmiHandler);
    }

    public <T> void share(T object, Class<? super T> type) {
        this.share(this.defaultChannel, object, type);
    }

    public <T> void share(byte channel, T object, Class<? super T> type) {
        this.share(channel, type.getName(), object, type);
    }

    public <T> void share(String name, T object, Class<? super T> type) {
        this.share(this.defaultChannel, name, object, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void share(byte channel, String name, T object, Class<? super T> type) {
        ClassInfo typeInfo = this.classCache.getClassInfo(type);
        this.local.lock.writeLock().lock();
        try {
            SharedObject existing;
            if (this.local.classes.put(typeInfo.getId(), typeInfo) == null) {
                this.rpc.callAsync(this.defaultChannel, this.rmiId, (short)0, typeInfo);
            }
            if ((existing = (SharedObject)this.local.byName.remove(name)) != null) {
                this.local.byId.remove(existing.objectId);
                this.rpc.removeHandler(existing.objectId, this.rmiHandler);
                this.rpc.callAsync(this.defaultChannel, this.rmiId, (short)2, existing.objectId);
            }
            SharedObject newShare = new SharedObject(name, object, type, typeInfo);
            this.local.byName.put(name, newShare);
            this.local.byId.put(newShare.objectId, newShare);
            this.rpc.registerHandler(newShare.objectId, this.rmiHandler);
            this.rpc.callAsync(this.defaultChannel, this.rmiId, (short)1, channel, newShare.objectId, name, typeInfo.getId());
        }
        finally {
            this.local.lock.writeLock().unlock();
        }
    }

    public <T> T getLocalObject(Class<T> type) {
        return this.getLocalObject(type.getName(), type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getLocalObject(String name, Class<T> type) {
        this.local.lock.readLock().lock();
        try {
            T t = type.cast(((SharedObject)this.local.byName.get(name)).object);
            return t;
        }
        finally {
            this.local.lock.readLock().unlock();
        }
    }

    public <T> T getRemoteObject(Class<T> type) {
        return this.getRemoteObject(type.getName(), type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getRemoteObject(String name, Class<T> type) {
        this.remote.lock.readLock().lock();
        try {
            T t = type.cast(this.remote.byName.get(name));
            return t;
        }
        finally {
            this.remote.lock.readLock().unlock();
        }
    }

    protected void addRemoteClass(ClassInfo info) {
        if (this.remote.classes.put(info.getId(), info) != null) {
            throw new RuntimeException("Error class already exists for ID:" + info.getId());
        }
    }

    protected void removeRemoteObject(short objectId) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "removeRemoteObject({0})", objectId);
        }
        throw new UnsupportedOperationException("Removal not yet implemented.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRemoteObject(byte channel, short objectId, String name, ClassInfo typeInfo) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("addRemoveObject(" + objectId + ", " + name + ", " + typeInfo + ")");
        }
        this.remote.lock.writeLock().lock();
        try {
            Object existing = this.remote.byName.get(name);
            if (existing != null) {
                throw new RuntimeException("Object already registered for:" + name);
            }
            RemoteObjectHandler remoteHandler = new RemoteObjectHandler(this, channel, objectId, typeInfo);
            Object remoteObject = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{typeInfo.getType()}, (InvocationHandler)remoteHandler);
            this.remote.byName.put(name, remoteObject);
            this.remote.byId.put(objectId, remoteObject);
        }
        finally {
            this.remote.lock.writeLock().unlock();
        }
    }

    protected Object invokeRemote(byte channel, short objectId, short procId, CallType callType, Object[] args) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("invokeRemote(" + channel + ", " + objectId + ", " + procId + ", " + (Object)((Object)callType) + ", " + (args == null ? "null" : Arrays.asList(args)) + ")");
        }
        switch (callType) {
            case Asynchronous: {
                log.finest("Sending reliable asynchronous.");
                this.rpc.callAsync(channel, objectId, procId, args);
                return null;
            }
            case Unreliable: {
                log.finest("Sending unreliable asynchronous.");
                this.rpc.callAsync((byte)-1, objectId, procId, args);
                return null;
            }
        }
        log.finest("Sending synchronous.");
        Object result = this.rpc.callAndWait(channel, objectId, procId, args);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("->got:" + result);
        }
        return result;
    }

    protected void rmiUpdate(short procId, Object[] args) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("rmiUpdate(" + procId + ", " + Arrays.asList(args) + ")");
        }
        switch (procId) {
            case 0: {
                this.addRemoteClass((ClassInfo)args[0]);
                break;
            }
            case 2: {
                this.removeRemoteObject((Short)args[0]);
                break;
            }
            case 1: {
                ClassInfo info = this.remote.classes.get((Short)args[3]);
                this.addRemoteObject((Byte)args[0], (Short)args[1], (String)args[2], info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeLocal(short objectId, short procId, Object[] args) {
        SharedObject share = (SharedObject)this.local.byId.get(objectId);
        this.local.lock.readLock().lock();
        try {
            share = (SharedObject)this.local.byId.get(objectId);
        }
        finally {
            this.local.lock.readLock().unlock();
        }
        try {
            RmiContext.setRmiConnection(this.context);
            Object object = share.invoke(procId, args);
            return object;
        }
        finally {
            RmiContext.setRmiConnection(null);
        }
    }

    private class ObjectIndex<T> {
        final Map<String, T> byName = new HashMap<String, T>();
        final Map<Short, T> byId = new HashMap<Short, T>();
        final Map<Short, ClassInfo> classes = new HashMap<Short, ClassInfo>();
        final ReadWriteLock lock = new ReentrantReadWriteLock();
    }

    private class RmiHandler
    implements RpcHandler {
        private RmiHandler() {
        }

        @Override
        public Object call(RpcConnection conn, short objectId, short procId, Object ... args) {
            if (objectId == RmiRegistry.this.rmiId) {
                RmiRegistry.this.rmiUpdate(procId, args);
                return null;
            }
            return RmiRegistry.this.invokeLocal(objectId, procId, args);
        }
    }

    private class SharedObject {
        private final short objectId;
        private final String name;
        private final Object object;
        private final Class type;
        private final ClassInfo classInfo;

        public SharedObject(String name, Object object, Class type, ClassInfo classInfo) {
            this.objectId = (short)RmiRegistry.this.nextObjectId.incrementAndGet();
            this.name = name;
            this.object = object;
            this.type = type;
            this.classInfo = classInfo;
        }

        public Object invoke(short procId, Object[] args) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("SharedObject->invoking:" + this.classInfo.getMethod(procId) + " on:" + this.object + " with:" + (args == null ? "null" : Arrays.asList(args)));
            }
            return this.classInfo.getMethod(procId).invoke(this.object, args);
        }
    }
}

