/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile.pc;

import com.simsilica.ethereal.io.BitInputStream;
import com.simsilica.ethereal.io.BitOutputStream;
import com.simsilica.mworld.DataVersion;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.io.ObjectProtocol;
import com.simsilica.mworld.tile.Resolution;
import com.simsilica.mworld.tile.pc.PointCloudData;
import com.simsilica.mworld.tile.pc.PointCloudDataProtocol;
import com.simsilica.mworld.tile.pc.PointCloudLayer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointCloudLayerProtocol
implements ObjectProtocol<PointCloudLayer> {
    static Logger log = LoggerFactory.getLogger(PointCloudLayerProtocol.class);
    private int version = 1;
    private PointCloudDataProtocol pcProtocol = new PointCloudDataProtocol();

    @Override
    public int getProtocolVersion() {
        return this.version;
    }

    @Override
    public void write(PointCloudLayer layer, BitOutputStream out) throws IOException {
        out.writeBits(this.version, 16);
        long id = layer.getTileId().getId();
        out.writeLongBits(id, 64);
        out.writeLongBits(layer.getVersion().getVersion(), 64);
        int scale = 1024 / layer.getResolution().getSamples();
        out.writeBits(scale, 8);
        Collection<PointCloudData> pointClouds = layer.getPointClouds();
        int maxSize = 2047;
        if (pointClouds.size() > maxSize) {
            throw new RuntimeException("Major problems, point clouds count somehow exceeds max size.count:" + pointClouds.size() + " max:" + maxSize);
        }
        out.writeBits(pointClouds.size(), 11);
        for (PointCloudData pc : pointClouds) {
            this.pcProtocol.write(pc, out);
        }
    }

    @Override
    public PointCloudLayer read(BitInputStream in) throws IOException {
        int version = in.readBits(16);
        TileId id = new TileId(in.readLongBits(64));
        long dataVersion = in.readLongBits(64);
        DataVersion layerVersion = new DataVersion(dataVersion);
        int scale = in.readBits(8);
        int size = 1024 / scale;
        Resolution res = Resolution.fromSamples(size);
        PointCloudLayer layer = new PointCloudLayer(id, layerVersion, res);
        int count = in.readBits(11);
        for (int i = 0; i < count; ++i) {
            PointCloudData pc = this.pcProtocol.read(in);
            layer.updatePointCloud(pc);
        }
        return layer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(PointCloudLayer layer, OutputStream rawOut) throws IOException {
        try (BitOutputStream out = new BitOutputStream(rawOut);){
            this.write(layer, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PointCloudLayer read(InputStream rawIn) throws IOException {
        try (BitInputStream in = new BitInputStream(rawIn);){
            PointCloudLayer pointCloudLayer = this.read(in);
            return pointCloudLayer;
        }
    }
}

