/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock;

import com.simsilica.mblock.FluidName;
import com.simsilica.mblock.FluidType;
import com.simsilica.mblock.io.FluidTypeData;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;

public class FluidTypeIndex {
    static final long serialVersionUID = 42L;
    private static FluidType[] types;
    private static int typeCount;

    private FluidTypeIndex() {
    }

    public static void initialize(FluidType[] types) {
        if (FluidTypeIndex.types != null) {
            throw new IllegalStateException("FluidTypeIndex is already initialized");
        }
        FluidTypeIndex.types = types;
        typeCount = types.length;
    }

    public static void initialize(FluidTypeData fluidData) {
        FluidTypeIndex.initialize(fluidData.types);
    }

    public static void load(InputStream rawIn) throws IOException {
        FluidTypeData fluidData = FluidTypeData.load(rawIn);
        FluidTypeIndex.reset();
        FluidTypeIndex.initialize(fluidData.types);
    }

    public static void store(OutputStream rawOut) throws IOException {
        FluidTypeData fluidData = new FluidTypeData();
        fluidData.types = types;
        FluidTypeData.store(fluidData, rawOut);
    }

    public static void reset() {
        types = null;
        typeCount = 0;
    }

    public static FluidTypeData toFluidTypeData() {
        return new FluidTypeData(types);
    }

    public static FluidType get(int type) {
        return types[type];
    }

    public static void override(int index, FluidType type) {
        FluidTypeIndex.types[index] = type;
    }

    public static boolean isInitialized() {
        return types != null;
    }

    public static int getTypeCount() {
        return typeCount;
    }

    public static FluidType[] getTypes() {
        return types;
    }

    public static int findType(FluidName name) {
        return FluidTypeIndex.findType(name, -1);
    }

    public static int findType(FluidName name, int defaultValue) {
        for (int i = 0; i < types.length; ++i) {
            FluidType type = types[i];
            if (type == null || !Objects.equals(type.getName(), name)) continue;
            return i;
        }
        return defaultValue;
    }
}

