/*
 * Decompiled with CFR 0.152.
 */
package mythruna.assembly;

import com.google.common.base.MoreObjects;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import java.util.Objects;
import mythruna.assembly.Subassembly;
import mythruna.assembly.TargetName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Joint
extends Subassembly {
    static Logger log = LoggerFactory.getLogger(Joint.class);
    private TargetName restingState;
    private TargetName targetState;
    private Vec3d targetLocation = new Vec3d();
    private Quatd targetOrientation = new Quatd();
    private double duration = 1.0;

    public Joint() {
    }

    public Joint(String jointName) {
        super(jointName, null);
    }

    public Joint(String jointName, TargetName restingState, TargetName targetState) {
        super(jointName, null);
        this.restingState = restingState;
        this.targetState = targetState;
    }

    public boolean matchesVerb(String verb) {
        return Objects.equals(verb, this.restingState.getVerb()) || Objects.equals(verb, this.targetState.getVerb());
    }

    public boolean matchesVerbs(String resting, String target) {
        return Objects.equals(resting, this.restingState.getVerb()) && Objects.equals(target, this.targetState.getVerb());
    }

    public void setRestingState(TargetName restingState) {
        this.restingState = restingState;
    }

    public TargetName getRestingState() {
        return this.restingState;
    }

    public void setTargetState(TargetName targetState) {
        this.targetState = targetState;
    }

    public TargetName getTargetState() {
        return this.targetState;
    }

    public void setTargetLocation(double x, double y, double z) {
        this.setTargetLocation(new Vec3d(x, y, z));
    }

    public void setTargetLocation(Vec3d targetLocation) {
        this.targetLocation.set(targetLocation);
    }

    public Vec3d getTargetLocation() {
        return this.targetLocation;
    }

    public void setTargetOrientation(Quatd targetOrientation) {
        this.targetOrientation.set(targetOrientation);
    }

    public Quatd getTargetOrientation() {
        return this.targetOrientation;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    public double getDuration() {
        return this.duration;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Joint other = (Joint)o;
        if (!Objects.equals(other.restingState, this.restingState)) {
            return false;
        }
        if (!Objects.equals(other.targetState, this.targetState)) {
            return false;
        }
        if (!Objects.equals(other.targetLocation, this.targetLocation)) {
            return false;
        }
        if (!Objects.equals(other.targetOrientation, this.targetOrientation)) {
            return false;
        }
        return other.duration == this.duration;
    }

    @Override
    public boolean isSimilar(Object o, double locEpsilon, double rotEpsilon) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        if (!super.isSimilar(o, locEpsilon, rotEpsilon)) {
            return false;
        }
        Joint other = (Joint)o;
        if (!Objects.equals(other.restingState, this.restingState)) {
            return false;
        }
        if (!Objects.equals(other.targetState, this.targetState)) {
            return false;
        }
        if (!other.targetLocation.isSimilar(this.targetLocation, locEpsilon)) {
            return false;
        }
        if (!other.targetOrientation.isSimilar(this.targetOrientation, rotEpsilon)) {
            return false;
        }
        return other.duration == this.duration;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.restingState, this.targetState, this.targetLocation, this.targetOrientation, this.duration);
    }

    @Override
    protected MoreObjects.ToStringHelper appendToString(MoreObjects.ToStringHelper helper) {
        return super.appendToString(helper).add("restingState", (Object)this.restingState).add("targetState", (Object)this.targetState).add("targetLocation", (Object)this.targetLocation).add("targetOrientation", (Object)this.targetOrientation).add("duration", this.duration);
    }
}

