/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.sound;

import com.jme3.util.SafeArrayList;
import java.util.function.Supplier;
import mythruna.client.sound.Audio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeAudio
implements Audio {
    static Logger log = LoggerFactory.getLogger(CompositeAudio.class);
    private Supplier<Double> volumeSupplier;
    private SafeArrayList<Audio> children = new SafeArrayList(Audio.class);
    private boolean playing = false;

    public CompositeAudio() {
    }

    public CompositeAudio(Supplier<Double> volumeSupplier) {
        this.volumeSupplier = volumeSupplier;
    }

    public void setVolumeSupplier(Supplier<Double> volumeSupplier) {
        this.volumeSupplier = volumeSupplier;
    }

    public Supplier<Double> getVolumeSupplier() {
        return this.volumeSupplier;
    }

    public void addChild(Audio child) {
        log.info("addChild(" + child + ") to :" + this);
        this.children.add((Object)child);
    }

    public void removeChild(Audio child) {
        this.children.remove((Object)child);
    }

    @Override
    public double getVolume() {
        return this.volumeSupplier == null ? 0.0 : this.volumeSupplier.get();
    }

    @Override
    public void update(double baseVolume) {
        boolean playingNow;
        double volume = this.getVolume();
        boolean bl = playingNow = (volume *= baseVolume) > 0.0;
        if (!this.playing && !playingNow) {
            return;
        }
        for (Audio child : (Audio[])this.children.getArray()) {
            child.update(volume);
        }
        this.playing = playingNow;
    }
}

