/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.character;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.jme3.material.MatParamOverride;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.SceneGraphVisitor;
import com.jme3.scene.SceneGraphVisitorAdapter;
import com.jme3.scene.Spatial;
import com.jme3.shader.VarType;
import com.simsilica.crig.CharacterRig;
import com.simsilica.lemur.LayerComparator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import mythruna.client.character.CharacterDecorator;
import mythruna.shape.ShapeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BodyEffectDecorator
implements CharacterDecorator {
    static Logger log = LoggerFactory.getLogger(BodyEffectDecorator.class);
    private String type;
    private CharacterRig rig;
    private Spatial spatial;
    private ShapeName mainName;
    private ShapeName effectName;
    private volatile boolean needsApply;
    private Multimap<Spatial, Consumer<Spatial>> undo = MultimapBuilder.hashKeys().arrayListValues().build();
    private List<MatParamOverride> activeOverrides = new ArrayList<MatParamOverride>();

    public BodyEffectDecorator(String type) {
        this.type = type;
    }

    @Override
    public void setRig(CharacterRig rig) {
        if (this.rig == rig) {
            return;
        }
        this.rig = rig;
        this.needsApply = true;
    }

    @Override
    public void setSpatial(Spatial spatial) {
        this.spatial = spatial;
    }

    @Override
    public void setShapeName(ShapeName name) {
        this.mainName = name;
        this.setEffectName(this.find(this.type, name));
    }

    protected void setEffectName(ShapeName effectName) {
        if (Objects.equals(this.effectName, effectName)) {
            return;
        }
        this.effectName = effectName;
        this.needsApply = true;
    }

    @Override
    public boolean apply() {
        if (!this.needsApply) {
            return false;
        }
        int index = 0;
        if (this.effectName != null) {
            index = Integer.parseInt(this.effectName.getName());
        }
        this.setEffect(index);
        this.needsApply = false;
        return true;
    }

    protected void clearEffects() {
        for (MatParamOverride override : this.activeOverrides) {
            this.spatial.removeMatParamOverride(override);
        }
        this.activeOverrides.clear();
        for (Map.Entry e : this.undo.entries()) {
            ((Consumer)e.getValue()).accept((Spatial)e.getKey());
        }
        this.undo.clear();
    }

    protected void setEffect(int index) {
        if (this.spatial == null) {
            log.error("No spatial to clear effects");
            return;
        }
        switch (index) {
            case 0: {
                this.clearEffects();
                break;
            }
            case 1: {
                this.clearEffects();
                this.setupGhostEffect();
                break;
            }
            case 2: {
                this.clearEffects();
                this.setupStoneEffect();
            }
        }
    }

    protected void setupGhostEffect() {
        float colorScale = 1.2f;
        MatParamOverride effectColor = new MatParamOverride(VarType.Vector4, "EffectColor", (Object)new ColorRGBA(0.5f * colorScale, 0.8f * colorScale, 0.8f * colorScale, 0.9f));
        this.spatial.addMatParamOverride(effectColor);
        this.activeOverrides.add(effectColor);
        MatParamOverride effectType = new MatParamOverride(VarType.Int, "EffectType", (Object)1);
        this.spatial.addMatParamOverride(effectType);
        this.activeOverrides.add(effectType);
        this.visitGeometry(geom -> {
            Material mat = geom.getMaterial();
            RenderState.BlendMode original = mat.getAdditionalRenderState().getBlendMode();
            this.undo.put(geom, g -> ((Geometry)g).getMaterial().getAdditionalRenderState().setBlendMode(original));
            mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.AlphaAdditive);
            mat.getAdditionalRenderState().setDepthWrite(false);
            this.undo.put(geom, g -> ((Geometry)g).getMaterial().getAdditionalRenderState().setDepthWrite(true));
        });
        RenderQueue.Bucket bucket = this.spatial.getQueueBucket();
        this.undo.put((Object)this.spatial, s -> s.setQueueBucket(bucket));
        this.spatial.setQueueBucket(RenderQueue.Bucket.Transparent);
        Integer originalLayer = LayerComparator.getLayer((Spatial)this.spatial);
        LayerComparator.setLayer((Spatial)this.spatial, (int)9);
        this.undo.put((Object)this.spatial, s -> LayerComparator.setLayer((Spatial)this.spatial, (int)(originalLayer == null ? 0 : originalLayer)));
    }

    protected void setupStoneEffect() {
        this.clearEffects();
        float colorScale = 1.0f;
        MatParamOverride effectColor = new MatParamOverride(VarType.Vector4, "EffectColor", (Object)new ColorRGBA(0.75f * colorScale, 0.75f * colorScale, 0.75f * colorScale, 1.0f));
        this.spatial.addMatParamOverride(effectColor);
        this.activeOverrides.add(effectColor);
        MatParamOverride effectType = new MatParamOverride(VarType.Int, "EffectType", (Object)2);
        this.spatial.addMatParamOverride(effectType);
        this.activeOverrides.add(effectType);
        MatParamOverride alphaDiscard = new MatParamOverride(VarType.Float, "AlphaDiscardThreshold", (Object)Float.valueOf(0.95f));
        this.spatial.addMatParamOverride(alphaDiscard);
        this.activeOverrides.add(alphaDiscard);
    }

    protected void visitGeometry(final Consumer<Geometry> apply) {
        this.spatial.depthFirstTraversal((SceneGraphVisitor)new SceneGraphVisitorAdapter(this){

            public void visit(Geometry geom) {
                apply.accept(geom);
            }
        });
    }

    protected ShapeName find(String type, ShapeName name) {
        if (type.equals(name.getType())) {
            return name;
        }
        for (ShapeName sub : name.getAddOns()) {
            if (!type.equals(sub.getType())) continue;
            return sub;
        }
        return null;
    }
}

