/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.filter;

import com.google.common.base.Objects;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.EntityComponent;
import java.lang.reflect.Field;

public class FieldFilter<T extends EntityComponent>
implements ComponentFilter<T> {
    private Class<T> type;
    private Field field;
    private Object value;
    private transient boolean initialized = false;

    public FieldFilter() {
    }

    public FieldFilter(Class<T> type, String field, Object value) {
        try {
            this.type = type;
            this.field = type.getDeclaredField(field);
            this.field.setAccessible(true);
            this.value = value;
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Field not found:" + field + " on type:" + type, e);
        }
    }

    public static <T extends EntityComponent> FieldFilter<T> create(Class<T> type, String field, Object value) {
        return new FieldFilter<T>(type, field, value);
    }

    public String getFieldName() {
        return this.field.getName();
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public Class<T> getComponentType() {
        return this.type;
    }

    @Override
    public boolean evaluate(EntityComponent c) {
        if (!this.type.isInstance(c)) {
            return false;
        }
        try {
            if (!this.initialized) {
                this.field.setAccessible(true);
                this.initialized = true;
            }
            Object val = this.field.get(c);
            return Objects.equal((Object)this.value, (Object)val);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error retrieving field[" + this.field + "] of:" + c, e);
        }
    }

    public String toString() {
        return "FieldFilter[" + this.field + " == " + this.value + "]";
    }
}

