/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.shape;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class PQTorus
extends Mesh {
    private float p;
    private float q;
    private float radius;
    private float width;
    private int steps;
    private int radialSamples;

    public PQTorus() {
    }

    public PQTorus(float p, float q, float radius, float width, int steps, int radialSamples) {
        this.updateGeometry(p, q, radius, width, steps, radialSamples);
    }

    public float getP() {
        return this.p;
    }

    public float getQ() {
        return this.q;
    }

    public int getRadialSamples() {
        return this.radialSamples;
    }

    public float getRadius() {
        return this.radius;
    }

    public int getSteps() {
        return this.steps;
    }

    public float getWidth() {
        return this.width;
    }

    public void updateGeometry(float p, float q, float radius, float width, int steps, int radialSamples) {
        int i;
        this.p = p;
        this.q = q;
        this.radius = radius;
        this.width = width;
        this.steps = steps;
        this.radialSamples = radialSamples;
        float thetaStep = (float)Math.PI * 2 / (float)steps;
        float betaStep = (float)Math.PI * 2 / (float)radialSamples;
        Vector3f[] torusPoints = new Vector3f[steps];
        int vertCount = radialSamples * steps;
        FloatBuffer fpb = BufferUtils.createVector3Buffer(vertCount);
        FloatBuffer fnb = BufferUtils.createVector3Buffer(vertCount);
        FloatBuffer ftb = BufferUtils.createVector2Buffer(vertCount);
        Vector3f tempNorm = new Vector3f();
        float theta = 0.0f;
        int nVertex = 0;
        for (int i2 = 0; i2 < steps; ++i2) {
            float circleFraction = (float)i2 / (float)steps;
            float r = 0.5f * (2.0f + FastMath.sin(q * (theta += thetaStep))) * radius;
            float x = r * FastMath.cos(p * theta) * radius;
            float y = r * FastMath.sin(p * theta) * radius;
            float z = r * FastMath.cos(q * theta) * radius;
            torusPoints[i2] = new Vector3f(x, y, z);
            r = 0.5f * (2.0f + FastMath.sin(q * (theta + 0.01f))) * radius;
            x = r * FastMath.cos(p * (theta + 0.01f)) * radius;
            y = r * FastMath.sin(p * (theta + 0.01f)) * radius;
            z = r * FastMath.cos(q * (theta + 0.01f)) * radius;
            Vector3f pointB = new Vector3f(x, y, z);
            Vector3f T = pointB.subtract(torusPoints[i2]);
            Vector3f N = torusPoints[i2].add(pointB);
            Vector3f B = T.cross(N);
            N = B.cross(T);
            N = N.normalize();
            B = B.normalize();
            float beta = 0.0f;
            int j = 0;
            while (j < radialSamples) {
                float cx = FastMath.cos(beta += betaStep) * width;
                float cy = FastMath.sin(beta) * width;
                float radialFraction = (float)j / (float)radialSamples;
                tempNorm.x = cx * N.x + cy * B.x;
                tempNorm.y = cx * N.y + cy * B.y;
                tempNorm.z = cx * N.z + cy * B.z;
                fnb.put(tempNorm.x).put(tempNorm.y).put(tempNorm.z);
                tempNorm.addLocal(torusPoints[i2]);
                fpb.put(tempNorm.x).put(tempNorm.y).put(tempNorm.z);
                ftb.put(radialFraction).put(circleFraction);
                ++j;
                ++nVertex;
            }
        }
        ShortBuffer sib = BufferUtils.createShortBuffer(6 * vertCount);
        for (i = 0; i < vertCount; ++i) {
            sib.put(new short[]{(short)i, (short)(i - radialSamples), (short)(i + 1), (short)(i + 1), (short)(i - radialSamples), (short)(i - radialSamples + 1)});
        }
        int len = sib.capacity();
        for (i = 0; i < len; ++i) {
            int ind = sib.get(i);
            if (ind < 0) {
                sib.put(i, (short)(ind += vertCount));
                continue;
            }
            if (ind < vertCount) continue;
            sib.put(i, (short)(ind -= vertCount));
        }
        sib.rewind();
        this.setBuffer(VertexBuffer.Type.Position, 3, fpb);
        this.setBuffer(VertexBuffer.Type.Normal, 3, fnb);
        this.setBuffer(VertexBuffer.Type.TexCoord, 2, ftb);
        this.setBuffer(VertexBuffer.Type.Index, 3, sib);
        this.updateBound();
    }

    @Override
    public void read(JmeImporter e) throws IOException {
        super.read(e);
        InputCapsule capsule = e.getCapsule(this);
        this.p = capsule.readFloat("p", 0.0f);
        this.q = capsule.readFloat("q", 0.0f);
        this.radius = capsule.readFloat("radius", 0.0f);
        this.width = capsule.readFloat("width", 0.0f);
        this.steps = capsule.readInt("steps", 0);
        this.radialSamples = capsule.readInt("radialSamples", 0);
    }

    @Override
    public void write(JmeExporter e) throws IOException {
        super.write(e);
        OutputCapsule capsule = e.getCapsule(this);
        capsule.write(this.p, "p", 0.0f);
        capsule.write(this.q, "q", 0.0f);
        capsule.write(this.radius, "radius", 0.0f);
        capsule.write(this.width, "width", 0.0f);
        capsule.write(this.steps, "steps", 0);
        capsule.write(this.radialSamples, "radialSamples", 0);
    }
}

