/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.phys;

import com.google.common.base.MoreObjects;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.phys.CellArrayPart;
import com.simsilica.mblock.phys.Part;
import com.simsilica.mphys.AbstractShape;
import com.simsilica.mphys.BodyMass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBlockShape
extends AbstractShape {
    static Logger log = LoggerFactory.getLogger(MBlockShape.class);
    private Part part;
    private long lastPartVersion;

    public MBlockShape(Part part) {
        super(part.getMass().getCog(), part.getMass().getRadius(), part.getMass());
        this.part = part;
        this.lastPartVersion = part.getVersion();
    }

    public Part getPart() {
        return this.part;
    }

    public long getVersion() {
        return this.part.getVersion();
    }

    public BodyMass getMass() {
        if (this.lastPartVersion < this.part.getVersion()) {
            this.updateMass();
        }
        return super.getMass();
    }

    protected void updateMass() {
        this.setBoundsInfo(this.part.getMass().getCog(), this.part.getMass().getRadius(), this.part.getMass());
        this.lastPartVersion = this.part.getVersion();
    }

    public Vec3d shapeToBody(Vec3d shapeSpace, Vec3d store) {
        if (store == null) {
            store = shapeSpace.clone();
        } else {
            store.set(shapeSpace);
        }
        store.subtractLocal(this.part.getMass().getCog());
        return store;
    }

    public Vec3d bodyToShape(Vec3d bodySpace, Vec3d store) {
        if (store == null) {
            store = bodySpace.clone();
        } else {
            store.set(bodySpace);
        }
        store.addLocal(this.part.getMass().getCog());
        return store;
    }

    public static MBlockShape createShape(String name, CellArray cells, double scale, double mass) {
        return new MBlockShape(CellArrayPart.createShape(name, cells, scale, mass));
    }

    public static MBlockShape createShape(CellArray cells, double scale, double mass) {
        return new MBlockShape(CellArrayPart.createShape(cells, scale, mass));
    }

    public static MBlockShape createGhost(double radius) {
        return new MBlockShape(CellArrayPart.createGhost(radius));
    }

    public static MBlockShape createSphere(double radius, double mass) {
        return new MBlockShape(CellArrayPart.createSphere(radius, mass));
    }

    public static MBlockShape createSphere(String name, double radius, double mass) {
        return new MBlockShape(CellArrayPart.createSphere(name, radius, mass));
    }

    public static MBlockShape createCube(double extents) {
        return new MBlockShape(CellArrayPart.createCube(extents));
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)((Object)((Object)this)).getClass().getSimpleName()).omitNullValues().add("part", (Object)this.part).toString();
    }
}

