/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.local;

import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.LightUtils;
import com.simsilica.mworld.CellChangeEvent;
import com.simsilica.mworld.CellChangeListener;
import com.simsilica.mworld.LightData;
import com.simsilica.mworld.transaction.CellEdit;
import java.util.Objects;
import mythruna.world.local.AbstractLocalSpaceValue;
import mythruna.world.local.BasisData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightValue
extends AbstractLocalSpaceValue<Integer, LightData>
implements CellChangeListener {
    static Logger log = LoggerFactory.getLogger(LightValue.class);
    private Vec3i cell = new Vec3i();

    public LightValue(BasisData<LightData> basis) {
        super(basis, -1);
    }

    public int getSun() {
        return LightUtils.sun((int)((Integer)this.getObject()));
    }

    @Override
    public void updatePosition(Vec3d pos, Vec3i newCell, Vec3d look) {
        if (this.cell.equals((Object)newCell)) {
            return;
        }
        this.cell.set(newCell);
        this.invalidate();
    }

    public void cellChanged(CellChangeEvent event) {
        if (this.isInvalid()) {
            return;
        }
        CellEdit[] edits = event.getLightChanges();
        if (edits == null) {
            return;
        }
        if (!Objects.equals(event.getLeafId(), ((LightData)this.getData()).getLeafId())) {
            return;
        }
        this.invalidate();
    }

    @Override
    protected Integer loadValue() {
        Vec3i origin = ((LightData)this.getData()).getLeafId().getWorld(null);
        int i = this.cell.x - origin.x;
        int j = this.cell.y - origin.y;
        int k = this.cell.z - origin.z;
        if (i >= 0 && i < 32 && j >= 0 && j < 32 && k >= 0 && k < 32) {
            return ((LightData)this.getData()).getCell(i, j, k);
        }
        return 0;
    }
}

