/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur;

import com.jme3.math.ColorRGBA;
import com.simsilica.lemur.Button;
import com.simsilica.lemur.CheckboxModel;
import com.simsilica.lemur.Command;
import com.simsilica.lemur.DefaultCheckboxModel;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.VAlignment;
import com.simsilica.lemur.component.IconComponent;
import com.simsilica.lemur.component.QuadBackgroundComponent;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.Attributes;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.style.StyleAttribute;
import com.simsilica.lemur.style.StyleDefaults;
import com.simsilica.lemur.style.Styles;

public class Checkbox
extends Button {
    public static final String ELEMENT_ID = "checkbox";
    public static final Command<Button> TOGGLE_COMMAND = new ToggleCommand();
    private CheckboxModel model;
    private VersionedReference<Boolean> state;
    private GuiComponent onView;
    private GuiComponent offView;

    public Checkbox(String s) {
        this(s, null, true, new ElementId(ELEMENT_ID), null);
    }

    public Checkbox(String s, String style) {
        this(s, null, true, new ElementId(ELEMENT_ID), style);
    }

    public Checkbox(String s, ElementId elementId, String style) {
        this(s, null, true, elementId, style);
    }

    public Checkbox(String s, CheckboxModel model, ElementId elementId, String style) {
        this(s, model, true, elementId, style);
    }

    public Checkbox(String s, CheckboxModel model) {
        this(s, model, true, new ElementId(ELEMENT_ID), null);
    }

    public Checkbox(String s, CheckboxModel model, String style) {
        this(s, model, true, new ElementId(ELEMENT_ID), style);
    }

    protected Checkbox(String s, CheckboxModel model, boolean applyStyles, ElementId elementId, String style) {
        super(s, false, elementId, style);
        this.setModel(model == null ? new DefaultCheckboxModel() : model);
        Styles styles = GuiGlobals.getInstance().getStyles();
        if (applyStyles) {
            styles.applyStyles((Object)this, elementId, style);
        }
        this.setupCommands();
    }

    protected final void setupCommands() {
        this.addCommands(Button.ButtonAction.Click, TOGGLE_COMMAND);
    }

    @StyleDefaults(value="checkbox")
    public static void initializeDefaultStyles(Attributes attrs) {
        IconComponent on = new IconComponent("/com/simsilica/lemur/icons/Check.png", 1.2f, 2.0f, 2.0f, 0.01f, false);
        IconComponent off = new IconComponent("/com/simsilica/lemur/icons/Check.png", 1.2f, 2.0f, 2.0f, 0.01f, false);
        off.setColor(new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f));
        attrs.set("background", new QuadBackgroundComponent(new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f)), false);
        attrs.set("onView", on, false);
        attrs.set("offView", off, false);
        attrs.set("textVAlignment", (Object)VAlignment.Center, false);
    }

    public void setModel(CheckboxModel model) {
        if (this.model == model) {
            return;
        }
        this.model = model;
        this.state = model.createReference();
        this.resetStateView();
    }

    public CheckboxModel getModel() {
        return this.model;
    }

    protected void setStateView(GuiComponent c) {
        this.setIcon(c);
    }

    protected void resetStateView() {
        this.setStateView(this.isChecked() ? this.onView : this.offView);
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.state.update()) {
            this.resetStateView();
        }
    }

    public void setChecked(boolean b) {
        this.getModel().setChecked(b);
    }

    public boolean isChecked() {
        if (this.getModel() == null) {
            return false;
        }
        return this.getModel().isChecked();
    }

    @StyleAttribute(value="onView", lookupDefault=false)
    public void setOnView(GuiComponent c) {
        if (this.onView == c) {
            return;
        }
        this.onView = c.clone();
        this.resetStateView();
    }

    public GuiComponent getOnView() {
        return this.onView;
    }

    @StyleAttribute(value="offView", lookupDefault=false)
    public void setOffView(GuiComponent c) {
        if (this.onView == c) {
            return;
        }
        this.offView = c.clone();
        this.resetStateView();
    }

    public GuiComponent getOffView() {
        return this.offView;
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "[text=" + this.getText() + ", state=" + this.isChecked() + ", color=" + this.getColor() + ", elementId=" + this.getElementId() + "]";
    }

    protected static class ToggleCommand
    implements Command<Button> {
        protected ToggleCommand() {
        }

        @Override
        public void execute(Button source) {
            if (source instanceof Checkbox) {
                Checkbox cb;
                cb.setChecked(!(cb = (Checkbox)source).isChecked());
            }
        }
    }
}

