/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.asset.AssetManager;
import com.jme3.asset.TextureKey;
import com.jme3.font.BitmapFont;
import com.jme3.material.MatParam;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.GeometryComparator;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Spatial;
import com.jme3.system.JmeContext;
import com.jme3.texture.Texture;
import com.simsilica.lemur.LayerComparator;
import com.simsilica.lemur.anim.AnimationState;
import com.simsilica.lemur.component.Text2d;
import com.simsilica.lemur.component.TextComponent;
import com.simsilica.lemur.core.GuiMaterial;
import com.simsilica.lemur.core.LightingMaterialAdapter;
import com.simsilica.lemur.core.UnshadedMaterialAdapter;
import com.simsilica.lemur.event.KeyInterceptState;
import com.simsilica.lemur.event.KeyListener;
import com.simsilica.lemur.event.MouseAppState;
import com.simsilica.lemur.event.PopupState;
import com.simsilica.lemur.event.TouchAppState;
import com.simsilica.lemur.focus.FocusManagerState;
import com.simsilica.lemur.focus.FocusNavigationState;
import com.simsilica.lemur.input.InputMapper;
import com.simsilica.lemur.style.Styles;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiGlobals {
    static Logger log = LoggerFactory.getLogger(GuiGlobals.class);
    private static GuiGlobals instance;
    private AssetManager assets;
    private InputMapper inputMapper;
    private KeyInterceptState keyInterceptor;
    private MouseAppState mouseState;
    private TouchAppState touchState;
    private FocusManagerState focusState;
    private FocusNavigationState focusNavState;
    private AnimationState animationState;
    private PopupState popupState;
    private String iconBase;
    private Function<String, Text2d> textFactory = new DefaultTextFactory();
    private Styles styles;
    private boolean gammaEnabled;
    static final float GAMMA = 2.2f;

    public static void initialize(Application app) {
        GuiGlobals.setInstance(new GuiGlobals(app));
    }

    public static void setInstance(GuiGlobals globals) {
        instance = globals;
        log.info("Initializing GuiGlobals with:" + globals);
        instance.logBuildInfo();
    }

    public static GuiGlobals getInstance() {
        return instance;
    }

    protected boolean isHeadless(Application app) {
        JmeContext.Type type = app.getContext().getType();
        return type == JmeContext.Type.Headless;
    }

    protected GuiGlobals(Application app) {
        this.assets = app.getAssetManager();
        if (this.isHeadless(app)) {
            this.styles = new Styles();
            this.setDefaultStyles();
            this.iconBase = this.getClass().getPackage().getName().replace('.', '/') + "/icons";
            return;
        }
        this.keyInterceptor = new KeyInterceptState(app);
        if (app.getContext().getTouchInput() == null) {
            this.mouseState = new MouseAppState(app);
        } else {
            this.touchState = new TouchAppState(app);
        }
        this.inputMapper = new InputMapper(app.getInputManager());
        this.focusState = new FocusManagerState();
        this.focusNavState = new FocusNavigationState(this.inputMapper, this.focusState);
        this.animationState = new AnimationState();
        this.popupState = new PopupState();
        this.focusState.setFocusNavigationState(this.focusNavState);
        app.getStateManager().attach((AppState)this.keyInterceptor);
        if (this.mouseState != null) {
            app.getStateManager().attach((AppState)this.mouseState);
        }
        if (this.touchState != null) {
            app.getStateManager().attach((AppState)this.touchState);
        }
        app.getStateManager().attach((AppState)this.focusState);
        app.getStateManager().attach((AppState)this.focusNavState);
        app.getStateManager().attach((AppState)this.animationState);
        app.getStateManager().attach((AppState)this.popupState);
        this.styles = new Styles();
        this.setDefaultStyles();
        this.iconBase = this.getClass().getPackage().getName().replace('.', '/') + "/icons";
        ViewPort main = app.getViewPort();
        this.setupGuiComparators(main);
        this.setCursorEventsEnabled(true);
        this.gammaEnabled = app.getContext().getSettings().isGammaCorrection();
    }

    protected AssetManager getAssetManager() {
        return this.assets;
    }

    protected String getIconBase() {
        return this.iconBase;
    }

    protected void logBuildInfo() {
        try {
            URL u = Resources.getResource((String)"lemur.build.date");
            String build = Resources.toString((URL)u, (Charset)Charsets.UTF_8);
            log.info("Lemur build date:" + build);
        }
        catch (Exception e) {
            log.error("Error reading build info", (Throwable)e);
        }
    }

    public void setupGuiComparators(ViewPort view) {
        RenderQueue rq = view.getQueue();
        rq.setGeometryComparator(RenderQueue.Bucket.Opaque, (GeometryComparator)new LayerComparator(rq.getGeometryComparator(RenderQueue.Bucket.Opaque), -1));
        rq.setGeometryComparator(RenderQueue.Bucket.Transparent, (GeometryComparator)new LayerComparator(rq.getGeometryComparator(RenderQueue.Bucket.Transparent), -1));
        rq.setGeometryComparator(RenderQueue.Bucket.Translucent, (GeometryComparator)new LayerComparator(rq.getGeometryComparator(RenderQueue.Bucket.Translucent), -1));
        rq.setGeometryComparator(RenderQueue.Bucket.Gui, (GeometryComparator)new LayerComparator(rq.getGeometryComparator(RenderQueue.Bucket.Gui), -1));
    }

    protected void setDefaultStyles() {
        this.styles.setDefault(this.loadFont("Interface/Fonts/Default.fnt"));
        this.styles.setDefault(ColorRGBA.LightGray);
        this.styles.getSelector(null).set("color", ColorRGBA.White);
        this.styles.getSelector(null).set("fontName", "Interface/Fonts/Default.fnt");
    }

    public Styles getStyles() {
        return this.styles;
    }

    public InputMapper getInputMapper() {
        return this.inputMapper;
    }

    public AnimationState getAnimationState() {
        return this.animationState;
    }

    public PopupState getPopupState() {
        return this.popupState;
    }

    public FocusManagerState getFocusManagerState() {
        return this.focusState;
    }

    public FocusNavigationState getFocusNavigationState() {
        return this.focusNavState;
    }

    public void fixFont(BitmapFont font) {
        for (int i = 0; i < font.getPageSize(); ++i) {
            Material m = font.getPage(i);
            m.setFloat("AlphaDiscardThreshold", 0.1f);
        }
    }

    private Texture getTexture(Material mat, String name) {
        MatParam mp = mat.getParam(name);
        if (mp == null) {
            return null;
        }
        return (Texture)mp.getValue();
    }

    public void lightFont(BitmapFont font) {
        Material[] pages = new Material[font.getPageSize()];
        for (int i = 0; i < pages.length; ++i) {
            Material original = font.getPage(i);
            Material m = new Material(this.assets, "Common/MatDefs/Light/Lighting.j3md");
            m.setTexture("DiffuseMap", this.getTexture(original, "ColorMap"));
            pages[i] = m;
        }
        font.setPages(pages);
    }

    public BitmapFont loadFont(String path) {
        BitmapFont result = this.assets.loadFont(path);
        this.fixFont(result);
        return result;
    }

    public Text2d createText2d(String fontName) {
        if (this.textFactory == null) {
            throw new UnsupportedOperationException("No text2D factory is configured.");
        }
        return this.textFactory.apply(fontName);
    }

    public void setTextFactory(Function<String, Text2d> textFactory) {
        this.textFactory = textFactory;
    }

    public Function<String, Text2d> getTextFactory() {
        return this.textFactory;
    }

    public GuiMaterial createMaterial(boolean lit) {
        if (lit) {
            return new LightingMaterialAdapter(new Material(this.assets, "Common/MatDefs/Light/Lighting.j3md"));
        }
        return new UnshadedMaterialAdapter(new Material(this.assets, "Common/MatDefs/Misc/Unshaded.j3md"));
    }

    public GuiMaterial createMaterial(ColorRGBA color, boolean lit) {
        GuiMaterial mat = this.createMaterial(lit);
        mat.setColor(color);
        return mat;
    }

    public GuiMaterial createMaterial(Texture texture, boolean lit) {
        GuiMaterial mat = this.createMaterial(lit);
        mat.setTexture(texture);
        return mat;
    }

    public Texture loadDefaultIcon(String name) {
        return this.loadTexture(this.iconBase + "/" + name, false, false);
    }

    public Texture loadTexture(String path, boolean repeat, boolean generateMips) {
        TextureKey key = new TextureKey(path);
        key.setGenerateMips(generateMips);
        Texture t = this.assets.loadTexture(key);
        if (t == null) {
            throw new RuntimeException("Error loading texture:" + path);
        }
        if (repeat) {
            t.setWrap(Texture.WrapMode.Repeat);
        } else {
            t.setWrap(Texture.WrapMode.EdgeClamp);
        }
        return t;
    }

    public ColorRGBA srgbaColor(float r, float g, float b, float a) {
        if (this.gammaEnabled) {
            return new ColorRGBA().setAsSrgb(r, g, b, a);
        }
        return new ColorRGBA(r, g, b, a);
    }

    public ColorRGBA srgbaColor(ColorRGBA srgbColor) {
        return this.srgbaColor(srgbColor.r, srgbColor.g, srgbColor.b, srgbColor.a);
    }

    public void requestFocus(Spatial s) {
        this.focusState.setFocus(s);
    }

    public void releaseFocus(Spatial s) {
        this.focusState.releaseFocus(s);
    }

    public Spatial getCurrentFocus() {
        return this.focusState.getFocus();
    }

    public void addKeyListener(KeyListener l) {
        this.keyInterceptor.addKeyListener(l);
    }

    public void removeKeyListener(KeyListener l) {
        this.keyInterceptor.removeKeyListener(l);
    }

    @Deprecated
    public ViewPort getCollisionViewPort(Spatial s) {
        if (this.mouseState != null) {
            return this.mouseState.findViewPort(s);
        }
        if (this.touchState != null) {
            return this.touchState.findViewPort(s);
        }
        return null;
    }

    public void requestCursorEnabled(Object owner) {
        if (this.mouseState != null) {
            this.mouseState.requestEnabled(owner);
        }
        if (this.touchState != null) {
            this.touchState.requestEnabled(owner);
        }
        if (this.focusNavState != null) {
            this.focusNavState.setEnabled(this.isCursorEventsEnabled());
        }
    }

    public boolean releaseCursorEnabled(Object owner) {
        boolean result = false;
        if (this.mouseState != null && this.mouseState.releaseEnabled(owner)) {
            result = true;
        }
        if (this.touchState != null && this.touchState.releaseEnabled(owner)) {
            result = true;
        }
        if (this.focusNavState != null) {
            this.focusNavState.setEnabled(result);
        }
        return result;
    }

    public boolean hasRequestedCursorEnabled(Object owner) {
        if (this.mouseState != null) {
            return this.mouseState.hasRequestedEnabled(owner);
        }
        if (this.touchState != null) {
            return this.touchState.hasRequestedEnabled(owner);
        }
        return false;
    }

    @Deprecated
    public void setMouseEventsEnabled(boolean f) {
        this.setCursorEventsEnabled(f);
    }

    public void setCursorEventsEnabled(boolean f) {
        this.setCursorEventsEnabled(f, false);
    }

    public void setCursorEventsEnabled(boolean f, boolean force) {
        if (force) {
            if (this.mouseState != null) {
                this.mouseState.setEnabled(f);
            }
            if (this.touchState != null) {
                this.touchState.setEnabled(f);
            }
            if (this.focusNavState != null) {
                this.focusNavState.setEnabled(f);
            }
        } else if (f) {
            this.requestCursorEnabled(this);
        } else if (this.hasRequestedCursorEnabled(this)) {
            this.releaseCursorEnabled(this);
        }
    }

    @Deprecated
    public boolean isMouseEventsEnabled() {
        return this.isCursorEventsEnabled();
    }

    public boolean isCursorEventsEnabled() {
        if (this.mouseState != null) {
            return this.mouseState.isEnabled();
        }
        if (this.touchState != null) {
            return this.touchState.isEnabled();
        }
        return false;
    }

    @Deprecated
    public Vector3f getScreenCoordinates(Spatial relativeTo, Vector3f pos) {
        ViewPort vp = this.getCollisionViewPort(relativeTo);
        if (vp == null) {
            throw new RuntimeException("Could not find viewport for:" + relativeTo);
        }
        pos = relativeTo.localToWorld(pos, null);
        Camera cam = vp.getCamera();
        if (cam.isParallelProjection()) {
            return pos.clone();
        }
        return cam.getScreenCoordinates(pos);
    }

    private static class DefaultTextFactory
    implements Function<String, Text2d> {
        private DefaultTextFactory() {
        }

        @Override
        public Text2d apply(String fontName) {
            if (log.isDebugEnabled()) {
                log.debug("createText2d(" + fontName + ")");
            }
            BitmapFont font = GuiGlobals.getInstance().loadFont(fontName);
            return new TextComponent("", font);
        }
    }
}

