/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.opengl.lwjgl2;

import com.jme3.system.NativeLibraryLoader;
import java.util.ArrayList;
import java.util.List;
import mythruna.client.opengl.DisplayModeProvider;
import mythruna.client.opengl.ModeInfo;
import mythruna.client.opengl.Resolution;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lwjgl2DisplayModeProvider
implements DisplayModeProvider {
    static Logger log = LoggerFactory.getLogger(Lwjgl2DisplayModeProvider.class);
    private static ModeInfo screenMode;

    protected static ModeInfo toModeInfo(DisplayMode mode) {
        return Lwjgl2DisplayModeProvider.toModeInfo(mode, mode.isFullscreenCapable());
    }

    protected static ModeInfo toModeInfo(DisplayMode mode, boolean fullscreen) {
        return new ModeInfo(new Resolution(mode.getWidth(), mode.getHeight()), mode.getFrequency(), mode.getBitsPerPixel(), fullscreen);
    }

    @Override
    public List<ModeInfo> getDisplayModes() {
        try {
            ArrayList<ModeInfo> results = new ArrayList<ModeInfo>();
            for (DisplayMode mode : Display.getAvailableDisplayModes()) {
                if (mode.isFullscreenCapable()) {
                    results.add(Lwjgl2DisplayModeProvider.toModeInfo(mode));
                    if (mode.getBitsPerPixel() != screenMode.getBitsPerPixel() || Math.abs(mode.getFrequency() - screenMode.getFrequency()) >= 2) continue;
                    results.add(Lwjgl2DisplayModeProvider.toModeInfo(mode, false));
                    continue;
                }
                results.add(Lwjgl2DisplayModeProvider.toModeInfo(mode, false));
            }
            return results;
        }
        catch (LWJGLException e) {
            throw new RuntimeException("Error retrieving display modes", e);
        }
    }

    @Override
    public ModeInfo getCurrentDisplayMode() {
        return Lwjgl2DisplayModeProvider.toModeInfo(Display.getDesktopDisplayMode());
    }

    @Override
    public ModeInfo getScreenDisplayMode() {
        return screenMode;
    }

    static {
        NativeLibraryLoader.loadNativeLibrary((String)"lwjgl", (boolean)true);
        screenMode = Lwjgl2DisplayModeProvider.toModeInfo(Display.getDesktopDisplayMode());
    }
}

