/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.account.base.json;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapValueTypeAdapterFactory
implements TypeAdapterFactory {
    static Logger log = LoggerFactory.getLogger(MapValueTypeAdapterFactory.class);
    private TypeToken<?> mapType;
    private Set<Class> resolve = new HashSet<Class>();
    private Map<String, Class> classIndex = new HashMap<String, Class>();

    public MapValueTypeAdapterFactory(Class baseType, Class ... resolveTypes) {
        this(TypeToken.getParameterized((Type)baseType, (Type[])new Type[]{String.class, Object.class}), resolveTypes);
    }

    public MapValueTypeAdapterFactory(TypeToken<?> mapType, Class ... resolveTypes) {
        this.mapType = mapType;
        this.resolve = new HashSet<Class>(Arrays.asList(resolveTypes));
        for (Class c : this.resolve) {
            this.classIndex.put(c.getSimpleName(), c);
        }
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (!Objects.equals(type, this.mapType)) {
            return null;
        }
        MapAdapter result = new MapAdapter(gson);
        return result;
    }

    private class MapAdapter<K, V>
    extends TypeAdapter<Map<K, V>> {
        private Gson gson;
        private TypeAdapter<V> valueAdapter;

        public MapAdapter(Gson gson) {
            this.gson = gson;
            TypeToken token = TypeToken.get(Object.class);
            this.valueAdapter = gson.getAdapter(token);
        }

        public Map<K, V> read(JsonReader in) throws IOException {
            JsonToken peek = in.peek();
            if (peek == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (peek != JsonToken.BEGIN_OBJECT) {
                throw new JsonSyntaxException("Expected object but found:" + peek);
            }
            in.beginObject();
            while (in.hasNext()) {
                String name = in.nextName();
                int split = name.lastIndexOf(":");
                if (split < 0) {
                    map.put(name, this.valueAdapter.read(in));
                    continue;
                }
                String cName = name.substring(split + 1);
                name = name.substring(0, split);
                Class type = (Class)MapValueTypeAdapterFactory.this.classIndex.get(cName);
                Object value = this.gson.getAdapter(TypeToken.get((Class)type)).read(in);
                map.put(name, value);
            }
            in.endObject();
            return map;
        }

        public void write(JsonWriter out, Map<K, V> map) throws IOException {
            if (map == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            for (Map.Entry<K, V> entry : map.entrySet()) {
                if (entry.getValue() == null) continue;
                Class<?> c = entry.getValue().getClass();
                if (!MapValueTypeAdapterFactory.this.resolve.contains(c)) {
                    out.name(String.valueOf(entry.getKey()));
                    this.valueAdapter.write(out, entry.getValue());
                    continue;
                }
                out.name(String.valueOf(entry.getKey()) + ":" + c.getSimpleName());
                this.valueAdapter.write(out, entry.getValue());
            }
            out.endObject();
        }
    }
}

