/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mphys;

import com.simsilica.mathd.Vec3d;
import com.simsilica.mphys.AbstractShape;
import com.simsilica.mphys.Contact;
import com.simsilica.mphys.ContactResolver;
import com.simsilica.mphys.Joint;
import com.simsilica.mphys.RigidBody;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TandemContactResolver<K, S extends AbstractShape>
implements ContactResolver<K, S> {
    static Logger log = LoggerFactory.getLogger(TandemContactResolver.class);
    protected boolean resolveJoints = true;
    private static Accumulator nullAccumulator = new Accumulator();

    @Override
    public void resolveContacts(List<Contact<K, S>> contacts, List<Joint<K, S>> joints, double step) {
        HashMap<RigidBody<K, S>, Accumulator> accumulators = new HashMap<RigidBody<K, S>, Accumulator>();
        this.resolvePenetration(contacts, joints, step, accumulators);
        this.resolveVelocity(contacts, joints, step, accumulators);
    }

    protected void resolvePenetration(List<Contact<K, S>> contacts, List<Joint<K, S>> joints, double step, Map<RigidBody<K, S>, Accumulator> accumulators) {
        Vec3d linear1 = new Vec3d();
        Vec3d angular1 = new Vec3d();
        Vec3d linear2 = new Vec3d();
        Vec3d angular2 = new Vec3d();
        for (Contact<K, S> contact : contacts) {
            if (!contact.isEnabled()) continue;
            contact.matchLocalTemperature();
            double localTemperature = contact.localTemperature;
            if (RigidBody.isCold(localTemperature)) continue;
            contact.calculateInternals(step * localTemperature);
            contact.calculatePositionChange(linear1, linear2, angular1, angular2, contact.penetration);
            if (Double.isNaN(linear1.x)) {
                log.error("Contact produced NaN position adjustment:" + contact);
            }
            this.getAccumulator(contact.body1, accumulators).accumulate(linear1, angular1);
            this.getAccumulator(contact.getBody2(), accumulators).accumulate(linear2, angular2);
        }
        if (this.resolveJoints) {
            for (Joint joint : joints) {
                if (joint.isSleepy()) continue;
                joint.calculateInternals(step);
                joint.calculatePositionChange(linear1, linear2, angular1, angular2);
                if (Double.isNaN(linear1.x)) {
                    log.error("Joint produced NaN position adjustment:" + joint);
                }
                this.getAccumulator(joint.getMainBody(), accumulators).accumulate(linear1, angular1);
                this.getAccumulator(joint.getAltBody(), accumulators).accumulate(linear2, angular2);
            }
        }
        Vec3d lin = linear1.set(0.0, 0.0, 0.0);
        Vec3d vec3d = angular1.set(0.0, 0.0, 0.0);
        for (Map.Entry<RigidBody<K, S>, Accumulator> e : accumulators.entrySet()) {
            RigidBody<K, S> b = e.getKey();
            Accumulator acc = e.getValue();
            Vec3d l = acc.getLinear(lin);
            Vec3d a = acc.getAngular(vec3d);
            acc.clear();
            boolean check = b.position.isNaN();
            b.position.addLocal(l);
            if (!check && b.position.isNaN()) {
                log.error("Body went NaN linear:" + l);
            }
            b.orientation.addScaledVectorLocal(a, 1.0);
            b.calculateDerivedData();
        }
    }

    protected void resolveVelocity(List<Contact<K, S>> contacts, List<Joint<K, S>> joints, double step, Map<RigidBody<K, S>, Accumulator> accumulators) {
        Vec3d vDelta1 = new Vec3d();
        Vec3d rotDelta1 = new Vec3d();
        Vec3d vDelta2 = new Vec3d();
        Vec3d rotDelta2 = new Vec3d();
        for (Contact<K, S> contact : contacts) {
            double localTemperature = contact.localTemperature;
            if (RigidBody.isCold(localTemperature)) continue;
            contact.calculateVelocityChange(vDelta1, vDelta2, rotDelta1, rotDelta2);
            if (vDelta1.isNaN()) {
                System.out.println("NaN velocity delta 1 for contact:" + contact);
            }
            if (vDelta2.isNaN()) {
                System.out.println("NaN velocity delta 2 for contact:" + contact);
            }
            this.getAccumulator(contact.body1, accumulators).accumulate(vDelta1, rotDelta1);
            this.getAccumulator(contact.getBody2(), accumulators).accumulate(vDelta2, rotDelta2);
        }
        if (this.resolveJoints) {
            for (Joint joint : joints) {
                if (joint.isSleepy()) continue;
                joint.calculateVelocityChange(vDelta1, vDelta2, rotDelta1, rotDelta2);
                if (vDelta1.isNaN()) {
                    System.out.println("NaN velocity delta 1 for joint:" + joint);
                }
                if (vDelta2.isNaN()) {
                    System.out.println("NaN velocity delta 2 for joint:" + joint);
                }
                this.getAccumulator(joint.getMainBody(), accumulators).accumulate(vDelta1, rotDelta1);
                this.getAccumulator(joint.getAltBody(), accumulators).accumulate(vDelta2, rotDelta2);
            }
        }
        Vec3d lin = new Vec3d();
        Vec3d vec3d = new Vec3d();
        for (Map.Entry<RigidBody<K, S>, Accumulator> e : accumulators.entrySet()) {
            RigidBody<K, S> b = e.getKey();
            Accumulator acc = e.getValue();
            Vec3d l = acc.getLinear(lin);
            Vec3d a = acc.getAngular(vec3d);
            acc.clear();
            b.addLinearVelocity(l);
            b.addRotationalVelocity(a);
        }
    }

    private final Accumulator getAccumulator(RigidBody<K, S> body, Map<RigidBody<K, S>, Accumulator> accumulators) {
        if (body == null) {
            return nullAccumulator;
        }
        Accumulator result = accumulators.get(body);
        if (result == null) {
            result = new Accumulator();
            accumulators.put(body, result);
        }
        return result;
    }

    protected static class Accumulator {
        Vec3d linMin = new Vec3d();
        Vec3d linMax = new Vec3d();
        Vec3d angMin = new Vec3d();
        Vec3d angMax = new Vec3d();

        protected Accumulator() {
        }

        public void accumulate(Vec3d lin, Vec3d ang) {
            this.linMin.minLocal(lin);
            this.linMax.maxLocal(lin);
            this.angMin.minLocal(ang);
            this.angMax.maxLocal(ang);
        }

        public final Vec3d getLinear(Vec3d store) {
            store.x = this.linMin.x + this.linMax.x;
            store.y = this.linMin.y + this.linMax.y;
            store.z = this.linMin.z + this.linMax.z;
            return store;
        }

        public final Vec3d getAngular(Vec3d store) {
            store.x = this.angMin.x + this.angMax.x;
            store.y = this.angMin.y + this.angMax.y;
            store.z = this.angMin.z + this.angMax.z;
            return store;
        }

        public final void clear() {
            this.linMin.set(0.0, 0.0, 0.0);
            this.linMax.set(0.0, 0.0, 0.0);
            this.angMin.set(0.0, 0.0, 0.0);
            this.angMax.set(0.0, 0.0, 0.0);
        }
    }
}

