/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.fx;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.event.BaseAppState;

public class LightingState
extends BaseAppState {
    public static final ColorRGBA DEFAULT_DIFFUSE = ColorRGBA.White.mult(2.0f);
    public static final ColorRGBA DEFAULT_AMBIENT = new ColorRGBA(0.25f, 0.25f, 0.25f, 1.0f);
    private VersionedHolder<Vector3f> lightDir = new VersionedHolder();
    private ColorRGBA sunColor;
    private DirectionalLight sun = new DirectionalLight();
    private ColorRGBA ambientColor;
    private AmbientLight ambient = new AmbientLight();
    private float timeOfDay = FastMath.atan2((float)1.0f, (float)0.3f) / (float)Math.PI;
    private float inclination = 1.5707964f - FastMath.atan2((float)1.0f, (float)0.4f);
    private float orientation = 0.0f;
    private Node rootNode;

    public LightingState() {
        this(FastMath.atan2((float)1.0f, (float)0.3f) / (float)Math.PI);
    }

    public LightingState(float time) {
        this.sunColor = DEFAULT_DIFFUSE.clone();
        this.ambientColor = DEFAULT_AMBIENT.clone();
        this.setTimeOfDay(time);
        this.resetLightDir();
    }

    public DirectionalLight getSun() {
        return this.sun;
    }

    public VersionedReference<Vector3f> getLightDirRef() {
        return this.lightDir.createReference();
    }

    public void setSunColor(ColorRGBA color) {
        this.sunColor.set(color);
        this.sun.setColor(this.sunColor);
    }

    public ColorRGBA getSunColor() {
        return this.sunColor;
    }

    public void setAmbient(ColorRGBA ambient) {
        this.ambientColor.set(ambient);
        this.ambient.setColor(this.ambientColor);
    }

    public ColorRGBA getAmbient() {
        return this.ambientColor;
    }

    public void setTimeOfDay(float f) {
        if (this.timeOfDay == f) {
            return;
        }
        this.timeOfDay = f;
        this.resetLightDir();
    }

    public float getTimeOfDay() {
        return this.timeOfDay;
    }

    public void setOrientation(float f) {
        if (this.orientation == f) {
            return;
        }
        this.orientation = f;
        this.resetLightDir();
    }

    public float getOrientation() {
        return this.orientation;
    }

    protected void resetLightDir() {
        float angle = this.timeOfDay * (float)Math.PI;
        Quaternion q1 = new Quaternion().fromAngles(0.0f, 0.0f, angle - 1.5707964f);
        Quaternion q2 = new Quaternion().fromAngles(this.inclination, this.orientation, 0.0f);
        Vector3f dir = q2.mult(q1).mult(Vector3f.UNIT_Y.negate());
        this.lightDir.setObject((Object)dir);
        if (this.sun != null) {
            this.sun.setDirection((Vector3f)this.lightDir.getObject());
        }
    }

    protected void initialize(Application app) {
        this.sun.setColor(this.sunColor);
        this.sun.setDirection((Vector3f)this.lightDir.getObject());
        this.ambient = new AmbientLight();
        this.ambient.setColor(this.ambientColor);
        this.resetLightDir();
    }

    protected void cleanup(Application app) {
    }

    protected void enable() {
        this.rootNode = ((SimpleApplication)this.getApplication()).getRootNode();
        this.rootNode.addLight((Light)this.sun);
        this.rootNode.addLight((Light)this.ambient);
    }

    protected void disable() {
        this.rootNode.removeLight((Light)this.sun);
        this.rootNode.removeLight((Light)this.ambient);
    }
}

