/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.jmf;

import de.jarnbjo.jmf.OggTrack;
import de.jarnbjo.ogg.LogicalOggStream;
import de.jarnbjo.util.io.ByteArrayBitInputStream;
import de.jarnbjo.vorbis.IdentificationHeader;
import de.jarnbjo.vorbis.VorbisFormatException;
import java.io.IOException;
import javax.media.Duration;
import javax.media.Format;
import javax.media.Time;
import javax.media.format.AudioFormat;

public class VorbisTrack
extends OggTrack {
    private LogicalOggStream oggStream;
    private IdentificationHeader identificationHeader;
    private AudioFormat format;

    public VorbisTrack(LogicalOggStream source, byte[] idHeaderData) throws VorbisFormatException, IOException {
        super(source);
        this.oggStream = source;
        ByteArrayBitInputStream bd = new ByteArrayBitInputStream(idHeaderData);
        bd.getInt(8);
        this.identificationHeader = new IdentificationHeader(bd);
        this.format = new AudioFormat("audio/x-vorbis", (double)this.identificationHeader.getSampleRate(), 16, this.identificationHeader.getChannels(), -1, -1, -1, -1.0, Format.byteArray);
    }

    public Format getFormat() {
        return this.format;
    }

    public Time getDuration() {
        long nos = this.oggStream.getMaximumGranulePosition();
        return nos == -1L ? Duration.DURATION_UNKNOWN : new Time(nos * 1000000000L / (long)this.identificationHeader.getSampleRate());
    }

    protected int getSampleRate() {
        return this.identificationHeader.getSampleRate();
    }
}

