/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.value;

import com.google.common.base.Function;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.TextField;
import com.simsilica.lemur.ValueEditor;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.focus.FocusChangeEvent;
import com.simsilica.lemur.focus.FocusChangeListener;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.text.DocumentModel;
import com.simsilica.lemur.text.DocumentModelFilter;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextFieldValueEditor<T>
implements ValueEditor<T> {
    static Logger log = LoggerFactory.getLogger(TextFieldValueEditor.class);
    private T object;
    private long version;
    private Function<Object, String> toString;
    private Function<String, T> toObject;
    private ElementId elementId;
    private String style;
    private TextField textField;
    private DocumentModelFilter model;
    private VersionedReference<DocumentModel> modelRef;
    private FocusObserver focusObserver = new FocusObserver();
    private boolean active;

    public TextFieldValueEditor(Function<Object, String> toString, Function<String, T> toObject) {
        this.toString = toString;
        this.toObject = toObject;
        this.model = new DocumentModelFilter();
        this.modelRef = this.model.createReference();
    }

    protected void incrementVersion() {
        ++this.version;
    }

    public VersionedReference<T> createReference() {
        return new VersionedReference((VersionedObject)this);
    }

    public long getVersion() {
        return this.version;
    }

    @Override
    public void setObject(T object) {
        if (Objects.equals(this.object, object)) {
            return;
        }
        this.object = object;
        this.resetText();
        this.incrementVersion();
    }

    @Override
    public T getObject() {
        return this.object;
    }

    @Override
    public boolean updateState(float tpf) {
        if (this.modelRef == null || this.modelRef.update()) {
            // empty if block
        }
        return this.active;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void setElementId(ElementId elementId) {
        this.elementId = elementId;
    }

    public ElementId getElementId() {
        return this.elementId;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyle() {
        return this.style;
    }

    @Override
    public void configureStyle(ElementId elementId, String style) {
        if (this.elementId == null) {
            this.elementId = elementId;
        }
        if (this.style == null) {
            this.style = style;
        }
    }

    public void setDocumentModelFilter(DocumentModelFilter model) {
        if (Objects.equals(this.model, model)) {
            return;
        }
        if (model == null) {
            model = new DocumentModelFilter();
        }
        this.model = model;
        if (this.textField != null) {
            ((GuiControl)this.textField.getControl(GuiControl.class)).removeFocusChangeListener((FocusChangeListener)this.focusObserver);
            this.textField = null;
        }
        this.modelRef = model.createReference();
    }

    public DocumentModelFilter getDocumentModelFilter() {
        return this.model;
    }

    protected TextField createTextField() {
        if (this.elementId != null) {
            return new TextField((DocumentModel)this.model, this.elementId, this.style);
        }
        return new TextField((DocumentModel)this.model);
    }

    @Override
    public Panel startEditing(T initialValue) {
        if (this.textField == null) {
            this.textField = this.createTextField();
            ((GuiControl)this.textField.getControl(GuiControl.class)).addFocusChangeListener((FocusChangeListener)this.focusObserver);
        }
        this.object = initialValue;
        this.resetText();
        this.active = true;
        return this.textField;
    }

    @Override
    public Panel getEditor() {
        return this.textField;
    }

    protected void resetText() {
        this.model.setText((String)this.toString.apply(this.object));
    }

    protected void stopEditing(boolean canceled) {
        if (!canceled) {
            String value = this.model.getText();
            try {
                Object object = this.toObject.apply((Object)value);
                this.setObject(object);
            }
            catch (NumberFormatException e) {
                log.warn("Error parsing:" + value, (Throwable)e);
                this.resetText();
            }
        }
        this.active = false;
    }

    protected class FocusObserver
    implements FocusChangeListener {
        protected FocusObserver() {
        }

        public void focusGained(FocusChangeEvent event) {
        }

        public void focusLost(FocusChangeEvent event) {
            TextFieldValueEditor.this.stopEditing(false);
        }
    }
}

