/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.geom;

import com.google.common.base.MoreObjects;
import com.simsilica.mblock.geom.GeomPart;
import com.simsilica.mblock.geom.GeomPartBuffer;
import com.simsilica.mblock.geom.MaterialType;
import com.simsilica.mblock.geom.PrimitiveType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPartBuffer
implements GeomPartBuffer {
    static Logger log = LoggerFactory.getLogger(DefaultPartBuffer.class);
    private Map<PartKey, PartList> parts = new HashMap<PartKey, PartList>();
    private long seed = 0L;
    private Random random = new Random(this.seed);

    public Collection<PartList> getPartLists() {
        return this.parts.values();
    }

    public void setRandomSeed(long seed) {
        this.seed = seed;
        if (this.parts.isEmpty()) {
            this.random.setSeed(seed);
        }
    }

    public long getRandomSeed() {
        return this.seed;
    }

    @Override
    public double nextRandom() {
        return this.random.nextDouble();
    }

    protected PartKey getKey(MaterialType materialType, PrimitiveType type) {
        return new PartKey(materialType, type);
    }

    protected PartList getList(MaterialType materialType, PrimitiveType type, boolean create) {
        PartKey key = this.getKey(materialType, type);
        PartList list = this.parts.get(key);
        if (list == null && create) {
            list = new PartList(materialType, type);
            this.parts.put(key, list);
        }
        return list;
    }

    @Override
    public void addPart(int i, int j, int k, GeomPart part) {
        PartList list = this.getList(part.getMaterialType(), part.getPrimitiveType(), true);
        list.add(i, j, k, part);
    }

    @Override
    public void clear() {
        this.parts.clear();
        this.random.setSeed(this.seed);
    }

    private static class PartKey {
        MaterialType material;
        PrimitiveType primitive;

        public PartKey(MaterialType material, PrimitiveType primitive) {
            this.material = material;
            this.primitive = primitive;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.material, this.primitive});
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            PartKey other = (PartKey)o;
            if (!Objects.equals(other.material, this.material)) {
                return false;
            }
            return other.primitive == this.primitive;
        }
    }

    public static class PartList {
        public MaterialType materialType;
        public PrimitiveType primitiveType;
        public List<PartEntry> list = new ArrayList<PartEntry>();
        public int vertCount;
        public int triCount;
        public boolean requiresFloatTexCoords;

        public PartList(MaterialType materialType, PrimitiveType primitiveType) {
            this.materialType = materialType;
            this.primitiveType = primitiveType;
        }

        public void add(int i, int j, int k, GeomPart part) {
            assert (this.materialType.assertValid(part));
            this.list.add(new PartEntry(i, j, k, part));
            this.vertCount += part.getVertexCount();
            this.triCount += part.getTriangleCount();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("materialType", (Object)this.materialType).add("primitiveType", (Object)this.primitiveType).add("vertCount", this.vertCount).add("triCount", this.triCount).add("requiresFloatTexCoords", this.requiresFloatTexCoords).toString();
        }
    }

    public static class PartEntry {
        public int i;
        public int j;
        public int k;
        public GeomPart part;

        public PartEntry(int i, int j, int k, GeomPart part) {
            this.i = i;
            this.j = j;
            this.k = k;
            this.part = part;
        }
    }
}

