/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.debug;

import com.jme3.bounding.BoundingBox;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;

public class WireBox
extends Mesh {
    public WireBox() {
        this(1.0f, 1.0f, 1.0f);
    }

    public WireBox(float xExt, float yExt, float zExt) {
        this.updatePositions(xExt, yExt, zExt);
        this.setBuffer(VertexBuffer.Type.Index, 2, new short[]{0, 1, 1, 2, 2, 3, 3, 0, 4, 5, 5, 6, 6, 7, 7, 4, 0, 4, 1, 5, 2, 6, 3, 7});
        this.setMode(Mesh.Mode.Lines);
        this.updateCounts();
    }

    public void updatePositions(float xExt, float yExt, float zExt) {
        FloatBuffer pb;
        VertexBuffer pvb = this.getBuffer(VertexBuffer.Type.Position);
        if (pvb == null) {
            pvb = new VertexBuffer(VertexBuffer.Type.Position);
            pb = BufferUtils.createVector3Buffer(8);
            pvb.setupData(VertexBuffer.Usage.Dynamic, 3, VertexBuffer.Format.Float, pb);
            this.setBuffer(pvb);
        } else {
            pb = (FloatBuffer)pvb.getData();
            pvb.updateData(pb);
        }
        pb.rewind();
        pb.put(new float[]{-xExt, -yExt, zExt, xExt, -yExt, zExt, xExt, yExt, zExt, -xExt, yExt, zExt, -xExt, -yExt, -zExt, xExt, -yExt, -zExt, xExt, yExt, -zExt, -xExt, yExt, -zExt});
        this.updateBound();
    }

    public static Geometry makeGeometry(BoundingBox bbox) {
        float xExtent = bbox.getXExtent();
        float yExtent = bbox.getYExtent();
        float zExtent = bbox.getZExtent();
        WireBox mesh = new WireBox(xExtent, yExtent, zExtent);
        Geometry result = new Geometry("bounding box", mesh);
        Vector3f center = bbox.getCenter();
        result.setLocalTranslation(center);
        return result;
    }
}

