/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world;

import com.jme3.math.ColorRGBA;
import com.simsilica.mathd.Vec3d;
import com.simsilica.progress.ProgressTracker;
import com.simsilica.progress.ProgressTrackers;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import mythruna.world.BioInfo;
import mythruna.world.TerrainTypes;
import mythruna.world.TopBlockType;
import mythruna.world.WorldFractal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldUtils {
    static Logger log = LoggerFactory.getLogger(WorldUtils.class);

    public static Vec3d findSpawn(WorldFractal fractal) {
        return WorldUtils.findSpawn(fractal, 0.0, 0.0, 32768.0, 256.0);
    }

    public static Vec3d findSpawn(WorldFractal fractal, double xStart, double zStart, double radius, double resolution) {
        double scanRads = Math.toRadians(15.0);
        int radialCount = 24;
        double scanRadius = 4096.0;
        double radiusDelta = 64.0;
        int scanCount = (int)(scanRadius / radiusDelta);
        int searchCount = 0;
        int sampleCount = 0;
        Vec3d best = null;
        double max = 0.0;
        double minDist = Double.POSITIVE_INFINITY;
        double step = radius * 2.0 / resolution;
        for (double x = xStart - radius; x <= xStart + radius; x += step) {
            for (double z = zStart - radius; z <= zStart + radius; z += step) {
                double y = fractal.getEstimatedElevation(x, z);
                ++sampleCount;
                if (y <= max) continue;
                ++searchCount;
                Vec3d center = new Vec3d(x, y, z);
                int waterCount = 0;
                Vec3d sample = new Vec3d();
                block2: for (int i = 0; i < radialCount; ++i) {
                    double a = (double)i * scanRads;
                    double sin = Math.sin(a);
                    double cos = Math.cos(a);
                    for (int j = 0; j <= scanCount; ++j) {
                        double dist = (double)j * radiusDelta;
                        sample.set(x + cos * dist, 0.0, z + sin * dist);
                        sample.y = fractal.getEstimatedElevation(sample.x, sample.z);
                        if (!(sample.y < 0.0)) continue;
                        ++waterCount;
                        continue block2;
                    }
                }
                if (waterCount == radialCount) continue;
                best = center;
                max = y;
            }
        }
        log.info("Tested " + searchCount + " points out of " + sampleCount + " samples");
        best.addLocal(0.5, 0.0, 0.5);
        return best;
    }

    public static BufferedImage createMapImage(WorldFractal fractal, Vec3d spawn, int imageSize, double xStart, double zStart, double mapSize) {
        ByteBuffer data = ByteBuffer.wrap(WorldUtils.createPreview(fractal, spawn, imageSize, xStart, zStart, mapSize));
        BufferedImage image = new BufferedImage(imageSize, imageSize, 2);
        int[] outArray = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        IntBuffer argbBuff = data.asIntBuffer();
        argbBuff.clear();
        argbBuff.get(outArray);
        return image;
    }

    public static byte[] createPreviewOld(WorldFractal fractal, int imageSize, double xStart, double zStart, double mapSize) {
        int c;
        int b;
        int fade;
        Vec3d spawn = WorldUtils.findSpawn(fractal);
        log.info("spawn:" + spawn);
        int[][] type = new int[imageSize][imageSize];
        int[][] color = new int[imageSize][imageSize];
        double size = mapSize;
        double scale = size / (double)imageSize;
        double x = xStart;
        double z = zStart + size - scale;
        for (int i = 0; i < imageSize; ++i) {
            x = xStart;
            for (int j = 0; j < imageSize; ++j) {
                double w;
                double y = fractal.getEstimatedElevation(x, z);
                type[j][i] = y > (w = fractal.getWaterLevel(x, y, z)) ? (int)y : -((int)y);
                x += scale;
            }
            z -= scale;
        }
        int margin = imageSize / 16;
        double mult = 255.0 / (double)margin;
        for (int i = 0; i < imageSize; ++i) {
            int j;
            boolean last = type[0][i] > 0;
            fade = 0;
            for (j = 0; j < imageSize; ++j) {
                boolean val;
                boolean bl = val = type[j][i] > 0;
                if (val == last && fade > 0) {
                    double s = (double)fade / (double)margin;
                    if (last) {
                        int g = color[j][i] >> 8 & 0xFF;
                        color[j][i] = Math.max(g, (int)(s * 255.0) & 0xFF) << 8;
                    } else {
                        b = color[j][i] & 0xFF;
                        color[j][i] = Math.max(b, (int)(s * 255.0) & 0xFF);
                    }
                    --fade;
                } else if (val != last) {
                    color[j][i] = -1;
                    if (j > 0) {
                        color[j - 1][i] = -1;
                    }
                    fade = margin;
                }
                last = val;
            }
            last = type[imageSize - 1][i] > 0;
            fade = 0;
            for (j = imageSize - 1; j >= 0; --j) {
                boolean val;
                c = color[j][i];
                boolean bl = val = type[j][i] > 0;
                if (val == last && fade > 0) {
                    double s = (double)fade / (double)margin;
                    if (last) {
                        int g = c >> 8 & 0xFF;
                        color[j][i] = Math.max(g, (int)(s * 255.0) & 0xFF) << 8;
                    } else {
                        int b2 = c & 0xFF;
                        color[j][i] = Math.max(b2, (int)(s * 255.0) & 0xFF);
                    }
                    --fade;
                } else if (val != last) {
                    color[j][i] = -1;
                    if (j > 0) {
                        color[j - 1][i] = -1;
                    }
                    fade = margin;
                }
                last = val;
            }
        }
        for (int j = 0; j < imageSize; ++j) {
            double s;
            int g;
            boolean val;
            int i;
            boolean last = type[j][0] > 0;
            fade = 0;
            for (i = 0; i < imageSize; ++i) {
                c = color[j][i];
                boolean bl = val = type[j][i] > 0;
                if (val == last) {
                    g = c >> 8 & 0xFF;
                    b = c & 0xFF;
                    if (c > 0) {
                        fade = val ? Math.max(fade, (int)((double)g / mult)) : Math.max(fade, (int)((double)b / mult));
                        fade = Math.min(margin, fade);
                    }
                    if (fade > 0) {
                        s = (double)fade / (double)margin;
                        color[j][i] = last ? Math.max(g, (int)(s * 255.0) & 0xFF) << 8 : Math.max(b, (int)(s * 255.0) & 0xFF);
                    }
                    --fade;
                } else if (val != last) {
                    color[j][i] = -1;
                    if (i > 0) {
                        color[j][i - 1] = -1;
                    }
                    fade = margin;
                }
                last = val;
            }
            last = type[j][imageSize - 1] > 0;
            fade = 0;
            for (i = imageSize - 1; i >= 0; --i) {
                c = color[j][i];
                boolean bl = val = type[j][i] > 0;
                if (val == last) {
                    g = c >> 8 & 0xFF;
                    b = c & 0xFF;
                    if (c > 0) {
                        fade = val ? Math.max(fade, (int)((double)g / mult)) : Math.max(fade, (int)((double)b / mult));
                        fade = Math.min(margin, fade);
                    }
                    if (fade > 0) {
                        s = (double)fade / (double)margin;
                        color[j][i] = last ? Math.max(g, (int)(s * 255.0) & 0xFF) << 8 : Math.max(b, (int)(s * 255.0) & 0xFF);
                    }
                    --fade;
                } else if (val != last) {
                    color[j][i] = -1;
                    if (i > 0) {
                        color[j][i - 1] = -1;
                    }
                    fade = margin;
                }
                last = val;
            }
        }
        double xSpawn = (spawn.x - xStart) / scale;
        double zSpawn = (spawn.z - zStart) / scale;
        log.info("xSpawn:" + xSpawn + " zSpawn:" + zSpawn);
        double spawnSizeSq = 9.0;
        byte[] img = new byte[imageSize * imageSize * 4];
        int pos = 0;
        for (int i = 0; i < imageSize; ++i) {
            for (int j = 0; j < imageSize; ++j) {
                int c2 = color[j][i];
                if (c2 < 0) {
                    img[pos++] = -1;
                    img[pos++] = 0;
                    img[pos++] = 0;
                    img[pos++] = 0;
                    continue;
                }
                double dx = (double)j - xSpawn;
                double dz = (double)i - zSpawn;
                double d = dx * dx + dz * dz;
                if (d <= spawnSizeSq) {
                    double alpha = 1.0 - d / spawnSizeSq;
                    img[pos++] = (byte)(alpha * 255.0);
                    img[pos++] = (byte)(255.0 * alpha);
                    img[pos++] = (byte)(60.0 * alpha);
                    img[pos++] = 0;
                    continue;
                }
                boolean r = false;
                int g = c2 >> 8 & 0xFF;
                int b3 = c2 & 0xFF;
                double a = (double)Math.max(g, b3) / 255.0;
                if (g > 0) {
                    g = 597;
                    b3 = 0;
                    a *= a;
                    a *= 196.0;
                } else if (b3 > 0) {
                    g = 0;
                    b3 = 597;
                    a *= 64.0;
                }
                img[pos++] = (byte)a;
                img[pos++] = (byte)(r ? 1 : 0);
                img[pos++] = (byte)g;
                img[pos++] = (byte)b3;
            }
        }
        return img;
    }

    public static byte[] createPreview(WorldFractal fractal, int imageSize, double xStart, double zStart, double mapSize) {
        Vec3d spawn = WorldUtils.findSpawn(fractal);
        return WorldUtils.createPreview(fractal, spawn, imageSize, xStart, zStart, mapSize);
    }

    public static byte[] createPreview(WorldFractal fractal, Vec3d spawn, int imageSize, double xStart, double zStart, double mapSize) {
        long start = System.nanoTime();
        byte[] result = WorldUtils.createPreviewNew(fractal, spawn, imageSize, xStart, zStart, mapSize);
        long end = System.nanoTime();
        log.info(String.format("New createPreview time: %.03f", (double)(end - start) / 1000000.0));
        return result;
    }

    public static byte[] createPreviewNew(WorldFractal fractal, Vec3d spawn, int imageSize, double xStart, double zStart, double mapSize) {
        log.info("createPreview(" + spawn + ", " + imageSize + ", " + xStart + ", " + zStart + ", " + mapSize + ")");
        ProgressTracker progress = ProgressTrackers.openTracker((String)"Create Preview");
        progress.setMax((double)(imageSize * 2 + 1));
        int[][] elevation = new int[imageSize][imageSize];
        int[][] color = new int[imageSize][imageSize];
        double[][] special = new double[imageSize][imageSize];
        int grassColor = 21760;
        int waterColor = 85;
        int maxHeight = 640;
        int seaLevel = 128;
        int treeLine = 618;
        BioInfo bio = new BioInfo();
        TopBlockType top = new TopBlockType();
        ColorRGBA target = new ColorRGBA();
        int grass = new ColorRGBA(0.5f, 0.7f, 0.2f, 1.0f).asIntARGB();
        int dryGrass = new ColorRGBA(0.4f, 0.6f, 0.2f, 1.0f).asIntARGB();
        int trees1 = new ColorRGBA(0.0f, 0.35f, 0.01f, 1.0f).asIntARGB();
        int trees2 = new ColorRGBA(0.0f, 0.25f, 0.01f, 1.0f).asIntARGB();
        int snow = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f).asIntARGB();
        int ice = new ColorRGBA(0.7f, 0.8f, 0.9f, 1.0f).asIntARGB();
        int sand = new ColorRGBA(1.0f, 0.9f, 0.5f, 1.0f).asIntARGB();
        int stone = new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f).asIntARGB();
        int dirt = new ColorRGBA(0.4f, 0.3f, 0.1f, 1.0f).asIntARGB();
        double size = mapSize;
        double scale = size / (double)imageSize;
        double x = xStart;
        double z = zStart + size - scale;
        for (int i = 0; i < imageSize; ++i) {
            x = xStart;
            for (int j = 0; j < imageSize; ++j) {
                double y = fractal.getEstimatedElevation(x, z);
                double w = fractal.getWaterLevel(x, y, z);
                elevation[j][i] = (int)(y - w);
                if (y < w) {
                    color[j][i] = waterColor;
                } else {
                    fractal.getBioInfo(x, y, z, bio);
                    int terrainType = TerrainTypes.fromBioInfo(bio, (int)y);
                    top.configure((int)y, terrainType, (int)w, 1);
                    if (top.snow) {
                        color[j][i] = top.type != 9 ? snow : ice;
                        tempFactor = bio.temperature / 1.0;
                        tempFactor *= tempFactor * tempFactor;
                        special[j][i] = 1.0 - tempFactor;
                    } else {
                        block0 : switch (top.type) {
                            case 0: {
                                color[j][i] = sand;
                                special[j][i] = (bio.temperature - 0.5) / 0.5;
                                break;
                            }
                            case 1: {
                                color[j][i] = dirt;
                                tempFactor = bio.temperature / 1.0;
                                tempFactor *= tempFactor;
                                special[j][i] = 1.0 - tempFactor;
                                break;
                            }
                            case 2: {
                                switch (top.foliage) {
                                    default: {
                                        color[j][i] = grass;
                                        break block0;
                                    }
                                    case 2: {
                                        color[j][i] = trees1;
                                        special[j][i] = bio.temperature / 1.0 * 0.75;
                                        break block0;
                                    }
                                    case 3: 
                                }
                                color[j][i] = trees2;
                                special[j][i] = 0.75 + bio.temperature / 1.0 * 0.25;
                                break;
                            }
                            case 3: {
                                color[j][i] = dryGrass;
                                special[j][i] = bio.temperature / 1.0;
                                break;
                            }
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: {
                                color[j][i] = stone;
                                special[j][i] = 1.0 - bio.temperature / 0.2857;
                                break;
                            }
                            case 9: {
                                color[j][i] = ice;
                                tempFactor = bio.temperature / 1.0;
                                tempFactor *= tempFactor;
                                special[j][i] = 1.0 - tempFactor;
                            }
                        }
                    }
                }
                x += scale;
            }
            z -= scale;
            progress.increment();
        }
        int margin = imageSize / 16;
        double mult = 255.0 / (double)margin;
        int maxDistanceSq = margin * margin + margin * margin;
        double maxDistance = Math.sqrt(maxDistanceSq);
        int[][] dist = new int[imageSize][imageSize];
        for (int i = 0; i < imageSize; ++i) {
            for (int j = 0; j < imageSize; ++j) {
                int h = elevation[j][i];
                int min = maxDistanceSq;
                for (int s = -margin; s < margin; ++s) {
                    for (int t = -margin; t < margin; ++t) {
                        int d;
                        int jt;
                        int is = i + s;
                        if (is < 0 || is >= imageSize || (jt = j + t) < 0 || jt >= imageSize) continue;
                        int n = elevation[jt][is];
                        if ((h < 0 || n >= 0) && (h > 0 || n <= 0) || (d = s * s + t * t) >= min) continue;
                        min = d;
                    }
                }
                dist[j][i] = min;
                if (min >= 2) continue;
                color[j][i] = -16777216;
            }
            progress.increment();
        }
        double xSpawn = (spawn.x - xStart) / scale;
        double zSpawn = (spawn.z - zStart) / scale;
        double spawnSizeSq = (double)imageSize / 64.0;
        spawnSizeSq *= spawnSizeSq;
        byte[] img = new byte[imageSize * imageSize * 4];
        int pos = 0;
        for (int i = 0; i < imageSize; ++i) {
            for (int j = 0; j < imageSize; ++j) {
                int a;
                int c = color[j][i];
                int r = c >> 16 & 0xFF;
                int g = c >> 8 & 0xFF;
                int b = c & 0xFF;
                double fade = 1.0 - Math.sqrt(dist[j][i]) / maxDistance;
                fade = fade * fade * fade;
                int h = elevation[j][i];
                double spec = special[j][i];
                if (h < 0) {
                    if (spec == 0.0) {
                        a = (int)(96.0 * fade);
                        a = Math.max(10, a);
                    } else {
                        a = 225;
                    }
                } else {
                    fade = Math.min(1.0, fade + spec * 0.5);
                    a = (int)(225.0 * fade);
                }
                double dx = (double)j - xSpawn;
                double dz = (double)i - zSpawn;
                double d = dx * dx + dz * dz;
                if (d <= spawnSizeSq) {
                    double alpha = 1.0 - d / spawnSizeSq;
                    img[pos++] = (byte)WorldUtils.mix(a, 255, alpha);
                    img[pos++] = (byte)WorldUtils.mix(r, 255, alpha);
                    img[pos++] = (byte)WorldUtils.mix(g, 60, alpha);
                    img[pos++] = (byte)WorldUtils.mix(b, 0, alpha);
                    continue;
                }
                img[pos++] = (byte)a;
                img[pos++] = (byte)r;
                img[pos++] = (byte)g;
                img[pos++] = (byte)b;
            }
        }
        progress.increment();
        progress.close(true);
        return img;
    }

    public static byte[] createPreviewNotAsOld(WorldFractal fractal, Vec3d spawn, int imageSize, double xStart, double zStart, double mapSize) {
        log.info("createPreview(" + spawn + ", " + imageSize + ", " + xStart + ", " + zStart + ", " + mapSize + ")");
        int[][] elevation = new int[imageSize][imageSize];
        int[][] color = new int[imageSize][imageSize];
        double[][] special = new double[imageSize][imageSize];
        int grassColor = 21760;
        int waterColor = 85;
        int maxHeight = 640;
        int seaLevel = 128;
        int treeLine = 618;
        BioInfo bio = new BioInfo();
        ColorRGBA target = new ColorRGBA();
        ColorRGBA grass = new ColorRGBA(0.5f, 0.7f, 0.2f, 1.0f);
        ColorRGBA trees = new ColorRGBA(0.0f, 0.25f, 0.01f, 1.0f);
        ColorRGBA snow = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
        ColorRGBA ice = new ColorRGBA(0.7f, 0.8f, 0.9f, 1.0f);
        ColorRGBA sand = new ColorRGBA(1.0f, 0.9f, 0.5f, 1.0f);
        ColorRGBA dirt = new ColorRGBA(0.4f, 0.3f, 0.1f, 1.0f);
        double size = mapSize;
        double scale = size / (double)imageSize;
        double x = xStart;
        double z = zStart + size - scale;
        for (int i = 0; i < imageSize; ++i) {
            x = xStart;
            for (int j = 0; j < imageSize; ++j) {
                double y = fractal.getEstimatedElevation(x, z);
                double w = fractal.getWaterLevel(x, y, z);
                elevation[j][i] = (int)(y - w);
                if (y >= w) {
                    fractal.getBioInfo(x, y, z, bio);
                    boolean frozen = bio.temperature <= 0.2857;
                    double freeze = 0.0;
                    if (frozen) {
                        freeze = 1.0 - bio.temperature / 0.2857;
                    }
                    special[j][i] = freeze;
                    int type = 1;
                    if (y > (double)treeLine) {
                        type = 2;
                    } else if (bio.vegetationLevel < 0.1 && bio.temperature > 0.5) {
                        type = 0;
                        special[j][i] = (bio.temperature - 0.5) / 0.5;
                    } else if (frozen && bio.precipitation > 0.5) {
                        double iceFactor = (0.2857 - bio.temperature) / 0.2857;
                        type = bio.precipitation + iceFactor * 0.5 > 0.8 ? 3 : 1;
                    } else if (frozen && bio.precipitation < 0.16666 && bio.vegetationLevel < 0.16666) {
                        special[j][i] = 1.0;
                    }
                    double foliage = bio.vegetationLevel;
                    double wetness = bio.precipitation;
                    if (type == 0 && wetness >= 0.5 && foliage < 0.16666) {
                        type = 1;
                        wetness -= 0.33333;
                    }
                    if (wetness >= 0.166666 && foliage < 0.1666 && type == 1) {
                        foliage = bio.soilQuality;
                        if (!frozen) {
                            wetness -= 0.33333;
                        }
                    }
                    switch (type) {
                        case 0: {
                            target.set(sand);
                            if (!frozen || !(wetness > 0.0)) break;
                            target.interpolateLocal(ice, (float)freeze);
                            break;
                        }
                        case 1: {
                            target.set(dirt);
                            if (!frozen || !(wetness > 0.0)) break;
                            target.interpolateLocal(ice, (float)freeze);
                            break;
                        }
                        case 2: {
                            target.set(0.5f, 0.5f, 0.5f, 1.0f);
                            if (!frozen || !(wetness > 0.0)) break;
                            target.interpolateLocal(ice, (float)freeze);
                            break;
                        }
                        case 3: {
                            target.set(ice);
                            break;
                        }
                        default: {
                            target.set(1.0f, 0.0f, 0.0f, 1.0f);
                        }
                    }
                    if (!frozen) {
                        if (foliage < 0.16666) {
                            target.interpolateLocal(trees, (float)(foliage / 0.16666));
                            special[j][i] = (1.0 - foliage / 0.16666) * 0.5;
                        } else {
                            target.interpolateLocal(trees, 1.0f);
                        }
                    } else {
                        double freezeFactor = 1.0 - freeze;
                        freezeFactor *= freezeFactor;
                        if (foliage < 0.16666) {
                            target.interpolateLocal(trees, (float)(freezeFactor * foliage / 0.16666));
                        } else {
                            target.interpolateLocal(trees, (float)freezeFactor);
                        }
                    }
                    color[j][i] = target.asIntARGB();
                } else {
                    color[j][i] = waterColor;
                }
                x += scale;
            }
            z -= scale;
        }
        int margin = imageSize / 16;
        double mult = 255.0 / (double)margin;
        int maxDistanceSq = margin * margin + margin * margin;
        double maxDistance = Math.sqrt(maxDistanceSq);
        int[][] dist = new int[imageSize][imageSize];
        for (int i = 0; i < imageSize; ++i) {
            for (int j = 0; j < imageSize; ++j) {
                int h = elevation[j][i];
                int min = maxDistanceSq;
                for (int s = -margin; s < margin; ++s) {
                    for (int t = -margin; t < margin; ++t) {
                        int d;
                        int jt;
                        int is = i + s;
                        if (is < 0 || is >= imageSize || (jt = j + t) < 0 || jt >= imageSize) continue;
                        int n = elevation[jt][is];
                        if ((h < 0 || n >= 0) && (h > 0 || n <= 0) || (d = s * s + t * t) >= min) continue;
                        min = d;
                    }
                }
                dist[j][i] = min;
                if (min >= 2) continue;
                color[j][i] = -16777216;
            }
        }
        double xSpawn = (spawn.x - xStart) / scale;
        double zSpawn = (spawn.z - zStart) / scale;
        double spawnSizeSq = 9.0;
        byte[] img = new byte[imageSize * imageSize * 4];
        int pos = 0;
        for (int i = 0; i < imageSize; ++i) {
            for (int j = 0; j < imageSize; ++j) {
                int a;
                int c = color[j][i];
                int r = c >> 16 & 0xFF;
                int g = c >> 8 & 0xFF;
                int b = c & 0xFF;
                double fade = 1.0 - Math.sqrt(dist[j][i]) / maxDistance;
                fade = fade * fade * fade;
                int h = elevation[j][i];
                if (h < 0) {
                    a = (int)(96.0 * fade);
                    a = Math.max(10, a);
                } else {
                    fade = Math.min(1.0, fade + special[j][i] * 0.5);
                    a = (int)(225.0 * fade);
                }
                a = 255;
                double dx = (double)j - xSpawn;
                double dz = (double)i - zSpawn;
                double d = dx * dx + dz * dz;
                if (d <= spawnSizeSq) {
                    double alpha = 1.0 - d / spawnSizeSq;
                    img[pos++] = (byte)WorldUtils.mix(a, 255, alpha);
                    img[pos++] = (byte)WorldUtils.mix(r, 255, alpha);
                    img[pos++] = (byte)WorldUtils.mix(g, 60, alpha);
                    img[pos++] = (byte)WorldUtils.mix(b, 0, alpha);
                    continue;
                }
                img[pos++] = (byte)a;
                img[pos++] = (byte)r;
                img[pos++] = (byte)g;
                img[pos++] = (byte)b;
            }
        }
        return img;
    }

    public static int mix(int v1, int v2, double mix) {
        return (int)((double)v1 * (1.0 - mix) + (double)v2 * mix);
    }
}

