/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.name;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.SedectileId;
import com.simsilica.namegen.Cluster;
import com.simsilica.namegen.NameGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import mythruna.world.name.CulturalInfluence;
import mythruna.world.name.CultureCenter;
import mythruna.world.name.CultureType;
import mythruna.world.name.NameGeneratorCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CultureManager {
    static Logger log = LoggerFactory.getLogger(CultureManager.class);
    private long baseSeed;
    private List<CultureType> types = new ArrayList<CultureType>();
    private Map<SedectileId, CultureCenter> sedectileCultures = new HashMap<SedectileId, CultureCenter>();

    public CultureManager(long baseSeed) {
        this.baseSeed = baseSeed;
        this.types.add(new CultureType("Place Names", "lang1", "/places/lang1.nameset"));
        this.types.add(new CultureType("Place Names", "lang2", "/places/lang2.nameset"));
        this.types.add(new CultureType("Place Names", "lang3", "/places/lang3.nameset"));
        this.types.add(new CultureType("Place Names", "lang4", "/places/lang4.nameset"));
        this.types.add(new CultureType("Place Names", "lang5", "/places/lang5.nameset"));
        this.types.add(new CultureType("Place Names", "lang6", "/places/lang6.nameset"));
        this.types.add(new CultureType("Place Names", "lang7", "/places/lang7.nameset"));
        this.types.add(new CultureType("Place Names", "lang8", "/places/lang8.nameset"));
        this.types.add(new CultureType("Place Names", "lang9", "/places/lang9.nameset"));
        this.types.add(new CultureType("Place Names", "lang10", "/places/lang10.nameset"));
        this.types.add(new CultureType("Place Names", "lang11", "/places/lang11.nameset"));
        this.types.add(new CultureType("Place Names", "lang12", "/places/lang12.nameset"));
        this.types.add(new CultureType("Place Names", "lang13", "/places/lang13.nameset"));
        this.types.add(new CultureType("Place Names", "lang14", "/places/lang14.nameset"));
        this.types.add(new CultureType("Place Names", "lang15", "/places/lang15.nameset"));
        this.types.add(new CultureType("Place Names", "lang16", "/places/lang16.nameset"));
        this.types.add(new CultureType("Place Names", "lang17", "/places/lang17.nameset"));
        this.types.add(new CultureType("Place Names", "lang18", "/places/lang18.nameset"));
        this.types.add(new CultureType("Place Names", "lang19", "/places/lang19.nameset"));
    }

    protected CultureCenter getSedectileCulture(SedectileId id) {
        CultureCenter result = this.sedectileCultures.get(id);
        if (result == null) {
            Random rand = new Random(this.baseSeed + id.getId());
            int index = rand.nextInt(this.types.size());
            CultureType type = this.types.get(index);
            Vec3i origin = id.getWorld(null);
            origin.addLocal(rand.nextInt(16384), 0, rand.nextInt(16384));
            result = new CultureCenter(type, origin, null);
            this.sedectileCultures.put(id, result);
        }
        return result;
    }

    public SortedSet<CulturalInfluence> getCulturalInfluences(String category, Vec3i location, int maxRadius) {
        SedectileId minId = SedectileId.fromWorld((int)(location.x - maxRadius), (int)location.y, (int)(location.z - maxRadius));
        SedectileId maxId = SedectileId.fromWorld((int)(location.x + maxRadius), (int)location.y, (int)(location.z + maxRadius));
        Vec3i minLoc = minId.getWorld(null);
        Vec3i maxLoc = maxId.getWorld(null);
        TreeSet<CulturalInfluence> results = new TreeSet<CulturalInfluence>();
        for (int x = minLoc.x; x <= maxLoc.x; x += 16384) {
            for (int z = minLoc.z; z <= maxLoc.z; z += 16384) {
                SedectileId id = SedectileId.fromWorld((Vec3i)new Vec3i(x, minLoc.y, z));
                CultureCenter center = this.getSedectileCulture(id);
                double distance = center.getLocation().toVec3d().distance(location.toVec3d());
                if (distance > (double)maxRadius) continue;
                results.add(new CulturalInfluence(center.getType(), distance));
            }
        }
        return results;
    }

    protected static long locationToId(Vec3i location) {
        long x = location.x;
        long z = location.z;
        return x << 32 | z & 0xFFFFFFFFL;
    }

    public String getRandomPlaceName(Vec3i location, int minClusters, int maxClusters) {
        CulturalInfluence influence;
        SortedSet<CulturalInfluence> cultures = this.getCulturalInfluences("Place Names", location, 32768);
        CulturalInfluence culturalInfluence = influence = cultures.isEmpty() ? null : cultures.first();
        if (influence == null) {
            return null;
        }
        long localSeed = CultureManager.locationToId(location);
        Random rand = new Random(this.baseSeed + localSeed);
        NameGenerator gen = NameGeneratorCache.getGenerator(influence.type.getResource());
        List clusters = gen.generateWord(minClusters, maxClusters, rand);
        String word = Cluster.toWords((List)clusters);
        return word;
    }
}

