
import com.simsilica.lemur.*;
import com.simsilica.lemur.Button.ButtonAction;
import com.simsilica.lemur.component.*;
import com.jme3.material.RenderState.BlendMode;
import com.jme3.texture.Texture.WrapMode;

import mythruna.client.sound.SoundCommand;

def gradient = TbtQuadBackgroundComponent.create(
                                        texture( name:"/com/simsilica/lemur/icons/bordered-gradient.png",
                                                 generateMips:false ),
                                                 1, 1, 1, 126, 126,
                                                 1f, false );

def bevel = TbtQuadBackgroundComponent.create(
                                        texture( name:"/com/simsilica/lemur/icons/bevel-quad.png",
                                                 generateMips:false ),
                                                 0.125f, 8, 8, 119, 119,
                                                 1f, false );

def border1 = TbtQuadBackgroundComponent.create(
                                        texture( name:"/com/simsilica/lemur/icons/border.png",
                                                 generateMips:false ),
                                                 1, 1, 1, 6, 6,
                                                 1f, false );
def border2 = TbtQuadBackgroundComponent.create(
                                        texture( name:"/com/simsilica/lemur/icons/border.png",
                                                 generateMips:false ),
                                                 1, 2, 2, 6, 6,
                                                 1f, false );


def doubleGradient = new QuadBackgroundComponent( color(0.5, 0.75, 0.85, 0.5) );
doubleGradient.texture = texture( name:"/com/simsilica/lemur/icons/double-gradient-128.png",
                                  generateMips:false )

def transparent = new QuadBackgroundComponent(color(0, 0, 0, 0))

def plainPaper = new QuadBackgroundComponent(texture("/Interface/paper.jpg"));

def drawnBox1 = TbtQuadBackgroundComponent.create(
                                        texture(name:"/Interface/drawn-box-64.png",
                                                generateMips:false),
                                                0.5f, 10, 10, 53, 53,
                                                1f, false);
drawnBox1.setMargin(4, 2);

def brassPlate = TbtQuadBackgroundComponent.create(
                                        // 151x41
                                        texture(name:"/Interface/BrassButton.png",
                                                generateMips:false,
                                                wrap:WrapMode.EdgeClamp),
                                                1, 4, 4, 146, 36,
                                                1f, false);
                                        //texture(name:"/Interface/BrassPlate64.png",
                                        //        generateMips:false),
                                        //        1, 8, 8, 56, 56,
                                        //        1f, false);
//brassPlate.setMargin(4, 4);

def oldPaper = TbtQuadBackgroundComponent.create(
                                        // 512x512
                                        texture(name:"/Interface/old-paper-flattened.png",
                                                generateMips:false),
                                                0.25f, 32, 32, 480, 480,
                                                1f, false);
oldPaper.setMargin(10, 10);

def popupBorder = TbtQuadBackgroundComponent.create(
                                        // 64x64
                                        texture(name:"/Interface/popup-border.png",
                                                generateMips:false),
                                                1, 13, 13, 51, 51,
                                                1f, false);
//popupBorder.setMargin(16, 16);

def upButton = new IconComponent("/Interface/UpButton.png");
//new QuadBackgroundComponent(texture("/Interface/UpButton.png"));
def downButton = new IconComponent("/Interface/DownButton.png");
//new QuadBackgroundComponent(texture("/Interface/DownButton.png"));

//def scrollBg = TbtQuadBackgroundComponent.create(
//                                        // 24x274
//                                        texture(name:"/Interface/scrollbar.jpg",
//                                                generateMips:false),
//                                                1, 4, 33, 21, 241,
//                                                1f, false);

def scrollBg = TbtQuadBackgroundComponent.create(
                                        texture(name:"/Interface/drawn-box-64.png",
                                                generateMips:false),
                                                0.5f, 10, 10, 53, 53,
                                                1f, false);
scrollBg.setMargin(2, 2);

def thinBox = TbtQuadBackgroundComponent.create(
                                        texture(name:"/Interface/drawn-box-64.png",
                                                generateMips:false),
                                                0.25f, 10, 10, 53, 53,
                                                1f, false);
thinBox.setMargin(2, 2);


selector( "paper" ) {
    //font = font("Interface/akbar64.fnt")
    //font = font("Interface/templar24.fnt")
    fontSize = 24
}

selector( "label", "paper" ) {
    insets = new Insets3f( 2, 2, 0, 2 );
    //color = color(0.75, 0.75, 0.1, 0.85)
    color = color(0.1, 0.1, 0.3, 0.75f)
}

selector("console.message.label", "paper") {
    shadowColor = color(0.1, 0.1, 0.1, 0.75f);
}

selector( "map.marker.label", "paper" ) {
    color = color(0.2, 0.1, 0.1, 0.85f)
}

selector( "credits.label", "paper" ) {
    color = color(0.2, 0.9, 0.9, 0.99f)
}

selector( "container", "paper" ) {
    //background = plainPaper
}

selector( "slider", "paper" ) {
    background = scrollBg;
    //background.setColor(color(0.25, 0.5, 0.5, 0.5))
}

def pressedCommand = new Command<Button>() {
        public void execute( Button source ) {
            if( source.isPressed() ) {
println("press before:" + source.getWorldTranslation());
                source.move(1, -1, 0);
println("press after:" + source.getWorldTranslation());
            } else {
println("release before:" + source.getWorldTranslation());
                source.move(-1, 1, 0);
println("release after:" + source.getWorldTranslation());
            }
        }
    };

def repeatCommand = new Command<Button>() {
        private long startTime;
        private long lastClick;

        public void execute( Button source ) {
            // Only do the repeating click while the mouse is
            // over the button (and pressed of course)
            if( source.isPressed() && source.isHighlightOn() ) {
                long elapsedTime = System.currentTimeMillis() - startTime;
                // After half a second pause, click 8 times a second
                if( elapsedTime > 500 ) {
                    if( elapsedTime - lastClick > 125 ) {
                        source.click();

                        // Try to quantize the last click time to prevent drift
                        lastClick = ((elapsedTime - 500) / 125) * 125 + 500;
                    }
                }
            } else {
                startTime = System.currentTimeMillis();
                lastClick = 0;
            }
        }
    };

def paperClickCommand = new SoundCommand("Paper Click");
def shortClickCommand = new SoundCommand("Short Click");

def stdButtonCommands = [
        (ButtonAction.Down):[pressedCommand],
        (ButtonAction.Up):[pressedCommand],
        (ButtonAction.Click):[paperClickCommand]
    ];

def sliderButtonCommands = [
        (ButtonAction.Hover):[repeatCommand],
        (ButtonAction.Click):[shortClickCommand]
    ];

def spinnerButtonCommands = [
        (ButtonAction.Hover):[repeatCommand],
        (ButtonAction.Click):[shortClickCommand]
    ];

def sliderThumbCommands = [
        // We don't want the button pressing in/out like the standard buttons do
        (ButtonAction.Down):[],
        (ButtonAction.Up):[],
        (ButtonAction.Click):[shortClickCommand]
    ];

def sectionButtonCommands = [
        (ButtonAction.Down):[pressedCommand],
        (ButtonAction.Up):[pressedCommand],
        (ButtonAction.Click):[paperClickCommand]
    ];


selector( "title", "paper" ) {
    //color = color(0.8, 0.9, 1, 0.85f)
    //highlightColor = color(1, 0.8, 1, 0.85f)
    //shadowColor = color(0, 0, 0, 0.75f)
    //shadowOffset = new com.jme3.math.Vector3f(2, -2, -1);
    //background = new QuadBackgroundComponent( color(0.5, 0.75, 0.85, 0.5) );
    //background.texture = texture( name:"/com/simsilica/lemur/icons/double-gradient-128.png",
    //                              generateMips:false )
    //insets = new Insets3f( 2, 2, 2, 2 );

    color = color(0.0, 0.0, 0.1, 1f)
    highlightColor = color(0.1, 0.4, 0.5, 0.85f)
    shadowColor = color(1, 1, 0.8, 1f)
    shadowOffset = new com.jme3.math.Vector3f(2, -2, -1);
    background = brassPlate;
    insets = new Insets3f(2, 2, 2, 2);
}


selector( "button", "paper" ) {
    //background = gradient.clone()
    background = drawnBox1.clone();
    background.setMargin(8, 2);
    color = color(0.2, 0.4, 0.4, 0.75f)
    //background.setColor(color(0, 0.75, 0.75, 0.5))
    insets = new Insets3f(2, 2, 2, 2);

    buttonCommands = stdButtonCommands;
}

selector( "mini", "button", "paper" ) {
    fontSize = 18;
    insets = new Insets3f(0, 0, 0, 0);
}

selector( "toolbar", "button", "paper" ) {
    // Shouldn't have to do this.
    buttonCommands = stdButtonCommands;
}

selector( "slider", "paper" ) {
    //insets = new Insets3f( 1, 3, 1, 2 );
    insets = new Insets3f(0, 0, 0, 0);
    //background = drawnBox1.clone();
    //border.color = color(0, 1, 0, 1);
    //border = new QuadBackgroundComponent(color(0.0, 0.0, 0.0, 0.5)); //plainPaper.clone();
    border = gradient.clone();
    border.color = color(0.6, 0.5, 0.5, 0.25);
    //background.color = color(1, 0, 0, 1);
    //border = new QuadBackgroundComponent(color(1, 0, 0, 1), 5, 5);
    //background = new QuadBackgroundComponent(color(0, 1, 0, 1), 5, 5);
    //background = new QuadBackgroundComponent(color(0, 1, 0, 1));
}

selector( "slider", "range", "paper" ) {
    //insets = new Insets3f( 1, 3, 1, 2 );
    //insets = new Insets3f(0, 0, 0, 0);
    //background = drawnBox1.clone();
    //border.color = color(0, 1, 0, 1);
    //border = plainPaper.clone();
    //background.color = color(1, 0, 0, 1);
    insets = new Insets3f(0, 0, 0, 0);
    //border = new QuadBackgroundComponent(color(1, 0, 0, 1), 5, 5);
    //background = new QuadBackgroundComponent(color(0, 1, 0, 1), 5, 5);
}

selector( "slider", "button", "paper" ) {
    //background = doubleGradient.clone()
    //background.setColor(color(0.5, 0.75, 0.75, 0.5))
    background = drawnBox1.clone();
    //background.setMargin(0, 0);
    //insets = new Insets3f( 0, 0, 0, 0 );
    color = color(0.3, 0.3, 0.4, 0.85)
}

selector( "slider.thumb.button", "paper" ) {
    text = "  "
    //color = color(0.6, 0.8, 0.8, 0.85)
    buttonCommands = sliderThumbCommands
}

selector( "slider.left.button", "paper" ) {
    text = "-"
    fontSize = 14
    //background = doubleGradient.clone()
    //background.setColor(color(0.5, 0.75, 0.75, 0.5))
    //background.setMargin(5, 0);
    //color = color(0.6, 0.8, 0.8, 0.85)

    buttonCommands = sliderButtonCommands;
}

selector( "slider.right.button", "paper" ) {
    text = "+"
    fontSize = 14
    //background = doubleGradient.clone()
    //background.setColor(color(0.5, 0.75, 0.75, 0.5))
    //background.setMargin(4, 0);
    //color = color(0.6, 0.8, 0.8, 0.85)

    buttonCommands = sliderButtonCommands;
}

selector( "slider.up.button", "paper" ) {
    buttonCommands = sliderButtonCommands;
    icon = upButton.clone();
    icon.iconScale = 0.75f;
    fontSize = 10;
    icon.setHAlignment(HAlignment.Center);
    //insets = new Insets3f( 0, 0, 0, 0 );
    //background = new QuadBackgroundComponent(color(0, 0, 1, 1), 0, 0);
    background = null;
    text = "";
}

selector( "slider.down.button", "paper" ) {
    buttonCommands = sliderButtonCommands;
    icon = downButton.clone();
    icon.iconScale = 0.75f;
    fontSize = 10;
    icon.setHAlignment(HAlignment.Center);
    //insets = new Insets3f( 0, 0, 0, 0 );
    background = null;
    //background = new QuadBackgroundComponent(color(0, 0, 1, 1), 0, 0);
    text = "";
}

selector( "checkbox", "paper" ) {
    def on = new IconComponent("/Interface/paper-check.png", 0.4f, 0, 0, 1f, false);
    def off = new IconComponent("/Interface/paper-check-off.png", 0.4f, 0, 0, 1f, false);

    onView = on;
    offView = off;

    //color = color(0.8, 0.9, 1, 0.85f)
    color = color(0.1, 0.1, 0.3, 0.75f)
}

selector( "rollup", "paper" ) {
    background = thinBox.clone()
    //background = gradient.clone()
    //background.setColor(color(0.25, 0.5, 0.5, 0.5))
}

selector( "tabbedPanel", "paper" ) {
    activationColor = color(0.8, 0.9, 1, 0.85f)
}

selector( "tabbedPanel.container", "paper" ) {
    //background = null
    background = thinBox.clone()
}

selector( "tab.button", "paper" ) {
    background = thinBox.clone()
    background.setMargin(5, 5);
    //background.setColor(color(0.25, 0.5, 0.5, 0.5))
    //color = color(0.4, 0.45, 0.5, 0.85f)
    insets = new Insets3f( 4, 5, 0, 5 );

    buttonCommands = stdButtonCommands;
}

selector("section.button", "paper") {
    fontSize = 16;
    background = plainPaper.clone();
    background.color = color(0.9, 0.9, 0.9, 0.7);
    background.setMargin(4, 0);

    border = thinBox.clone()
    //border.setMargin(2, 2);
    //border = plainPaper.clone();
    //border.color = color(0.9, 0.9, 0.9, 1);
    insets = new Insets3f(0, 0, 0, 0);

    buttonCommands = sectionButtonCommands;
}

selector( "optionPanel", "paper" ) {
    //background = plainPaper.clone();
    background = popupBorder;
    //border = popupBorder;
}

selector( "optionPanel.container", "paper" ) {
    //border = popupBorder;
    //background = plainPaper.clone();
    //background.setMargin(10, 10)
    background = null;
    insets = new Insets3f( 2, 2, 2, 2 )
}

selector( "title.label", "paper" ) {
    //color = color(0.8, 0.9, 1, 0.85f)
    color = color(0.0, 0.0, 0.1, 1f)
    highlightColor = color(1, 0.8, 1, 0.85f)
    //shadowColor = color(0, 0, 0, 0.75f)
    shadowColor = color(1, 1, 0.8, 1f)
    shadowOffset = new com.jme3.math.Vector3f(2, -2, -1);
    //background = new QuadBackgroundComponent( color(0.5, 0.75, 0.85, 0.5) );
    //background.texture = texture( name:"/com/simsilica/lemur/icons/double-gradient-128.png",
    //                              generateMips:false )
    background = brassPlate;
    insets = new Insets3f( 2, 2, 2, 2 );
}

selector( "window.title", "paper" ) {
    color = color(0.0, 0.0, 0.1, 1f)
    highlightColor = color(1, 0.8, 1, 0.85f)
    shadowColor = color(1, 1, 0.8, 1f)
    shadowOffset = new com.jme3.math.Vector3f(2, -2, -1);
    background = brassPlate;
    insets = new Insets3f( 2, 2, 2, 2 );
}

selector( "list.container", "paper" ) {
    background = scrollBg
    //background.setColor(color(0.25, 0.5, 0.5, 0.5))
    //insets = new Insets3f( 2, 2, 2, 2, 2, 2 );
}

selector( "list.item", "paper" ) {
    // Note that the world list hard-codes its own colors to deal with invalid
    // worlds.
    color = color(0.4, 0.25, 0.25, 0.85)
    background = transparent;
    textVAlignment = VAlignment.Center
    insets = new Insets3f(0, 5, 0, 5);
}

selector( "list.selector", "paper" ) {
    background = gradient.clone();
    background.color = color(0.4, 0.6, 0.6, 0.5)
    //background.material.material.additionalRenderState.blendMode = BlendMode.Exclusion;
    background.material.material.additionalRenderState.blendMode = BlendMode.AlphaAdditive;
}

selector( "colorChooser.value", "paper" ) {
    border = gradient.clone()
    border.setColor(color(0.25, 0.5, 0.5, 0.5))
    insets = new Insets3f( 2, 2, 2, 2, 2, 2 );
}

selector( "colorChooser.colors", "paper" ) {
    border = gradient.clone()
    border.setColor(color(0.25, 0.5, 0.5, 0.5))
    insets = new Insets3f( 2, 2, 2, 2, 2, 2 );
}

selector( "selector.container", "paper" ) {
    //color = color(0.8, 0.9, 1, 0.85f)
    background = gradient.clone()
    background.setColor(color(0.6, 0.6, 0.4, 0.25))
}

selector( "selector", "item", "paper" ) {
    //fontSize = 20;
    color = color(0.2, 0.1, 0.05, 0.9)
    background = transparent;
    insets = new Insets3f(1, 1, 1, 1, 1, 1);
}

selector( "selector.popup", "paper" ) {
    //background = gradient.clone()
    //background.setColor(color(0, 0.75, 0.75, 0.75))
    background = popupBorder
}

selector( "selector.down.button", "paper" ) {
    insets = new Insets3f(0, 0, 0, 0, 0, 0);
    icon = downButton.clone();
    icon.iconScale = 0.75f;
    fontSize = 10;
    icon.setHAlignment(HAlignment.Center);
}


selector( "spinner.value", "paper" ) {
    //color = color(0.8, 0.8, 0.9, 0.9)
    color = color(0.2, 0.1, 0.05, 0.9)
    //background = transparent; //gradient.clone();
    ////background.color = color(0, 0.2, 0.2, 0.75);
    background = gradient.clone()
    background.setColor(color(0.6, 0.6, 0.4, 0.25))
    textHAlignment = HAlignment.Right;
}

selector( "spinner.buttons.container", "paper" ) {
    background = transparent;
    insets = new Insets3f(0, 0, 0, 0);
}

selector( "spinner", "button", "paper" ) {
    fontSize = 10
    background = gradient.clone()
    // A negative margin works here when the font can support it.
    // It helps eat up the extra whitespace above/below the '+'/'-' signs.
    //background.setMargin(2, -3.5);
    //background.setColor(color(0, 0.75, 0.75, 0.5))
    background.setMargin(3, 0);
    background.setColor(color(0.6, 0.6, 0.4, 0.5))
    insets = new Insets3f(0, 0, 0, 0);
    textHAlignment = HAlignment.Center;

    buttonCommands = spinnerButtonCommands
}


selector( "value", "label", "paper" ) {
    insets = new Insets3f( 1, 2, 0, 2 );
    textHAlignment = HAlignment.Right;
    background = border1.clone();
    background.color = color(0.5, 0.4, 0.4, 0.25)
    color = color(0.1, 0.1, 0.2, 0.85)
}

selector("hud", "label", "paper") {
    fontSize = 14;
    color = color(1, 1, 0, 1);
}

selector("block", "popup", "paper") {
    fontSize = 20;
}

selector("block", "label", "paper") {
    fontSize = 20;
}

selector("block", "button", "paper") {
    fontSize = 20;
}

selector("block", "window.title", "paper") {
    fontSize = 20;
}

selector("block", "selector.item", "paper") {
    fontSize = 20;
}

selector("focus", "label", "paper") {
    fontSize = 14;
}

selector("window", "paper") {
    layout = new SpringGridLayout();
    background = oldPaper;
}

selector("contextMenu.window.container", "paper") {
    layout = new SpringGridLayout();
    background = popupBorder;
}

selector("dialog.window.container", "paper") {
    layout = new SpringGridLayout();
    background = oldPaper;
}

selector("heading.label", "paper") {
    color = color(0.1, 0.1, 3, 0.9);
    shadowColor = color(0, 0, 0.0, 0.25f)
}

selector("popup", "paper") {
    layout = new SpringGridLayout();
    background = popupBorder;
}

selector("flyover", "container", "paper") {
    layout = new SpringGridLayout();
    background = oldPaper;
}

selector("help", "window", "paper") {
    background = oldPaper;
}

selector("help.popup", "window", "paper") {
    background = oldPaper.clone();
    background.color = color(0.8, 0.8, 0.9, 1);
}

selector("help.popup.button", "paper") {
    fontSize = 14;
    border = plainPaper.clone();
    border.color = color(0.9, 0.9, 0.9, 1);
}

selector( "help", "title", "paper" ) {
    color = color(0.0, 0.0, 0.2, 1f)
    shadowColor = color(0, 0, 0.0, 0.25f)
    shadowOffset = new com.jme3.math.Vector3f(2, -2, -1);
    background = plainPaper.clone();
    background.color = color(0.9, 0.9, 0.9, 1);
    insets = new Insets3f(2, 2, 2, 2);
}

selector("help", "label", "paper") {
    color = color(0.05, 0.2, 0.05, 0.75f)
}

selector("map.label", "paper") {
    background = thinBox;
    textHAlignment = HAlignment.Center;
    textVAlignment = VAlignment.Center;
    insets = new Insets3f(2, 2, 2, 2);
}

selector("spacer", "paper") {
    background = thinBox;
    insets = new Insets3f(5, 5, 5, 5);
}

selector("object.label", "paper") {
    fontSize = 14;
}

selector( "column.title.label", "paper" ) {
    color = color(0.0, 0.0, 0.2, 1f)
    shadowColor = color(0, 0, 0.0, 0.25f)
    shadowOffset = new com.jme3.math.Vector3f(2, -2, -1);
    background = plainPaper.clone();
    background.color = color(0.9, 0.9, 0.9, 1);
    insets = new Insets3f(2, 2, 2, 2);
}

selector( "info.name.label", "paper" ) {
    fontSize = 20;
}

selector( "info.value.label", "paper" ) {
    fontSize = 20;
    insets = new Insets3f( 1, 2, 0, 2 );
    textHAlignment = HAlignment.Left;
    background = border1.clone();
    background.color = color(0.5, 0.4, 0.4, 0.25)
    color = color(0.2, 0.1, 0.2, 0.85)
}

selector( "time.label", "paper" ) {
    fontSize = 20;
    insets = new Insets3f(0, 3, 0, 3);
    textHAlignment = HAlignment.Center;
}

def boldColor = color(0.2, 0.2, 0.3, 1f)

selector( "book.title.label", "paper" ) {
    fontSize=36
    color = color(0.3, 0.2, 0.2, 1)
    shadowColor = color(0.3, 0.2, 0.2, 0.2f)
    shadowOffset = new com.jme3.math.Vector3f(3, -3, -1);
    background = null;
    insets = new Insets3f( 2, 2, 5, 2 );
}

selector("book", "h1.label", "paper") {
    fontSize=30
    color = boldColor
    shadowColor = boldColor
    shadowOffset = new com.jme3.math.Vector3f(1, 0, -1);
    insets = new Insets3f(10, 0, 5, 0);
}

selector("book", "h2.label", "paper") {
    fontSize=28
    color = boldColor
    shadowColor = boldColor
    shadowOffset = new com.jme3.math.Vector3f(1, 0, -1);
    insets = new Insets3f(10, 0, 5, 0);
}

selector("book", "h3.label", "paper") {
    color = boldColor
    shadowColor = boldColor
    shadowOffset = new com.jme3.math.Vector3f(1, 0, -1);
    insets = new Insets3f(10, 0, 5, 0);
}

selector("book", "text.label", "paper") {
    insets = new Insets3f(5, 0, 5, 0);
}

selector("book", "highlight.label", "paper") {
    insets = new Insets3f(5, 0, 5, 0);
    fontSize = 20;
    color = color(0.5, 0.2, 0.2, 1);
}

selector("book", "b1.label", "paper") {
    insets = new Insets3f(0, 10, 5, 0);
    icon = new IconComponent("Interface/bullet.png");
    icon.color = color(0.3, 0.1, 0.1, 0.85);
    icon.iconSize = new com.jme3.math.Vector2f(8f, 8f);
    icon.margin =  new com.jme3.math.Vector2f(8f, 8f);
}

selector("book", "image.label", "paper") {
    insets = new Insets3f(5, 0, 5, 0);
    textVAlignment = VAlignment.Center
}

selector("columns.container", "paper") {
    // Column-major layout
    layout = new SpringGridLayout(Axis.X, Axis.Y);
}

selector("column.container", "paper") {
    layout = new SpringGridLayout(Axis.Y, Axis.X, FillMode.None, FillMode.None);
    insets = new Insets3f(0, 0, 10, 10);
}

selector( "form.name.label", "paper" ) {
}

selector( "form.value", "button", "paper" ) {
    insets = new Insets3f(0, 0, 0, 0);
    background = null;
    border = drawnBox1.clone();
    border.setMargin(8, 2);
    color = color(0.2, 0.1, 0.2, 0.85)
}

selector( "form.value", "color.button", "paper" ) {
    border = drawnBox1.clone();
    border.setMargin(2, 2);
}

selector( "quatdEditor", "label", "paper" ) {
    fontSize = 20;
    insets = new Insets3f(5, 5, 0, 0);
}

selector( "action", "label", "paper" ) {
    color = color(0.2, 0.9, 0.8, 1);
    shadowColor = color(0, 0, 0, 1);
    background = new QuadBackgroundComponent(texture("/Interface/blurred-circle-128.png"));
    background.setMargin(50, 10);
    background.color = color(0.1, 0, 0, 0.75);
    //background = TbtQuadBackgroundComponent.create(
    //                                    texture(name:"/Interface/blurred-circle-128.png",
    //                                            generateMips:false),
    //                                            1f, 32, 32, 95, 95,
    //                                            1f, false);
    //background.setMargin(2, 2);
    // The above is probably really what I want but I would have to mess with image scale
    // because TbtQuad inverts itself when asked to be smaller than its natural border size.
}

selector( "object.name.label", "paper" ) {
    fontSize = 20;
    color = color(0.7, 0.7, 0.7, 1);
    shadowColor = color(0, 0, 0, 1);
    background = new QuadBackgroundComponent(texture("/Interface/blurred-circle-128.png"));
    background.setMargin(50, 10);
    background.color = color(0.1, 0, 0, 0.75);
}

selector( "object.status.label", "paper" ) {
    fontSize = 20;
    color = com.jme3.math.ColorRGBA.Cyan;//color(0.7, 0.7, 0.7, 1);
    shadowColor = color(0, 0, 0, 1);
    shadowOffset = new com.jme3.math.Vector3f(1, -1, -1);
    //background = new QuadBackgroundComponent(texture("/Interface/blurred-circle-128.png"));
    //background.setMargin(50, 10);
    //background.color = color(0.1, 0, 0, 0.75);
}

selector( "object.character.label", "paper" ) {
    fontSize = 20;
    color = com.jme3.math.ColorRGBA.Green;
    shadowColor = color(0, 0, 0, 1);
    shadowOffset = new com.jme3.math.Vector3f(1, -1, -1);
}

selector( "object.player.label", "paper" ) {
    fontSize = 20;
    color = com.jme3.math.ColorRGBA.Cyan;
    shadowColor = color(0, 0, 0, 1);
    shadowOffset = new com.jme3.math.Vector3f(1, -1, -1);
}

selector( "object.debug.label", "paper" ) {
    fontSize = 20;
    color = com.jme3.math.ColorRGBA.Magenta;
    shadowColor = color(0, 0, 0, 1);
    shadowOffset = new com.jme3.math.Vector3f(1, -1, -1);
}

selector("tracker", "title", "paper") {
    fontSize = 24;
    insets = new Insets3f(5, 15, 5, 15);
    color = color(0.1, 0.1, 0.3, 0.75f)
    shadowColor = null;
    background = null;
}

selector("thread.child", "label", "paper") {
    fontSize = 10;
    insets = new Insets3f(5, 5, 5, 5);
}

selector("tracker", "thread.child.progress.value", "paper") {
    background = new QuadBackgroundComponent(color(0.3, 0.5, 0.6, 1.0));
}

selector("background.thread", "title", "paper" ) {
    fontSize = 10
}
selector("background.thread", "label", "paper" ) {
    fontSize = 10
}

selector("map.line", "label", "paper" ) {
    fontSize = 16;
}

selector("help.tips", "label", "paper" ) {
    fontSize = 16;
    color = color(0.05, 0.2, 0.05, 0.75f)
}

selector( "screen.status.label", "paper" ) {
    fontSize = 32;
    color = com.jme3.math.ColorRGBA.Yellow;
    shadowColor = color(0, 0, 0, 1);
    shadowOffset = new com.jme3.math.Vector3f(2, -2, -1);
}

selector( "worldList.value", "paper" ) {
    color = color(0.2, 0.1, 0.05, 0.9)
    background = gradient.clone()
    background.setColor(color(0.6, 0.6, 0.4, 0.25))
    textHAlignment = HAlignment.Left;
}

selector( "editor.container", "paper" ) {
    background = scrollBg
}

selector("map.preview.container", "paper") {
    float borderSize = 5;
    border = new QuadBackgroundComponent(color(0.3f, 0.1f, 0.01f, 0.7f), borderSize, borderSize);
    background = plainPaper;
    insetsComponent = new DynamicInsetsComponent(0.5f, 0.5f, 0.5f, 0.5f);
}

selector("map.preview.image", "paper") {
    textHAlignment = HAlignment.Center;
    textVAlignment = VAlignment.Center;
    insets = new Insets3f(0, 0, 0, 0);
    color = color(0.2, 0.1, 0.05, 0.9)
}

selector("map.legend.window", "paper") {
    border = drawnBox1;
    background = plainPaper;
}

selector("map.legend.label", "paper") {
    fontSize = 10;
    textVAlignment = VAlignment.Center;
}


