/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.jme3.system.AppSettings;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.MouseInputAdapter;
import mythruna.client.MythrunaConfig;
import mythruna.client.opengl.BasicDisplaySettingsPanel;
import mythruna.client.opengl.DisplayModeProvider;
import mythruna.client.opengl.DisplaySettings;
import mythruna.client.opengl.ModeInfo;
import mythruna.client.swing.ComponentDragger;
import mythruna.client.web.SocialMediaLinks;
import mythruna.client.web.WebLink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplashWindow
extends JFrame {
    static Logger log = LoggerFactory.getLogger(SplashWindow.class);
    private DisplayModeProvider displayModes;
    private BasicDisplaySettingsPanel settings;
    private Runnable playCallback;
    private Runnable click;
    private JPanel media;

    public SplashWindow(DisplayModeProvider displayModes) {
        super("Mythruna Startup");
        this.displayModes = displayModes;
        this.playCallback = this.playCallback;
        Clip clip = null;
        this.click = clip == null ? () -> {} : () -> {
            clip.setFramePosition(0);
            clip.start();
        };
        this.setDefaultCloseOperation(2);
        this.setUndecorated(true);
        this.setAutoRequestFocus(true);
        ComponentDragger drag = new ComponentDragger();
        this.addMouseListener(drag);
        this.addMouseMotionListener(drag);
        ImageIcon dragon = this.getIcon("/Interface/dragon-64.png");
        this.setIconImage(dragon.getImage());
        ImageIcon splash = this.getIcon("/Interface/splash-title.png");
        ImagePanel root = new ImagePanel(splash);
        root.setLayout(new BorderLayout());
        this.getContentPane().add(root);
        ImageIcon box = this.getIcon("/Interface/drawn-box-64.png");
        ImageIcon paper = this.getIcon("/Interface/paper.jpg");
        int northMargin = 15;
        int eastMargin = 15;
        int westMargin = 20;
        int southMargin = 40;
        Font medium = new Font("Arial", 0, 16);
        Font bigger = new Font("Arial", 0, 20);
        Font biggest = new Font("Arial", 0, 30);
        JPanel north = new JPanel();
        root.add((Component)north, "North");
        north.setLayout(new BorderLayout());
        north.setBackground(new Color(0, 0, 0, 0));
        north.setBorder(new EmptyBorder(northMargin, 5, 5, eastMargin));
        north.setOpaque(false);
        JPanel east = new JPanel();
        root.add((Component)east, "East");
        east.setLayout(new BorderLayout());
        east.setBackground(new Color(0, 0, 0, 0));
        east.setOpaque(false);
        east.setBorder(new EmptyBorder(5, 5, southMargin, eastMargin));
        this.media = new JPanel();
        east.add((Component)this.media, "South");
        this.media.setLayout(new BoxLayout(this.media, 1));
        this.media.setBackground(new Color(0, 0, 0, 0));
        this.media.setOpaque(false);
        new Thread(() -> {
            log.info("Loading social media links...");
            List<WebLink> links = SocialMediaLinks.getWebLinks();
            SwingUtilities.invokeLater(() -> this.setSocialMedia(links));
        }).start();
        JPanel west = new JPanel();
        root.add((Component)west, "West");
        west.setLayout(new BorderLayout());
        west.setBorder(new EmptyBorder(5, westMargin, southMargin, 5));
        west.setBackground(new Color(0, 0, 0, 0));
        west.setOpaque(false);
        JPanel game = new JPanel();
        west.add((Component)game, "South");
        boolean showSettingsButton = false;
        int numButtons = showSettingsButton ? 3 : 2;
        game.setLayout(new GridLayout(numButtons, 1));
        game.setBackground(new Color(0, 0, 0, 0));
        game.setOpaque(false);
        MatteBorder boxBorder = new MatteBorder(5, 5, 5, 5, this.getIcon("/Interface/brown-tile.png"));
        EmptyBorder margin = new EmptyBorder(5, 5, 5, 5);
        CompoundBorder buttonBorder = new CompoundBorder(margin, boxBorder);
        Color buttonBackground = new Color(247, 217, 180, 255);
        float buttonAlpha = 0.4f;
        ImageButton button = new ImageButton("Play", paper);
        button.setFont(biggest);
        button.setBorder(buttonBorder);
        button.insets = new Insets(5, 5, 5, 5);
        button.alpha = buttonAlpha;
        button.setOpaque(false);
        button.addActionListener(this::startGame);
        button.requestFocus();
        game.add(button);
        button = new ImageButton("Settings", paper);
        button.setFont(biggest);
        button.setBorder(buttonBorder);
        button.insets = new Insets(5, 5, 5, 5);
        button.alpha = buttonAlpha;
        button.setOpaque(false);
        button.addActionListener(e -> this.openSettings());
        if (showSettingsButton) {
            game.add(button);
        }
        Dimension dim = button.getPreferredSize();
        button = new ImageButton("Exit", paper);
        button.setFont(biggest);
        button.setBorder(buttonBorder);
        button.insets = new Insets(5, 5, 5, 5);
        button.alpha = buttonAlpha;
        button.setOpaque(false);
        button.setPreferredSize(dim);
        game.add(button);
        button.addActionListener(e -> this.exit());
        JPanel center = new JPanel();
        root.add((Component)center, "Center");
        center.setOpaque(false);
        center.setBackground(new Color(0, 0, 0, 0));
        center.setLayout(new BorderLayout());
        center.setBorder(new EmptyBorder(5, 5, southMargin, 5));
        this.settings = new BasicDisplaySettingsPanel(displayModes, bigger);
        this.settings.addRepaintListener(() -> {
            log.info("---------trying to repaint---------");
            this.setBackground(Color.black);
            this.setBackground(new Color(0, 0, 0, 0));
        });
        this.settings.setFullScreen(true);
        this.settings.setResolution(displayModes.getCurrentDisplayMode().getResolution());
        center.add((Component)this.settings, "South");
        Color settingsBackground = new Color(247, 217, 180, 64);
        this.settings.setBackground(settingsBackground);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setBackground(new Color(0, 0, 0, 0));
    }

    public void popup(Runnable playCallback) {
        this.playCallback = playCallback;
        MythrunaConfig config = MythrunaConfig.getInstance();
        String settingsJson = config.getStartupSetting("settings.displaySettings", null);
        if (settingsJson != null) {
            try {
                DisplaySettings displaySettings = MythrunaConfig.fromJson(settingsJson, DisplaySettings.class);
                this.settings.setDisplaySettings(displaySettings);
            }
            catch (Exception e) {
                log.error("Error configuring display settings from JSON:" + settingsJson, (Throwable)e);
            }
        }
        this.setVisible(true);
        EventQueue.invokeLater(() -> {
            this.setAlwaysOnTop(true);
            this.toFront();
            EventQueue.invokeLater(() -> {
                this.setAlwaysOnTop(false);
                this.repaint();
            });
        });
    }

    public AppSettings getAppSettings() {
        MythrunaConfig config = MythrunaConfig.getInstance();
        AppSettings appSettings = new AppSettings(true);
        DisplaySettings displaySettings = this.settings.getDisplaySettings();
        if (displaySettings == null) {
            appSettings.setWidth(1280);
            appSettings.setHeight(720);
        } else {
            ModeInfo mode = displaySettings.getMode();
            appSettings.setWidth(mode.getResolution().getWidth());
            appSettings.setHeight(mode.getResolution().getHeight());
            appSettings.setFullscreen(mode.isFullscreen());
            appSettings.setSamples(displaySettings.getMsaaSamples());
            if (mode.isFullscreen()) {
                appSettings.setBitsPerPixel(mode.getBitsPerPixel());
                appSettings.setFrequency(mode.getFrequency());
            }
        }
        appSettings.setVSync(true);
        appSettings.setGammaCorrection(false);
        boolean enableJoysticks = config.getStartupSetting("joysticks.enabled", true);
        appSettings.setUseJoysticks(enableJoysticks);
        log.info("joysticks enabled:" + enableJoysticks);
        Boolean disableAudio = config.getStartupSetting("DisableAudio", Boolean.FALSE);
        if (disableAudio.booleanValue()) {
            appSettings.setAudioRenderer(null);
        }
        log.info("audio renderer:" + appSettings.getAudioRenderer());
        return appSettings;
    }

    public DisplaySettings getDisplaySettings() {
        return this.settings.getDisplaySettings();
    }

    protected void setSocialMedia(Collection<WebLink> links) {
        for (WebLink link : links) {
            Dimension size = new Dimension(64, 64);
            ImageButton open = new ImageButton("", null);
            this.media.add(open);
            open.addActionListener(e -> this.openWebPage(link.getUrlTemplate()));
            open.setIcon(this.getIcon(link.getIconResource()));
            open.setToolTipText(link.getToolTip());
            open.setPreferredSize(size);
            open.setMinimumSize(size);
        }
    }

    protected void startGame(ActionEvent event) {
        this.playCallback.run();
        this.dispose();
        this.click.run();
    }

    protected void openSettings() {
        this.click.run();
    }

    protected void exit() {
        this.dispose();
        this.click.run();
    }

    protected void openWebPage(String page) {
        try {
            Desktop.getDesktop().browse(new URI(page));
            this.click.run();
        }
        catch (Exception e) {
            log.error("Error opending page:" + page, (Throwable)e);
        }
    }

    private ImageIcon getIcon(String resource) {
        URL u = this.getClass().getResource(resource);
        return new ImageIcon(u);
    }

    private Clip getClip(String resource) {
        URL u = this.getClass().getResource(resource);
        try {
            Clip clip = AudioSystem.getClip();
            log.info("clip:" + clip);
            log.info("Loading:" + u);
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(u);
            log.info("stream:" + audioInputStream);
            clip.open(audioInputStream);
            return clip;
        }
        catch (Throwable e) {
            log.error("Error opening audio clip:" + resource);
            return null;
        }
    }

    private /* synthetic */ void lambda$new$6(ActionEvent e) {
        this.openWebPage("https://bsky.app/profile/simsilica.bsky.social");
    }

    private /* synthetic */ void lambda$new$5(ActionEvent e) {
        this.openWebPage("https://bsky.app/profile/simsilica.bsky.social");
    }

    private /* synthetic */ void lambda$new$4(ActionEvent e) {
        this.openWebPage("https://bsky.app/profile/simsilica.bsky.social");
    }

    private /* synthetic */ void lambda$new$3(ActionEvent e) {
        this.openWebPage("https://bsky.app/profile/simsilica.bsky.social");
    }

    private /* synthetic */ void lambda$new$2(ActionEvent e) {
        this.dispose();
    }

    private class ImagePanel
    extends JPanel {
        private ImageIcon background;

        public ImagePanel(ImageIcon background) {
            this.background = background;
            this.setBackground(new Color(0, 0, 0, 0));
            this.setPreferredSize(new Dimension(background.getIconWidth(), background.getIconHeight()));
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.background.paintIcon(this, g, 0, 0);
        }
    }

    private class ImageButton
    extends JButton {
        private ImageIcon background;
        private Insets insets;
        private float alpha;

        public ImageButton(String text, ImageIcon background) {
            super(text);
            this.insets = new Insets(0, 0, 0, 0);
            this.alpha = 1.0f;
            this.background = background;
            this.setBackground(new Color(0, 0, 0, 0));
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.background != null) {
                AlphaComposite ac;
                g.setColor(this.getBackground());
                Rectangle r = g.getClipBounds();
                g.fillRect(r.x, r.y, r.width, r.height);
                if (this.alpha != 1.0f) {
                    ac = AlphaComposite.getInstance(3, this.alpha);
                    ((Graphics2D)g).setComposite(ac);
                }
                g.drawImage(this.background.getImage(), this.insets.left, this.insets.top, this.getWidth() - this.insets.left, this.getHeight() - this.insets.top, 0, 0, this.background.getIconWidth(), this.background.getIconHeight(), this);
                if (this.alpha != 1.0f) {
                    ac = AlphaComposite.getInstance(3, 1.0f);
                    ((Graphics2D)g).setComposite(ac);
                }
            }
            super.paintComponent(g);
        }
    }

    private class DragListener
    extends MouseInputAdapter {
        Point location;
        MouseEvent pressed;

        private DragListener(SplashWindow splashWindow) {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            this.pressed = me;
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            Component component = me.getComponent();
            this.location = component.getLocation(this.location);
            int x = this.location.x - this.pressed.getX() + me.getX();
            int y = this.location.y - this.pressed.getY() + me.getY();
            component.setLocation(x, y);
        }
    }
}

