/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.post;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.post.Filter;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClippedDepthOfFieldFilter
extends Filter {
    static Logger log = LoggerFactory.getLogger(ClippedDepthOfFieldFilter.class);
    private float focusDistance = 50.0f;
    private float focusRange = 10.0f;
    private float blurScale = 1.0f;
    private float blurThreshold = 0.2f;
    private float xScale;
    private float yScale;
    private float yClip = 0.0f;
    private boolean debugUnfocus;

    public ClippedDepthOfFieldFilter() {
        super("Clipped Depth Of Field");
    }

    public void setYClip(float yClip) {
        this.yClip = yClip;
        if (this.material != null) {
            this.material.setFloat("YClip", yClip);
        }
    }

    public float getYClip() {
        return this.yClip;
    }

    public void setFocusDistance(float f) {
        this.focusDistance = f;
        if (this.material != null) {
            this.material.setFloat("FocusDistance", this.focusDistance);
        }
    }

    public float getFocusDistance() {
        return this.focusDistance;
    }

    public void setFocusRange(float f) {
        this.focusRange = f;
        if (this.material != null) {
            this.material.setFloat("FocusRange", this.focusRange);
        }
    }

    public float getFocusRange() {
        return this.focusRange;
    }

    public void setBlurScale(float f) {
        this.blurScale = f;
        if (this.material != null) {
            this.material.setFloat("XScale", this.blurScale * this.xScale);
            this.material.setFloat("YScale", this.blurScale * this.yScale);
        }
    }

    public float getBlurScale() {
        return this.blurScale;
    }

    public void setBlurThreshold(float f) {
        this.blurThreshold = f;
        if (this.material != null) {
            this.material.setFloat("BlurThreshold", this.blurThreshold);
        }
    }

    public float getBlurThreshold() {
        return this.blurThreshold;
    }

    public void setDebugUnfocus(boolean b) {
        this.debugUnfocus = b;
        if (this.material != null) {
            this.material.setBoolean("DebugUnfocus", this.debugUnfocus);
        }
    }

    public boolean getDebugUnfocus() {
        return this.debugUnfocus;
    }

    protected boolean isRequiresDepthTexture() {
        return true;
    }

    protected Material getMaterial() {
        return this.material;
    }

    protected void initFilter(AssetManager assets, RenderManager renderManager, ViewPort vp, int w, int h) {
        this.material = new Material(assets, "MatDefs/Post/ClippedDepthOfField.j3md");
        this.material.setFloat("FocusDistance", this.focusDistance);
        this.material.setFloat("FocusRange", this.focusRange);
        this.material.setFloat("BlurThreshold", this.blurThreshold);
        this.material.setBoolean("DebugUnfocus", this.debugUnfocus);
        this.material.setFloat("YClip", this.yClip);
        this.xScale = 1.0f / (float)w;
        this.yScale = 1.0f / (float)h;
        this.material.setFloat("XScale", this.blurScale * this.xScale);
        this.material.setFloat("YScale", this.blurScale * this.yScale);
    }
}

