/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.namegen;

import com.simsilica.namegen.Branches;
import com.simsilica.namegen.Cluster;
import com.simsilica.namegen.ClusterPair;
import com.simsilica.namegen.ClusterType;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameGenerator
implements Serializable {
    static Logger log = LoggerFactory.getLogger(NameGenerator.class);
    private static final long serialVersionUID = 42L;
    private static final Cluster START = new Cluster("^", ClusterType.Start);
    private static final Cluster END = new Cluster("$", ClusterType.End);
    private int minClusters = Integer.MAX_VALUE;
    private int maxClusters = 0;
    private Map<ClusterPair, Branches> branchIndex = new HashMap<ClusterPair, Branches>();
    private Branches rootBranches = this.getBranches(START, START, true);

    public int getMinClusters() {
        return this.minClusters;
    }

    public int getMaxClusters() {
        return this.maxClusters;
    }

    public void train(String text) {
        List<Cluster> clusters = Cluster.toClusters(text);
        if (clusters.size() < 2) {
            return;
        }
        this.minClusters = Math.min(this.minClusters, clusters.size());
        this.maxClusters = Math.max(this.maxClusters, clusters.size());
        Cluster lastCluster = START;
        Branches lastBranches = this.rootBranches;
        for (Cluster cluster : clusters) {
            lastBranches.addNext(cluster);
            lastBranches = this.getBranches(lastCluster, cluster, true);
            lastCluster = cluster;
        }
        if (lastCluster != START) {
            lastBranches.addNext(END);
        }
    }

    public List<Cluster> generateWord(int minLength, int maxLength, Random rand) {
        ArrayList<Cluster> result = new ArrayList<Cluster>();
        int size = 0;
        Branches branches = this.rootBranches;
        while (branches != null) {
            double roll = rand.nextDouble();
            if (size >= maxLength && branches.hasTerminator()) break;
            Cluster best = branches.getNext(roll, size < minLength);
            if (best == null) {
                log.warn("Failed to getNext(" + roll + ", " + (size < minLength) + ") for:" + branches);
                Cluster originalSecond = branches.getParent().getSecond();
                branches = this.getBranches(START, originalSecond, false);
                if (branches == null) {
                    log.warn("No root branches either for:" + originalSecond);
                    System.out.println("No root branches either for:" + originalSecond);
                    break;
                }
                best = branches.getNext(roll, size < minLength);
                if (best == null) {
                    log.warn("Failed to getNext(" + roll + ", " + (size < minLength) + ") for:" + branches);
                    System.out.println("Failed to getNext(" + roll + ", " + (size < minLength) + ") for:" + branches);
                    break;
                }
            }
            if (best.getType() == ClusterType.End) break;
            result.add(best);
            ++size;
            Branches newBranches = this.getBranches(branches.getParent().getSecond(), best, false);
            if (newBranches == null) {
                log.warn("Premature end, missing branches for:" + branches.getParent().getSecond() + ", " + best);
                System.out.println("Premature end, missing branches for:" + branches.getParent().getSecond() + ", " + best);
                result.add(new Cluster("BAD", ClusterType.End));
                break;
            }
            branches = newBranches;
        }
        return result;
    }

    public List<Cluster> getMostPopular() {
        ArrayList<Cluster> result = new ArrayList<Cluster>();
        HashSet<Branches> visited = new HashSet<Branches>();
        Branches branches = this.rootBranches;
        while (branches != null) {
            Map.Entry<Cluster, Integer> child2;
            if (!visited.add(branches)) {
                log.warn("Detected loop at:" + branches);
                System.out.println("Detected loop at:" + branches);
                break;
            }
            Cluster best = null;
            int max = 0;
            for (Map.Entry<Cluster, Integer> child2 : branches.getChildren().entrySet()) {
                if (child2.getValue() <= max) continue;
                best = (Cluster)child2.getKey();
                max = (Integer)child2.getValue();
            }
            int similar = 0;
            child2 = branches.getChildren().entrySet().iterator();
            while (child2.hasNext()) {
                Map.Entry child3 = (Map.Entry)child2.next();
                if ((Integer)child3.getValue() != max) continue;
                ++similar;
            }
            if (similar > 1) {
                System.out.println(similar + " similar to:" + best);
            }
            if (best.getType() == ClusterType.End) break;
            result.add(best);
            Branches nextBranches = this.getBranches(branches.getParent().getSecond(), best, false);
            if (nextBranches == null) {
                log.warn("Premature end, missing branches for:" + branches.getParent().getSecond() + ", " + best);
                System.out.println("Premature end, missing branches for:" + branches.getParent().getSecond() + ", " + best);
            }
            branches = nextBranches;
        }
        return result;
    }

    protected Branches getBranches(Cluster first, Cluster second, boolean create) {
        ClusterPair key = new ClusterPair(first, second);
        Branches branches = this.branchIndex.get(key);
        if (branches == null && create) {
            branches = new Branches(key);
            this.branchIndex.put(key, branches);
        }
        return branches;
    }

    public void write(File f) throws Exception {
        FileOutputStream fOut = new FileOutputStream(f);
        GZIPOutputStream zOut = new GZIPOutputStream(fOut);
        BufferedOutputStream bOut = new BufferedOutputStream(zOut, 16384);
        try (ObjectOutputStream out = new ObjectOutputStream(bOut);){
            out.writeObject(this);
        }
    }

    public static NameGenerator read(File f) throws Exception {
        return NameGenerator.read(new FileInputStream(f));
    }

    public static NameGenerator read(InputStream inStream) throws Exception {
        GZIPInputStream zIn = new GZIPInputStream(inStream);
        BufferedInputStream bIn = new BufferedInputStream(zIn, 16384);
        try (ObjectInputStream in = new ObjectInputStream(bIn);){
            NameGenerator nameGenerator = (NameGenerator)in.readObject();
            return nameGenerator;
        }
    }
}

