/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.cave;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.DataVersion;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.TileFunction;
import com.simsilica.mworld.tile.morph.Morphology;
import com.simsilica.mworld.tile.morph.MorphologyLayer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import mythruna.world.cave.CaveNetwork;
import mythruna.world.cave.Influencer;
import mythruna.world.tile.FeatureId;
import mythruna.world.tile.Sedectile;
import mythruna.world.tile.SedectileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaveTileFunction
implements TileFunction {
    static Logger log = LoggerFactory.getLogger(CaveTileFunction.class);
    private SedectileManager sedectileManager;
    private static InfluencerComparator COMPARATOR = new InfluencerComparator();

    public CaveTileFunction(SedectileManager sedectileManager) {
        this.sedectileManager = sedectileManager;
    }

    public void accept(Tile tile) {
        if (log.isTraceEnabled()) {
            log.trace("accept(" + tile + ")");
        }
        TileId tileId = tile.getTileId();
        MorphologyLayer morph = (MorphologyLayer)tile.get(MorphologyLayer.class);
        if (morph == null) {
            morph = new MorphologyLayer(tileId, new DataVersion(0L, -1L));
            tile.put(MorphologyLayer.class, (Object)morph);
        } else if (morph.getVersion().getLoadVersion() >= 0L) {
            return;
        }
        Sedectile sedectile = this.sedectileManager.getSedectile(tileId.getSedectileId());
        ArrayList<Influencer> list = new ArrayList<Influencer>();
        for (FeatureId<CaveNetwork> id : sedectile.getFeatureIds(tileId, CaveNetwork.class)) {
            CaveNetwork caves = this.sedectileManager.getFeatures().getFeature(id, CaveNetwork.class);
            for (Influencer influencer : caves.getInfluencers()) {
                if (!influencer.intersects(tileId)) continue;
                int index = Collections.binarySearch(list, influencer, COMPARATOR);
                if (index < 0) {
                    ++index;
                    index = -index;
                }
                list.add(index, influencer);
            }
        }
        for (Influencer influencer : list) {
            morph.addMorphology((Morphology)influencer);
        }
    }

    private static class InfluencerComparator
    implements Comparator<Influencer> {
        private InfluencerComparator() {
        }

        @Override
        public int compare(Influencer i1, Influencer i2) {
            Vec3i min1 = i1.getMin();
            Vec3i min2 = i2.getMin();
            return -Integer.compare(min1.y, min2.y);
        }
    }
}

