/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.core;

import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

public class VersionedReferenceList
extends AbstractList<VersionedReference> {
    private final List<VersionedReference> list = new ArrayList<VersionedReference>();
    private VersionedReference[] array;
    private long lastVersion;

    public static VersionedReferenceList create(VersionedObject ... objects) {
        VersionedReferenceList result = new VersionedReferenceList();
        result.addReferences(objects);
        return result;
    }

    public void addReferences(VersionedObject ... objects) {
        for (VersionedObject vo : objects) {
            this.add(vo.createReference());
        }
    }

    public void addReference(VersionedObject o) {
        this.add(o.createReference());
    }

    public boolean removeReference(VersionedObject o) {
        for (VersionedReference ref : this.getArray()) {
            if (ref.get() != o) continue;
            this.remove(ref);
            return true;
        }
        return false;
    }

    @Override
    public VersionedReference get(int index) {
        return this.list.get(index);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public VersionedReference set(int index, VersionedReference element) {
        VersionedReference result = this.list.set(index, element);
        this.array = null;
        return result;
    }

    @Override
    public void add(int index, VersionedReference element) {
        this.list.add(index, element);
        this.array = null;
    }

    @Override
    public VersionedReference remove(int index) {
        VersionedReference result = this.list.remove(index);
        this.array = null;
        return result;
    }

    private VersionedReference[] getArray() {
        if (this.array != null) {
            return this.array;
        }
        this.array = new VersionedReference[this.list.size()];
        this.array = this.list.toArray(this.array);
        return this.array;
    }

    public long getLastVersion() {
        return this.lastVersion;
    }

    public long getObjectVersion() {
        long v = 0L;
        for (VersionedReference ref : this.getArray()) {
            v += ref.getObjectVersion();
        }
        return v;
    }

    public boolean needsUpdate() {
        return this.lastVersion != this.getObjectVersion();
    }

    public boolean update() {
        long version = this.getObjectVersion();
        if (version == this.lastVersion) {
            return false;
        }
        this.lastVersion = this.getObjectVersion();
        return true;
    }
}

