/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile.insert;

import com.simsilica.mworld.DataVersion;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.db.ParentIdFileFunction;
import com.simsilica.mworld.db.SpoolingObjectDb;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.TileFunction;
import com.simsilica.mworld.tile.insert.InsertLayer;
import com.simsilica.mworld.tile.insert.InsertLayerProtocol;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.function.Function;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertLayerDb
extends SpoolingObjectDb<TileId, InsertLayer> {
    static Logger log = LoggerFactory.getLogger(InsertLayerDb.class);
    private File root;
    private InsertLayerProtocol protocol;
    private Function<TileId, File> fileFunc;

    public InsertLayerDb(File root, InsertLayerProtocol protocol) {
        this.root = root;
        this.protocol = protocol;
        this.fileFunc = new ParentIdFileFunction<TileId>(root, "inserts");
    }

    public InsertLayerProtocol getProtocol() {
        return this.protocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(TileId key, InsertLayer value) {
        DataVersion version;
        DataVersion dataVersion = version = value.getVersion();
        synchronized (dataVersion) {
            if (version.getLoadVersion() == -1L) {
                version.resetChanged(System.currentTimeMillis());
                version.markChanged();
            }
        }
        super.update(key, value);
    }

    public TileFunction getLoadFunction() {
        return new TileFunction(){

            @Override
            public void accept(Tile tile) {
                InsertLayer layer = tile.get(InsertLayer.class);
                if (layer != null) {
                    throw new IllegalStateException("Tile:" + tile.getTileId() + " already has morphology layer");
                }
                layer = (InsertLayer)InsertLayerDb.this.get(tile.getTileId());
                tile.put(InsertLayer.class, layer);
            }
        };
    }

    public TileFunction getSaveFunction() {
        return new TileFunction(){

            @Override
            public void accept(Tile tile) {
                InsertLayer layer = tile.get(InsertLayer.class);
                if (layer.getVersion().isChanged()) {
                    log.info("Storing:" + layer);
                    InsertLayerDb.this.update(layer.getTileId(), layer);
                }
            }
        };
    }

    protected File toFile(TileId id) {
        return this.fileFunc.apply(id);
    }

    @Override
    protected InsertLayer loadObject(TileId id) {
        File file = this.toFile(id);
        if (file.exists()) {
            return this.readObjectFile(id, file);
        }
        return new InsertLayer(id, new DataVersion(0L, -1L));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected InsertLayer readObjectFile(TileId id, File file) {
        try (BufferedInputStream in = new BufferedInputStream(new GZIPInputStream(new FileInputStream(file)));){
            InsertLayer result = this.protocol.read(in);
            assert (id.equals(result.getTileId()));
            InsertLayer insertLayer = result;
            return insertLayer;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading object:" + id + " from:" + file, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void storeObject(TileId id, InsertLayer value) {
        DataVersion version;
        File file = this.toFile(id);
        DataVersion dataVersion = version = value.getVersion();
        synchronized (dataVersion) {
            this.writeObjectFile(id, file, value);
            version.resetChanged(System.currentTimeMillis());
        }
    }

    protected void writeObjectFile(TileId id, File file, InsertLayer value) {
        long start = System.nanoTime();
        try (BufferedOutputStream out = new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(file)));){
            this.protocol.write(value, out);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing object:" + id + " to:" + file, e);
        }
        long end = System.nanoTime();
        log.info("Wrote [" + id + "] in " + (double)(end - start) / 1000000.0 + " ms");
    }
}

