#import "Common/ShaderLib/GLSLCompat.glsllib"

#if defined(HAS_GLOWMAP) || defined(HAS_COLORMAP) || (defined(HAS_LIGHTMAP) && !defined(SEPARATE_TEXCOORD))
    #define NEED_TEXCOORD1
#endif

#if defined(DISCARD_ALPHA)
    uniform float m_AlphaDiscardThreshold;
#endif

uniform vec4 m_Color;
uniform sampler2D m_ColorMap1;
uniform sampler2D m_ColorMap2;
uniform sampler2D m_ColorMap3;
uniform sampler2D m_MixMap;
uniform sampler2D m_LightMap;

#ifdef DESATURATION
    uniform float m_DesaturationValue;
#endif

varying vec2 texCoord1;
varying vec2 texCoord2;

varying vec4 vertColor;

void main(){
    vec4 color = vec4(1.0);
    #ifdef HAS_MIXMAP
        vec4 mixValues = texture2D(m_MixMap, texCoord1);
        mixValues.rgb *= mixValues.a;
    #else
        vec4 mixValues = vec4(1.0);
    #endif

    #ifdef HAS_COLORMAP1
        color *= texture2D(m_ColorMap1, texCoord1);
    #endif

    #ifdef HAS_COLORMAP2
        vec4 texColor = texture2D(m_ColorMap2, texCoord1);
        #ifdef HAS_MIXMAP
            float blend = mixValues.r;
        #else
            float blend = texColor.a;
        #endif
        color = mix(color, texColor, blend);
    #endif

    #ifdef HAS_VERTEXCOLOR
        color *= vertColor;
    #endif

    #ifdef HAS_COLOR
        color *= m_Color;
    #endif

    #ifdef HAS_LIGHTMAP
        #ifdef SEPARATE_TEXCOORD
            color.rgb *= texture2D(m_LightMap, texCoord2).rgb;
        #else
            color.rgb *= texture2D(m_LightMap, texCoord1).rgb;
        #endif
    #endif

    #if defined(DISCARD_ALPHA)
        if(color.a < m_AlphaDiscardThreshold){
           discard;
        }
    #endif

    #ifdef DESATURATION
        vec3 gray = vec3(dot(vec3(0.2126,0.7152,0.0722), color.rgb));
        color.rgb = vec3(mix(color.rgb, gray, m_DesaturationValue));
    #endif

    gl_FragColor = color;
}
