/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.state;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.util.SafeArrayList;
import com.simsilica.lemur.DefaultRangedValueModel;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.RangedValueModel;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageState
extends BaseAppState {
    private static Logger log = LoggerFactory.getLogger(MessageState.class);
    public static final ElementId MESSAGE_LABEL_ID = new ElementId("console.message.label");
    private Node messageRoot;
    private Vector3f offset = new Vector3f();
    private ConcurrentLinkedQueue<Message> pendingMessages = new ConcurrentLinkedQueue();
    private SafeArrayList<Message> messages = new SafeArrayList(Message.class);
    private float fadeRate = 0.06666667f;
    private float alphaOverride = 0.0f;
    private Supplier<Float> maxWidth;
    private float fontScale = 1.0f;
    private int historySize = 0;
    private RangedValueModel scroll = new DefaultRangedValueModel(0.0, 0.0, 0.0);
    private VersionedReference<Double> scrollRef = this.scroll.createReference();
    float nextTime = 1.0f;

    public void setFontScale(Float fontScale) {
        if (Objects.equals(Float.valueOf(this.fontScale), fontScale)) {
            return;
        }
        this.fontScale = fontScale.floatValue();
        this.resetFontScale();
    }

    public float getFontScale() {
        return this.fontScale;
    }

    public void setHistorySize(int historySize) {
        if (this.historySize == historySize) {
            return;
        }
        this.historySize = historySize;
        this.refreshLayout();
    }

    public int getHistorySize() {
        return this.historySize;
    }

    public void setScroll(int scroll) {
        this.scroll.setValue((double)scroll);
    }

    public int getScroll() {
        return (int)this.scroll.getValue();
    }

    public int getMaxScroll() {
        return (int)this.scroll.getMaximum();
    }

    public RangedValueModel getScrollModel() {
        return this.scroll;
    }

    public void setFadeTime(float seconds) {
        if (seconds == 0.0f) {
            this.fadeRate = 0.0f;
        }
        this.fadeRate = 1.0f / seconds;
    }

    public float getFadeTime() {
        return this.fadeRate == 0.0f ? 0.0f : 1.0f / this.fadeRate;
    }

    public void setMaxWidth(Supplier<Float> maxWidth) {
        this.maxWidth = maxWidth;
    }

    public Supplier<Float> getMaxWidth() {
        return this.maxWidth;
    }

    protected float calculateMaxWidth() {
        if (this.maxWidth != null) {
            return this.maxWidth.get().floatValue();
        }
        return this.getApplication().getCamera().getWidth();
    }

    public void setAlphaOverride(float alphaOverride) {
        this.alphaOverride = alphaOverride;
    }

    public float getAlphaOverride() {
        return this.alphaOverride;
    }

    public Label addMessage(String message) {
        return this.addMessage(new Label(message, MESSAGE_LABEL_ID));
    }

    public Label addMessage(String message, ColorRGBA color) {
        if (log.isTraceEnabled()) {
            log.trace("addMessage(" + message + ", " + color + ")");
        }
        Label result = new Label(message, MESSAGE_LABEL_ID);
        result.setMaxWidth(this.calculateMaxWidth());
        result.setColor(color);
        this.addMessage(result);
        return result;
    }

    public <T extends Panel> T addMessage(T label) {
        Message msg = new Message(label);
        this.pendingMessages.add(msg);
        return label;
    }

    protected void displayMessage(Message msg) {
        this.messages.add(0, (Object)msg);
        this.messageRoot.attachChild((Spatial)msg.label);
        this.refreshLayout();
    }

    public void setMessageRootOffset(Vector3f offset) {
        this.offset.set(offset);
        this.resetMessageRootLocation();
    }

    public Vector3f getMessageRootOffset() {
        return this.offset;
    }

    protected void initialize(Application app) {
        this.messageRoot = new Node("MessageRoot");
    }

    protected void cleanup(Application app) {
    }

    protected void addTestMessages(float tpf) {
        this.nextTime -= tpf;
        if (this.nextTime < 0.0f) {
            this.nextTime = (float)(Math.random() * 1.9) + 0.1f;
            int count = (int)(Math.random() * 4.0) + 1;
            for (int i = 0; i < count; ++i) {
                if (i % 2 == 0) {
                    this.addMessage("> Tick " + System.currentTimeMillis());
                    continue;
                }
                this.addMessage("> Tock " + System.currentTimeMillis());
            }
        }
    }

    public void update(float tpf) {
        Message msg = null;
        while ((msg = this.pendingMessages.poll()) != null) {
            this.displayMessage(msg);
        }
        for (Message m : (Message[])this.messages.getArray()) {
            m.update(tpf);
        }
        if (this.scrollRef.update()) {
            this.refreshLayout();
        }
    }

    protected void onEnable() {
        Node gui = ((SimpleApplication)this.getApplication()).getGuiNode();
        gui.attachChild((Spatial)this.messageRoot);
        this.resetMessageRootLocation();
    }

    protected void onDisable() {
        this.messageRoot.removeFromParent();
    }

    protected void resetMessageRootLocation() {
        this.messageRoot.setLocalTranslation(5.0f, 5.0f, 0.0f);
        this.messageRoot.move(this.offset);
    }

    protected void resetFontScale() {
        for (Message m : (Message[])this.messages.getArray()) {
            m.resetFontScale();
        }
        this.refreshLayout();
    }

    protected void refreshLayout() {
        int height = this.getApplication().getCamera().getHeight();
        int width = this.getApplication().getCamera().getWidth();
        float y = 0.0f;
        Message[] array = (Message[])this.messages.getArray();
        for (int i = 0; i < array.length; ++i) {
            Message m = array[i];
            if ((double)i < this.scroll.getValue()) {
                m.label.removeFromParent();
                continue;
            }
            Vector3f pref = m.label.getPreferredSize();
            m.label.setLocalTranslation(0.0f, y += pref.y, 0.0f);
            if (y > (float)height) {
                m.label.removeFromParent();
                if (i <= this.historySize) continue;
                this.messages.remove((Object)m);
                continue;
            }
            if (m.label.getParent() != null) continue;
            this.messageRoot.attachChild((Spatial)m.label);
        }
        this.scroll.setMaximum((double)this.calculateMaxScroll());
    }

    protected int calculateMaxScroll() {
        if (this.historySize > 0) {
            int maxIndex;
            float height = (float)this.getApplication().getCamera().getHeight() - this.offset.y;
            float ySize = 0.0f;
            int lastPageCount = 0;
            Message[] array = (Message[])this.messages.getArray();
            for (int i = maxIndex = Math.min(this.historySize, array.length) - 1; i >= 0; --i) {
                Message m = array[i];
                Vector3f pref = m.label.getPreferredSize();
                if ((ySize += pref.y) > height) break;
                ++lastPageCount;
            }
            if (array.length >= lastPageCount && lastPageCount > 0) {
                --lastPageCount;
            }
            return Math.max(0, maxIndex - lastPageCount);
        }
        return 0;
    }

    protected class Message {
        private float alpha;
        private Panel label;
        private float fontSize;

        public Message(Panel label) {
            this(label, 1.0f);
        }

        public Message(Panel label, float initialAlpha) {
            this.alpha = initialAlpha;
            this.label = label;
            if (label instanceof Label) {
                this.fontSize = ((Label)label).getFontSize();
                this.resetFontScale();
            }
        }

        protected void resetFontScale() {
            if (!(this.label instanceof Label)) {
                return;
            }
            Label l = (Label)this.label;
            l.setFontSize(MessageState.this.fontScale * this.fontSize);
        }

        public void update(float tpf) {
            this.alpha -= tpf * MessageState.this.fadeRate;
            if (this.alpha < 0.0f) {
                this.alpha = 0.0f;
            }
            float effectiveAlpha = 1.0f - this.alpha;
            effectiveAlpha *= effectiveAlpha;
            effectiveAlpha = 1.0f - effectiveAlpha;
            this.label.setAlpha(Math.max(effectiveAlpha, MessageState.this.alphaOverride));
        }
    }
}

