/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.clothing;

import com.simsilica.mathd.Vec3i;
import java.util.function.Supplier;
import mythruna.fabric.ClothingAccumulator;
import mythruna.fabric.FabricUtils;
import mythruna.fabric.SwatchShapeIndex;
import mythruna.fabric.Transform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MirrorTransform
implements ClothingAccumulator {
    static Logger log = LoggerFactory.getLogger(MirrorTransform.class);
    private ClothingAccumulator delegate;
    private Supplier<Boolean> on;

    public MirrorTransform(ClothingAccumulator delegate, Supplier<Boolean> on) {
        this.delegate = delegate;
        this.on = on;
    }

    public int getSizeX() {
        return this.delegate.getSizeX();
    }

    public int getSizeY() {
        return this.delegate.getSizeY();
    }

    public int getValue(int x, int y, int layer) {
        return this.delegate.getValue(x, y, layer);
    }

    public int getTopValue(int x, int y) {
        return this.delegate.getTopValue(x, y);
    }

    public int getLayer(int x, int y) {
        return this.delegate.getLayer(x, y);
    }

    public int addValue(int x, int y, int value) {
        int result = this.delegate.addValue(x, y, value);
        Vec3i alt = this.getAlternate(x, y);
        if (alt != null) {
            this.delegate.addValue(alt.x, alt.y, this.getTransform(value));
        }
        return result;
    }

    public int insertValue(int x, int y, int value) {
        int result = this.delegate.insertValue(x, y, value);
        Vec3i alt = this.getAlternate(x, y);
        if (alt != null) {
            this.delegate.insertValue(alt.x, alt.y, this.getTransform(value));
        }
        return result;
    }

    public int removeSwatch(int x, int y) {
        int result = this.delegate.removeSwatch(x, y);
        Vec3i alt = this.getAlternate(x, y);
        if (alt != null) {
            this.delegate.removeSwatch(alt.x, alt.y);
        }
        return result;
    }

    public int deleteValue(int x, int y) {
        int result = this.delegate.deleteValue(x, y);
        Vec3i alt = this.getAlternate(x, y);
        if (alt != null) {
            this.delegate.deleteValue(alt.x, alt.y);
        }
        return result;
    }

    protected Vec3i getAlternate(int x, int y) {
        if (!this.on.get().booleanValue()) {
            return null;
        }
        if (y <= 2) {
            if (x <= 15) {
                return new Vec3i(31 - x, y, 0);
            }
            int offset = 31 - x;
            return new Vec3i(offset, y, 0);
        }
        if (x >= 13 && x <= 18) {
            int xOffset = x - 13;
            if (y >= 6 && y <= 18) {
                int yOffset = y - 6;
                return new Vec3i(18 - xOffset, 19 + yOffset, 0);
            }
            int yOffset = y - 19;
            return new Vec3i(18 - xOffset, 6 + yOffset, 0);
        }
        if (y >= 5) {
            if (x <= 5) {
                return new Vec3i(12 - x, y, 0);
            }
            if (x >= 7 && x <= 12) {
                int xOffset = x - 7;
                return new Vec3i(5 - xOffset, y, 0);
            }
            if (x >= 19 && x <= 24) {
                int xOffset = x - 19;
                return new Vec3i(31 - xOffset, y, 0);
            }
            if (x >= 26) {
                int xOffset = x - 26;
                return new Vec3i(24 - xOffset, y, 0);
            }
        }
        return null;
    }

    protected int getTransform(int value) {
        int fabric = FabricUtils.toFabric((int)value);
        int shape = FabricUtils.toShape((int)value);
        shape = SwatchShapeIndex.transform((Transform)Transform.ReflectX, (int)shape, (int)1);
        return FabricUtils.toCell((int)shape, (int)fabric);
    }
}

