/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.edit;

import mythruna.client.ui.edit.Edit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeEdit
implements Edit {
    static Logger log = LoggerFactory.getLogger(CompositeEdit.class);
    private String display;
    private Edit[] delegates;

    public CompositeEdit(Edit ... delegates) {
        this(delegates[0].toDisplay(), delegates);
    }

    public CompositeEdit(String display, Edit ... delegates) {
        this.display = display;
        this.delegates = delegates;
    }

    @Override
    public String toDisplay() {
        return this.display;
    }

    @Override
    public void doEdit() {
        for (Edit e : this.delegates) {
            e.doEdit();
        }
    }

    @Override
    public void undoEdit() {
        for (Edit e : this.delegates) {
            e.undoEdit();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.toDisplay() + "]";
    }
}

