/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.map;

import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.Texture;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityCriteria;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.es.Name;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.core.GuiMaterial;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mworld.TileId;
import java.util.List;
import java.util.Objects;
import mythruna.client.ui.map.CustomMapMarkerEditor;
import mythruna.client.ui.map.DefaultMapToolLayer;
import mythruna.client.ui.map.MapPoint;
import mythruna.client.ui.map.MapToolState;
import mythruna.es.CustomMapMarker;
import mythruna.es.OwnedBy;
import mythruna.net.GameSession;
import mythruna.shape.IconName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomMarkerLayer
extends DefaultMapToolLayer {
    static Logger log = LoggerFactory.getLogger(CustomMarkerLayer.class);
    private GameSession gameSession;
    private EntityData ed;
    private MapToolState parent;
    private Node root;
    private EntityId avatarId;
    private MarkerContainer markers;
    private VersionedReference<List<TileId>> visibleTilesRef;
    private EntityId dragging;
    private MapPoint draggedEnd;
    private Vec3d dragOffset;
    private CustomMapMarkerEditor editor;
    private Label helpText;

    public CustomMarkerLayer(GameSession gameSession, EntityData ed, MapToolState parent) {
        this.gameSession = gameSession;
        this.ed = ed;
        this.parent = parent;
        this.root = new Node("customMarkerRoot");
        this.avatarId = gameSession.getAvatar();
        this.root.move(0.0f, 0.0f, 1.0f);
        parent.getToolRoot().attachChild((Spatial)this.root);
        this.visibleTilesRef = parent.createVisibleTilesRef();
        this.markers = new MarkerContainer(this.avatarId, ed);
        this.markers.setVisibleTiles((List)this.visibleTilesRef.get());
        this.helpText = new Label("Marker tool tips:\nLeft Mouse: Create\nRight Mouse: Move", new ElementId("help.tips.label"));
    }

    protected CustomMapMarkerEditor getEditor() {
        if (this.editor != null) {
            return this.editor;
        }
        this.editor = new CustomMapMarkerEditor(this.getToolId(), this.parent.getIcons().getIcons());
        return this.editor;
    }

    @Override
    protected void onActivate() {
        this.parent.setLayerEditor((Panel)this.helpText);
    }

    @Override
    protected void onDeactivate() {
        this.parent.setLayerEditor(null);
    }

    @Override
    public EntityId getEntityIdForCollision(Spatial collision) {
        Marker m = this.getMarker(collision);
        return m == null ? null : m.entity.getId();
    }

    @Override
    public void start() {
        this.markers.start();
    }

    @Override
    public void update() {
        if (this.visibleTilesRef.update()) {
            this.markers.setVisibleTiles((List)this.visibleTilesRef.get());
        }
        this.markers.update();
        for (Marker m : this.markers.getArray()) {
            m.updatePosition();
        }
    }

    @Override
    public void stop() {
        this.markers.stop();
    }

    protected void doCreate(CustomMapMarkerEditor editor) {
        log.info("doCreate()");
        Vec3d world = editor.getWorld();
        CustomMapMarker cm = new CustomMapMarker(editor.getIcon().getIconId(), editor.getMarkerSize(), editor.getPinSize(), TileId.fromWorld((Vec3d)world).getId());
        this.gameSession.runAction(this.getToolId(), "create", new Object[]{cm, editor.getName(), world, 0});
    }

    protected void doUpdate(CustomMapMarkerEditor editor) {
        log.info("doUpdate()");
        Vec3d world = editor.getWorld();
        CustomMapMarker cm = new CustomMapMarker(editor.getIcon().getIconId(), editor.getMarkerSize(), editor.getPinSize(), TileId.fromWorld((Vec3d)world).getId());
        this.gameSession.runAction(this.getToolId(), "update", new Object[]{editor.getEditing(), cm, editor.getName(), world, 0});
    }

    protected void doDelete(CustomMapMarkerEditor editor) {
        log.info("doDelete()");
        this.gameSession.runAction(this.getToolId(), "delete", new Object[]{editor.getEditing()});
    }

    @Override
    public void click(int button, Vec3d world, Spatial collision) {
        EntityId id = this.getEntityId(collision);
        if (button == 0) {
            if (id == null) {
                log.info("create:" + world);
                GuiGlobals.getInstance().getPopupState().centerInGui((Spatial)this.getEditor());
                this.getEditor().create(this.getToolId(), world, this::doCreate);
            } else {
                log.info("edit:" + world);
                Marker marker = (Marker)this.markers.getObject(id);
                if (marker != null) {
                    GuiGlobals.getInstance().getPopupState().centerInGui((Spatial)this.getEditor());
                    this.getEditor().edit(this.getToolId(), marker.entity, this::doUpdate, this::doDelete);
                }
            }
        }
    }

    @Override
    public void startDrag(int button, Vec3d start, Vec3d end, Spatial collision) {
        this.draggedEnd = null;
        EntityId id = this.getEntityId(collision);
        if (id == null) {
            return;
        }
        Marker marker = (Marker)this.markers.getObject(id);
        if (marker == null) {
            return;
        }
        if (button != 0 && button == 1) {
            this.dragging = id;
            this.draggedEnd = marker.location;
            this.dragOffset = this.draggedEnd.getWorld().subtract(start);
        }
    }

    @Override
    public void endDrag(int button, Vec3d start, Vec3d end, Spatial collision) {
        this.draggedEnd = null;
        if (this.dragging == null) {
            return;
        }
        log.info("Need to update entity:" + this.dragging);
        this.gameSession.runAction(this.getToolId(), "move", new Object[]{this.dragging, end.add(this.dragOffset)});
    }

    @Override
    public void drag(int button, Vec3d start, Vec3d end, Spatial collision) {
        if (this.draggedEnd != null) {
            this.draggedEnd.setWorld(end.add(this.dragOffset));
        }
    }

    protected EntityId getEntityId(Spatial spatial) {
        for (Spatial s = spatial; s != null; s = s.getParent()) {
            if (s == this.root || s == this.parent.getMapRoot()) {
                return null;
            }
            Long id = (Long)s.getUserData("oid");
            if (id == null) continue;
            return new EntityId(id.longValue());
        }
        return null;
    }

    protected Marker getMarker(Spatial collision) {
        EntityId hit = this.getEntityId(collision);
        if (hit == null) {
            return null;
        }
        return (Marker)this.markers.getObject(hit);
    }

    protected Geometry createIcon(String icon) {
        IconName iconName = IconName.parse((String)icon);
        String resource = iconName.getImageName();
        ColorRGBA color = ColorRGBA.Blue;
        Texture texture = GuiGlobals.getInstance().loadTexture(resource, false, false);
        GuiMaterial material = GuiGlobals.getInstance().createMaterial(color, false);
        material.setTexture(texture);
        float iconSize = 2.0f;
        float halfSize = iconSize * 0.5f;
        Quad quad = new Quad(iconSize, iconSize);
        quad.setBuffer(VertexBuffer.Type.Position, 3, new float[]{-halfSize, -halfSize, 0.0f, halfSize, -halfSize, 0.0f, halfSize, halfSize, 0.0f, -halfSize, halfSize, 0.0f});
        if (iconName.getX() != null && iconName.getY() != null) {
            float x = (float)iconName.getX().intValue() / 8.0f;
            float y = (float)iconName.getY().intValue() / 8.0f;
            float cellSize = 0.125f;
            quad.setBuffer(VertexBuffer.Type.TexCoord, 2, new float[]{x, y, x + cellSize, y, x + cellSize, y + cellSize, x, y + cellSize});
        } else {
            quad.setBuffer(VertexBuffer.Type.TexCoord, 2, new float[]{0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f});
        }
        quad.updateBound();
        Geometry geom = new Geometry(icon, (Mesh)quad);
        Material mat = material.getMaterial();
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        geom.setMaterial(mat);
        return geom;
    }

    private class MarkerContainer
    extends EntityContainer<Marker> {
        public MarkerContainer(EntityId avatarId, EntityData ed) {
            super(ed, new EntityCriteria().add(new Class[]{CustomMapMarker.class}).add(new Class[]{Name.class}).add(new Class[]{SpawnPosition.class}).add(new ComponentFilter[]{OwnedBy.filter((EntityId)avatarId)}));
        }

        public void setVisibleTiles(List<TileId> tiles) {
            EntityCriteria criteria = this.getCriteria();
            if (tiles.isEmpty()) {
                ComponentFilter filter1 = Filters.fieldEquals(CustomMapMarker.class, (String)"tileId", (Object)0);
                ComponentFilter filter2 = Filters.fieldEquals(CustomMapMarker.class, (String)"tileId", (Object)1);
                criteria.setFilter(CustomMapMarker.class, Filters.and(CustomMapMarker.class, (ComponentFilter[])new ComponentFilter[]{filter1, filter2}));
                this.setCriteria(criteria);
                return;
            }
            ComponentFilter[] filters = new ComponentFilter[tiles.size()];
            int index = 0;
            for (TileId id : tiles) {
                filters[index++] = Filters.fieldEquals(CustomMapMarker.class, (String)"tileId", (Object)id.getId());
            }
            criteria.setFilter(CustomMapMarker.class, Filters.or(CustomMapMarker.class, (ComponentFilter[])filters));
            this.setCriteria(criteria);
        }

        public Marker[] getArray() {
            return (Marker[])super.getArray();
        }

        protected Marker addObject(Entity entity) {
            Marker result = new Marker(entity);
            this.updateObject(result, entity);
            return result;
        }

        protected void updateObject(Marker marker, Entity entity) {
            marker.updateData();
        }

        protected void removeObject(Marker marker, Entity entity) {
            marker.release();
        }
    }

    private class Marker {
        private Entity entity;
        private CustomMapMarker info;
        private String iconName;
        private Node node;
        private Label label;
        private MapPoint location;
        private VersionedReference<MapPoint> locationRef;
        private Quatd orientation;
        private Geometry icon;
        private double iconScale = 1.0;
        private double labelScale = 0.075;

        public Marker(Entity entity) {
            this.entity = entity;
            this.node = new Node("marker:" + entity.getId());
            this.node.setUserData("oid", (Object)entity.getId().getId());
            this.label = new Label("Testing a longer string.", new ElementId("map.marker.label"));
            this.node.attachChild((Spatial)this.label);
            this.location = CustomMarkerLayer.this.parent.createMapPoint(new Vec3d());
            this.locationRef = this.location.createReference();
            CustomMarkerLayer.this.root.attachChild((Spatial)this.node);
        }

        public void updatePosition() {
            if (this.locationRef.update()) {
                this.resetLocation();
            }
        }

        public void updateData() {
            SpawnPosition sp = (SpawnPosition)this.entity.get(SpawnPosition.class);
            this.location.setWorld(sp.getLocation());
            this.orientation = sp.getOrientation();
            this.info = (CustomMapMarker)this.entity.get(CustomMapMarker.class);
            this.updateIcon(this.info.getIconName(CustomMarkerLayer.this.ed));
            String name = ((Name)this.entity.get(Name.class)).getName();
            if (!Objects.equals(name, this.label.getText())) {
                this.label.setText(name);
                this.label.setSize(this.label.getPreferredSize());
                this.resetLabelPosition();
            }
        }

        protected void updateIcon(String iconName) {
            if (Objects.equals(this.iconName, iconName)) {
                return;
            }
            if (this.icon != null) {
                this.icon.removeFromParent();
            }
            this.iconName = iconName;
            this.icon = CustomMarkerLayer.this.createIcon(iconName);
            this.node.attachChild((Spatial)this.icon);
            this.resetLocation();
        }

        protected void resetLocation() {
            this.node.setLocalTranslation(this.location.getView());
            double guiScale = this.location.getWorldToViewScale();
            this.iconScale = (double)this.info.getSize() * guiScale;
            this.iconScale = Math.max(this.iconScale, (double)this.info.getPinSize());
            if (this.icon != null) {
                this.icon.setLocalScale((float)this.iconScale);
            }
            this.labelScale = this.iconScale * 0.075;
            if (this.labelScale > 2.0) {
                this.labelScale = 2.0;
            }
            this.label.setLocalScale((float)this.labelScale);
            this.resetLabelPosition();
            Vector3f size = this.label.getSize();
            float labelExtent = (float)((double)size.x * this.labelScale * 0.5);
            Vector3f v = this.node.getLocalTranslation();
            boolean labelVisible = true;
            boolean iconVisible = true;
            Vector2f viewRadius = CustomMarkerLayer.this.parent.getViewRadius();
            if (v.x - labelExtent < -viewRadius.x) {
                labelVisible = false;
            }
            if (v.x < -viewRadius.x) {
                iconVisible = false;
            }
            if (v.x + labelExtent > viewRadius.x) {
                labelVisible = false;
            }
            if (v.x > viewRadius.x) {
                iconVisible = false;
            }
            if (v.y < -viewRadius.y) {
                labelVisible = false;
                iconVisible = false;
            }
            if (v.y > viewRadius.y) {
                labelVisible = false;
                iconVisible = false;
            }
            if (labelVisible) {
                this.label.setCullHint(Spatial.CullHint.Inherit);
            } else {
                this.label.setCullHint(Spatial.CullHint.Always);
            }
            if (iconVisible) {
                this.icon.setCullHint(Spatial.CullHint.Inherit);
            } else {
                this.icon.setCullHint(Spatial.CullHint.Always);
            }
        }

        protected void resetLabelPosition() {
            Vector3f size = this.label.getSize();
            float labelExtent = (float)((double)size.x * this.labelScale * 0.5);
            this.label.setLocalTranslation(-labelExtent, 0.0f, 0.0f);
        }

        public void release() {
            this.node.removeFromParent();
        }

        public String toString() {
            return "Marker[entity:" + this.entity + ", name:" + this.label.getText() + "]";
        }
    }
}

