/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view.input;

import com.simsilica.es.EntityId;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import mythruna.client.view.AvatarState;
import mythruna.client.view.input.ManipulatorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwingManipulator
implements ManipulatorType {
    static Logger log = LoggerFactory.getLogger(SwingManipulator.class);
    private AvatarState avatar;
    private ManipulatorType delegate;
    private EntityId target;

    public SwingManipulator(AvatarState avatar, ManipulatorType delegate) {
        this.avatar = avatar;
        this.delegate = delegate;
    }

    @Override
    public void setTarget(EntityId target) {
        this.target = target;
        if (this.delegate != null) {
            this.delegate.setTarget(target);
        }
    }

    @Override
    public void viewChanged(Vec3d pos, Quatd facing) {
        if (this.delegate != null) {
            this.delegate.viewChanged(pos, facing);
        }
    }

    @Override
    public void update(float tpf) {
        if (this.delegate != null) {
            this.delegate.update(tpf);
        }
    }

    @Override
    public void activate(boolean pressed) {
        this.avatar.setPrimaryDrag(pressed);
    }

    @Override
    public void altActivate(boolean pressed) {
        if (this.delegate != null) {
            this.delegate.altActivate(pressed);
        }
    }

    @Override
    public void change(int delta) {
        if (this.delegate != null) {
            this.delegate.change(delta);
        }
    }
}

