/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BlockName
implements Serializable {
    static final long serialVersionUID = 42L;
    public static final Pattern PARSE = Pattern.compile("(.*):(.*?)(?:\\.(\\d+))?");
    private String base;
    private String shape;
    private Integer rotation;

    private BlockName() {
    }

    public BlockName(String base, String shape) {
        this(base, shape, null);
    }

    public BlockName(String base, String shape, Integer rotation) {
        this.base = base;
        this.shape = shape;
        this.rotation = rotation;
    }

    public static BlockName parse(String s) {
        Matcher m = PARSE.matcher(s);
        if (!m.matches()) {
            return null;
        }
        String base = m.group(1);
        String shape = m.group(2);
        String rot = m.group(3);
        Integer rotation = null;
        if (!Strings.isNullOrEmpty((String)rot)) {
            rotation = Integer.parseInt(rot);
        }
        return new BlockName(base, shape, rotation);
    }

    public String getBase() {
        return this.base;
    }

    public String getShape() {
        return this.shape;
    }

    public Integer getRotation() {
        return this.rotation;
    }

    public BlockName rotate(int dirDelta) {
        if (dirDelta < 0 || dirDelta > 3) {
            throw new IllegalArgumentException("dirDelta is out of bounds:" + dirDelta);
        }
        int rot = this.rotation == null ? 0 : this.rotation;
        int newRotation = (rot + dirDelta) % 4;
        return new BlockName(this.base, this.shape, newRotation);
    }

    public BlockName rotate(int dirDelta, int max) {
        int rot = this.rotation == null ? 0 : this.rotation;
        int newRotation = (rot + dirDelta) % max;
        if (newRotation < 0) {
            newRotation += max;
        }
        return new BlockName(this.base, this.shape, newRotation);
    }

    public int hashCode() {
        return Objects.hash(this.base, this.shape, this.rotation);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        BlockName other = (BlockName)o;
        if (!Objects.equals(this.base, other.base)) {
            return false;
        }
        if (!Objects.equals(this.shape, other.shape)) {
            return false;
        }
        return Objects.equals(this.rotation, other.rotation);
    }

    public String toString() {
        return this.base + ":" + this.shape + (this.rotation != null ? "." + this.rotation : "");
    }
}

