/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.geom;

import com.google.common.base.MoreObjects;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.Direction;
import com.simsilica.mblock.geom.BoundaryShape;
import com.simsilica.mblock.geom.BoundaryShapes;
import com.simsilica.mblock.geom.GeomPart;
import com.simsilica.mblock.geom.GeomPartBuffer;
import com.simsilica.mblock.geom.GeomUtils;
import com.simsilica.mblock.geom.MaterialType;
import com.simsilica.mblock.geom.PartFactory;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPartFactory
implements PartFactory {
    static final long serialVersionUID = 42L;
    static Logger log = LoggerFactory.getLogger(DefaultPartFactory.class);
    private final GeomPart[] templates;
    private final BoundaryShape shape;
    private final Vec3d min;
    private final Vec3d max;

    public DefaultPartFactory(BoundaryShape shape, Vec3d min, Vec3d max, GeomPart ... templates) {
        this.templates = templates;
        this.shape = shape;
        this.min = min;
        this.max = max;
    }

    public static DefaultPartFactory createCubeFace(MaterialType materialType, Direction dir) {
        return new DefaultPartFactory(BoundaryShapes.UNIT_SQUARE, new Vec3d(), new Vec3d(1.0, 1.0, 1.0), GeomPart.createFace(materialType, dir));
    }

    public static DefaultPartFactory create(GeomPart ... templates) {
        return DefaultPartFactory.create(null, templates);
    }

    public static DefaultPartFactory create(BoundaryShape shape, GeomPart ... templates) {
        Vec3d min = new Vec3d(100.0, 100.0, 100.0);
        Vec3d max = new Vec3d(-100.0, -100.0, -100.0);
        for (GeomPart p : templates) {
            if (p == null) continue;
            float[] coords = p.getCoords();
            for (int i = 0; i < coords.length; i += 3) {
                float x = coords[i];
                float y = coords[i + 1];
                float z = coords[i + 2];
                Vec3d pos = new Vec3d((double)x, (double)y, (double)z);
                min.minLocal(pos);
                max.maxLocal(pos);
            }
        }
        return new DefaultPartFactory(shape, min, max, templates);
    }

    public GeomPart[] getTemplates() {
        return this.templates;
    }

    @Override
    public BoundaryShape getBoundaryShape() {
        return this.shape;
    }

    @Override
    public Vec3d getMin() {
        return this.min;
    }

    @Override
    public Vec3d getMax() {
        return this.max;
    }

    @Override
    public int addParts(GeomPartBuffer buffer, int i, int j, int k, int xWorld, int yWorld, int zWorld, BlockType block, Direction dir) {
        int count = 0;
        for (GeomPart t : this.templates) {
            buffer.addPart(i, j, k, t);
            ++count;
        }
        return count;
    }

    @Override
    public PartFactory rotate(Direction dir, int dirDelta) {
        if (dirDelta < 0 || dirDelta > 3) {
            throw new IllegalArgumentException("dirDelta is out of bounds:" + dirDelta);
        }
        GeomPart[] newParts = new GeomPart[this.templates.length];
        for (int i = 0; i < newParts.length; ++i) {
            newParts[i] = this.templates[i].rotate(dirDelta);
        }
        BoundaryShape newShape = null;
        if (this.shape != null) {
            newShape = this.shape.rotate(dir, dirDelta);
        }
        Vec3d v1 = GeomUtils.rotatePos(this.min, dirDelta);
        Vec3d v2 = GeomUtils.rotatePos(this.max, dirDelta);
        Vec3d newMin = new Vec3d(v1).minLocal(v2);
        Vec3d newMax = new Vec3d(v1).maxLocal(v2);
        return new DefaultPartFactory(newShape, newMin, newMax, newParts);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        DefaultPartFactory other = (DefaultPartFactory)o;
        if (!Objects.equals(other.shape, this.shape)) {
            return false;
        }
        if (!Objects.equals(other.min, this.min)) {
            return false;
        }
        if (!Objects.equals(other.max, this.max)) {
            return false;
        }
        return Arrays.equals(other.templates, this.templates);
    }

    public int hashCode() {
        return Objects.hash(this.shape, this.min, this.max, Arrays.hashCode(this.templates));
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("boundaryShape", (Object)this.shape).add("min", (Object)this.min).add("max", (Object)this.max).add("templates", Arrays.asList(this.templates)).toString();
    }
}

