/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.phys;

import com.google.common.base.MoreObjects;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mphys.RigidBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KinematicInfo {
    static Logger log = LoggerFactory.getLogger(KinematicInfo.class);
    private Object id;
    private Vec3d lastLocation = new Vec3d();
    private Vec3d currentLocation = new Vec3d();
    private Quatd lastOrientation = new Quatd();
    private Quatd currentOrientation = new Quatd();
    private double scale;

    public KinematicInfo(Object id) {
        this.id = id;
    }

    public void initialize(Vec3d location, Quatd orientation) {
        this.lastLocation.set(location);
        this.lastOrientation.set(orientation);
        this.currentLocation.set(location);
        this.currentOrientation.set(orientation);
    }

    public Object getId() {
        return this.id;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public double getScale() {
        return this.scale;
    }

    public void update(Vec3d location, Quatd orientation) {
        this.lastLocation.set(this.currentLocation);
        this.lastOrientation.set(this.currentOrientation);
        this.currentLocation.set(location);
        this.currentOrientation.set(orientation);
    }

    public Vec3d getLastLocation() {
        return this.lastLocation;
    }

    public Vec3d getCurrentLocation() {
        return this.currentLocation;
    }

    public Quatd getLastOrientation() {
        return this.lastOrientation;
    }

    public Quatd getCurrentOrientation() {
        return this.currentOrientation;
    }

    public Vec3d getLinearVelocity() {
        return this.currentLocation.subtract(this.lastLocation);
    }

    private static Vec3d parentToChild(Vec3d loc, Vec3d childLoc, Quatd childOrient) {
        Vec3d relative = loc.subtract(childLoc);
        childOrient.inverse().mult(relative, relative);
        return relative;
    }

    private static Vec3d childToParent(Vec3d loc, Vec3d childLoc, Quatd childOrient) {
        Vec3d result = childOrient.mult(loc);
        result.addLocal(childLoc);
        return result;
    }

    public Vec3d getPointVelocity(RigidBody<?, MBlockShape> body, Vec3d point) {
        Vec3d bodyCp = body.worldToLocal(point, null);
        Vec3d shapeCp = ((MBlockShape)body.shape).bodyToShape(bodyCp, null);
        Vec3d kNowRelative = KinematicInfo.parentToChild(shapeCp, this.currentLocation, this.currentOrientation);
        Vec3d kPrevShape = KinematicInfo.childToParent(kNowRelative, this.lastLocation, this.lastOrientation);
        Vec3d prevBodyCp = ((MBlockShape)body.shape).shapeToBody(kPrevShape, null);
        Vec3d prevCp = body.localToWorld(prevBodyCp, null);
        return point.subtract(prevCp);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("lastLocation", (Object)this.lastLocation).add("lastOrientation", (Object)this.lastOrientation).add("currentLocation", (Object)this.currentLocation).add("currentOrientation", (Object)this.currentOrientation).toString();
    }
}

