/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.bpos;

import com.simsilica.es.EntityId;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.trans.PositionTransition3d;
import com.simsilica.mathd.trans.TransitionBuffer;

public class ChildPositionTransition3d
extends PositionTransition3d {
    private EntityId startParent;
    private EntityId endParent;

    public ChildPositionTransition3d(long endTime, EntityId endParent, Vec3d endPos, Quatd endRot, boolean visible) {
        super(endTime, endPos, endRot, visible);
        this.endParent = endParent;
    }

    public static TransitionBuffer<ChildPositionTransition3d> createChildBuffer(int history) {
        return new TransitionBuffer(history);
    }

    public void setPreviousTransition(PositionTransition3d previous) {
        super.setPreviousTransition(previous);
        this.startParent = ((ChildPositionTransition3d)previous).endParent;
    }

    public EntityId getParentId(long time, boolean clamp) {
        if (this.startParent == null) {
            return clamp ? this.endParent : null;
        }
        if (time < this.getStartTime()) {
            return clamp ? this.startParent : null;
        }
        if (time < this.getEndTime()) {
            return this.startParent;
        }
        return this.endParent;
    }

    public String toString() {
        return "ChildPositionTransition3d[ t:" + this.getStartTime() + ", pos:" + this.getStartPosition() + ", rot:" + this.getStartRotation() + ", parent:" + this.startParent + ", vis:" + this.getStartVisibility() + " -> t:" + this.getEndTime() + ", pos:" + this.getEndPosition() + ", rot:" + this.getEndRotation() + ", parent:" + this.endParent + ", vis:" + this.getEndVisibility() + " ]";
    }
}

