/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.sql;

import com.google.common.base.MoreObjects;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityId;
import com.simsilica.es.Query;
import com.simsilica.es.sql.ComponentTable;
import com.simsilica.es.sql.JoinQuery;
import com.simsilica.es.sql.SqlEntityData;
import java.sql.SQLException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableQuery<T extends EntityComponent>
implements Query {
    static Logger log = LoggerFactory.getLogger(TableQuery.class);
    private final SqlEntityData parent;
    private final Class<T> type;
    private final ComponentTable<T> table;
    private final ComponentFilter<T> filter;

    public TableQuery(SqlEntityData parent, Class<T> type, ComponentTable<T> table, ComponentFilter<T> filter) {
        this.parent = parent;
        this.type = type;
        this.table = table;
        this.filter = filter;
    }

    protected SqlEntityData getParent() {
        return this.parent;
    }

    protected String getTableName() {
        return this.table.getTableName();
    }

    protected ComponentFilter<T> getFilter() {
        return this.filter;
    }

    protected ComponentTable<T> getTable() {
        return this.table;
    }

    @Override
    public Set<EntityId> execute() {
        try {
            return this.table.getEntityIds(this.parent.getSession(), this.filter);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error retrieving component entities for type:" + this.type + ", filter:" + this.filter);
        }
    }

    @Override
    public EntityId findFirst() {
        try {
            return this.table.getEntityId(this.parent.getSession(), this.filter);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error finding component entity for type:" + this.type + ", filter:" + this.filter);
        }
    }

    @Override
    public Query join(Query other) {
        if (other.getClass() == TableQuery.class) {
            TableQuery q = (TableQuery)other;
            if (this.parent == q.parent) {
                return new JoinQuery(this.parent, this, q);
            }
        }
        if (other.getClass() == JoinQuery.class) {
            return other.join(this);
        }
        return null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).omitNullValues().add("type", this.type).add("filter", this.filter).toString();
    }
}

