/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.debug;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import java.nio.FloatBuffer;

public class Arrow
extends Mesh {
    private final Quaternion tempQuat = new Quaternion();
    private final Vector3f tempVec = new Vector3f();
    private static final float[] positions = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.05f, 0.0f, 0.9f, -0.05f, 0.0f, 0.9f, 0.0f, 0.05f, 0.9f, 0.0f, -0.05f, 0.9f};

    protected Arrow() {
    }

    public Arrow(Vector3f extent) {
        float len = extent.length();
        Vector3f dir = extent.normalize();
        this.tempQuat.lookAt(dir, Vector3f.UNIT_Y);
        this.tempQuat.normalizeLocal();
        float[] newPositions = new float[positions.length];
        for (int i = 0; i < positions.length; i += 3) {
            Vector3f vec = this.tempVec.set(positions[i], positions[i + 1], positions[i + 2]);
            vec.multLocal(len);
            this.tempQuat.mult(vec, vec);
            newPositions[i] = vec.getX();
            newPositions[i + 1] = vec.getY();
            newPositions[i + 2] = vec.getZ();
        }
        this.setBuffer(VertexBuffer.Type.Position, 3, newPositions);
        this.setBuffer(VertexBuffer.Type.Index, 2, new short[]{0, 1, 1, 2, 1, 3, 1, 4, 1, 5});
        this.setMode(Mesh.Mode.Lines);
        this.updateBound();
        this.updateCounts();
    }

    public void setArrowExtent(Vector3f extent) {
        float len = extent.length();
        this.tempQuat.lookAt(extent, Vector3f.UNIT_Y);
        this.tempQuat.normalizeLocal();
        VertexBuffer pvb = this.getBuffer(VertexBuffer.Type.Position);
        FloatBuffer buffer = (FloatBuffer)pvb.getData();
        buffer.rewind();
        for (int i = 0; i < positions.length; i += 3) {
            Vector3f vec = this.tempVec.set(positions[i], positions[i + 1], positions[i + 2]);
            vec.multLocal(len);
            this.tempQuat.mult(vec, vec);
            buffer.put(vec.x);
            buffer.put(vec.y);
            buffer.put(vec.z);
        }
        pvb.updateData(buffer);
        this.updateBound();
        this.updateCounts();
    }
}

