/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.clothing;

import com.jme3.scene.Node;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.db.CellArrayId;
import java.util.Objects;
import mythruna.es.ClothingInfo;
import mythruna.es.ObjectName;
import mythruna.es.WornBy;
import mythruna.shape.ShapeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClothingItem {
    static Logger log = LoggerFactory.getLogger(ClothingItem.class);
    private Entity entity;
    private ClothingInfo info;
    private WornBy wornBy;
    private ObjectName objectName;
    private ShapeInfo shape;
    private CellArrayId cellArrayId;
    private CellArray cellArray;
    private Node model;

    public ClothingItem(Entity entity) {
        this.entity = entity;
        this.model = new Node("clothing:" + entity.getId());
    }

    public EntityId getId() {
        return this.entity.getId();
    }

    public ClothingInfo getClothingInfo() {
        return this.info;
    }

    public WornBy getWornBy() {
        return this.wornBy;
    }

    public int getLayer() {
        return this.wornBy == null ? -1 : this.wornBy.getLayer();
    }

    public void update(EntityData ed) {
        this.info = (ClothingInfo)this.entity.get(ClothingInfo.class);
        this.wornBy = (WornBy)this.entity.get(WornBy.class);
        this.objectName = (ObjectName)this.entity.get(ObjectName.class);
        this.setShape((ShapeInfo)this.entity.get(ShapeInfo.class), ed);
    }

    protected void setShape(ShapeInfo shape, EntityData ed) {
        if (Objects.equals(this.shape, shape)) {
            return;
        }
        this.shape = shape;
        this.model.setName("model:" + this.entity.getId() + ", " + this.info.getName());
        String shapeId = shape.getShapeName(ed);
        log.info("shapeId:" + shapeId);
        ShapeName shapeName = ShapeName.parse((String)shapeId);
        log.info("shapeName:" + shapeName);
        CellArrayId id = "fab".equals(shapeName.getType()) ? CellArrayId.fromString((String)shapeName.getName()) : null;
        log.info("id:" + id);
    }

    public String toString() {
        return this.info.getName();
    }
}

