/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.style;

import com.simsilica.lemur.style.StyleLoader;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseStyles {
    static Logger log = LoggerFactory.getLogger(BaseStyles.class);
    public static final String GLASS = "glass";
    public static final String GLASS_STYLE_RESOURCE = "com/simsilica/lemur/style/base/glass-styles.groovy";

    public static void loadGlassStyle() {
        BaseStyles.loadStyleResources(GLASS_STYLE_RESOURCE);
    }

    public static void loadStyleResources(String resource) {
        if (resource.startsWith("/")) {
            resource = resource.substring(1);
        }
        log.info("loadStyleResource(" + resource + ")");
        StyleLoader loader = new StyleLoader();
        URL baseResource = BaseStyles.class.getResource("/" + resource);
        log.info("Loading base resource:" + baseResource);
        loader.loadStyle(baseResource);
        log.info("Loading extension resources for:" + resource);
        ClassLoader cl = BaseStyles.class.getClassLoader();
        try {
            Enumeration<URL> en = cl.getResources(resource);
            while (en.hasMoreElements()) {
                URL u = en.nextElement();
                if (u.equals(baseResource)) continue;
                log.info("Loading extension resource:" + u);
                loader.loadStyle(u);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error retreiving resources:" + resource, e);
        }
    }
}

