/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ext.mblock;

import com.simsilica.ext.mphys.Mass;
import com.simsilica.ext.mphys.ShapeFactory;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.io.BlocksFileFormat;
import com.simsilica.mblock.phys.MBlockShape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlocksResourceShapeFactory
implements ShapeFactory<MBlockShape> {
    static Logger log = LoggerFactory.getLogger(BlocksResourceShapeFactory.class);

    public MBlockShape createShape(String name, double scale, Mass mass) {
        log.info("createShape(" + name + ", " + scale + ", " + mass + ")");
        double m = mass == null ? 0.0 : mass.getMass();
        CellArray cells = this.loadCells(name);
        return MBlockShape.createShape((String)name, (CellArray)cells, (double)scale, (double)m);
    }

    protected CellArray loadCells(String name) {
        try {
            log.info("loading:" + this.getClass().getResource(name));
            return BlocksFileFormat.loadCellArray((String)name);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading block resource:" + name, e);
        }
    }
}

