/*
 * Decompiled with CFR 0.152.
 */
package mythruna.assembly.io;

import com.simsilica.ethereal.io.BitInputStream;
import com.simsilica.ethereal.io.BitOutputStream;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mworld.io.ObjectProtocol;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import mythruna.assembly.Joint;
import mythruna.assembly.Subassembly;
import mythruna.assembly.TargetName;
import mythruna.shape.ShapeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubassemblyProtocol
implements ObjectProtocol<Subassembly> {
    static Logger log = LoggerFactory.getLogger(SubassemblyProtocol.class);
    private static final int STRING_INDEX_BITS = 12;
    private static final int MAX_STRING_INDEX = (int)Math.pow(2.0, 11.0) - 2;
    private static final int STRING_INDEX_SIGN_BIT = 2048;
    private static final int STRING_INDEX_NEG_MASK = -4096;
    private static final int STRING_BITS = 12;
    private static final int MAX_STRING_SIZE = (int)Math.pow(2.0, 12.0) - 1;
    private static final int FLAG_BITS = 8;
    private static final int FLAG_MASK = 255;
    private static final int ADD_ON_BITS = 8;
    private static final int MAX_ADD_ONS = (int)Math.pow(2.0, 8.0) - 1;
    private static final int CHILD_BITS = 10;
    private static final int MAX_CHILDREN = (int)Math.pow(2.0, 10.0) - 1;
    private static final int LOC_SCALE = 10000;
    private static final int LOC_BITS = 20;
    private static final int ROT_SCALE = 10000;
    private static final int ROT_BITS = 15;
    private static final int SCALE_SCALE = 10000;
    private static final int SCALE_BITS = 15;
    private static final int MASS_SCALE = 100;
    private static final int MASS_BITS = 14;
    private static final int DURATION_SCALE = 100;
    private static final int DURATION_BITS = 10;
    private int version = 0;
    private static final Map<String, Integer> VERSION_0_DEFAULTS = new HashMap<String, Integer>();
    private static final Map<Integer, String> VERSION_0_REV_DEFAULTS = new HashMap<Integer, String>();

    public int getProtocolVersion() {
        return this.version;
    }

    public static byte[] toBytes(Subassembly data) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try (BitOutputStream out = new BitOutputStream((OutputStream)new GZIPOutputStream(bOut));){
            new SubassemblyProtocol().write(data, out);
        }
        catch (IOException e) {
            throw new RuntimeException("Error converting subassembly to bytes", e);
        }
        return bOut.toByteArray();
    }

    public static Subassembly fromBytes(byte[] array) {
        Subassembly subassembly;
        ByteArrayInputStream bIn = new ByteArrayInputStream(array);
        BitInputStream in = new BitInputStream((InputStream)new GZIPInputStream(bIn));
        try {
            subassembly = new SubassemblyProtocol().read(in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Error converting bytes to subassembly", e);
            }
        }
        in.close();
        return subassembly;
    }

    public void write(Subassembly data, BitOutputStream out) throws IOException {
        out.writeBits(this.version, 8);
        HashMap<String, Integer> stringIndex = new HashMap<String, Integer>(VERSION_0_DEFAULTS);
        this.writeData(data, stringIndex, out);
    }

    protected void writeString(String s, Map<String, Integer> stringIndex, BitOutputStream out) throws IOException {
        Integer index = stringIndex.get(s);
        boolean writeString = false;
        if (index == null) {
            writeString = true;
            if (stringIndex.size() >= MAX_STRING_INDEX) {
                log.warn("Max string index exceeded.");
                index = MAX_STRING_INDEX + 1;
            } else {
                index = stringIndex.size();
                stringIndex.put(s, index);
            }
        }
        out.writeBits(index.intValue(), 12);
        if (writeString) {
            byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
            if (bytes.length > MAX_STRING_SIZE) {
                throw new IllegalArgumentException("String exceeds maximum size(" + MAX_STRING_SIZE + "):" + s);
            }
            out.writeBits(bytes.length, 12);
            for (byte b : bytes) {
                out.writeBits((int)b, 8);
            }
        }
    }

    protected String readString(Map<Integer, String> stringIndex, BitInputStream in) throws IOException {
        int index = in.readBits(12);
        if ((index & 0x800) != 0) {
            index = 0xFFFFF000 | index;
        }
        if (stringIndex.containsKey(index)) {
            return stringIndex.get(index);
        }
        int length = in.readBits(12);
        byte[] bytes = new byte[length];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)in.readBits(8);
        }
        String result = new String(bytes, StandardCharsets.UTF_8);
        stringIndex.put(index, result);
        return result;
    }

    protected void writeShapeName(ShapeName name, Map<String, Integer> stringIndex, BitOutputStream out) throws IOException {
        if (name == null) {
            out.writeBits(0, 1);
            return;
        }
        out.writeBits(1, 1);
        this.writeString(name.getType(), stringIndex, out);
        this.writeString(name.getName(), stringIndex, out);
        int flags = name.getFlags();
        if ((flags & 0xFF) != flags) {
            throw new IllegalArgumentException("Flags 0b" + Integer.toBinaryString(flags) + " exceeds 8 bits.");
        }
        out.writeBits(flags, 8);
        List<ShapeName> addOns = name.getAddOns();
        if (addOns == null) {
            out.writeBits(0, 1);
            return;
        }
        out.writeBits(1, 1);
        if (addOns.size() > MAX_ADD_ONS) {
            throw new IllegalArgumentException("Number of add-ons (" + addOns.size() + ") exceeds max size:" + MAX_ADD_ONS);
        }
        out.writeBits(addOns.size(), 8);
        for (ShapeName child : addOns) {
            this.writeShapeName(child, stringIndex, out);
        }
    }

    protected ShapeName readShapeName(Map<Integer, String> stringIndex, BitInputStream in) throws IOException {
        ArrayList<ShapeName> addOns;
        int nullFlag = in.readBits(1);
        if (nullFlag == 0) {
            return null;
        }
        String type = this.readString(stringIndex, in);
        String name = this.readString(stringIndex, in);
        int flags = in.readBits(8);
        nullFlag = in.readBits(1);
        if (nullFlag == 0) {
            addOns = null;
        } else {
            addOns = new ArrayList<ShapeName>();
            int count = in.readBits(8);
            for (int i = 0; i < count; ++i) {
                addOns.add(this.readShapeName(stringIndex, in));
            }
        }
        return new ShapeName(type, name, flags, addOns);
    }

    protected void writeTargetName(TargetName name, Map<String, Integer> stringIndex, BitOutputStream out) throws IOException {
        if (name == null) {
            out.writeBits(0, 1);
            return;
        }
        out.writeBits(1, 1);
        this.writeString(name.getVerb(), stringIndex, out);
        this.writeString(name.getState(), stringIndex, out);
    }

    protected TargetName readTargetName(Map<Integer, String> stringIndex, BitInputStream in) throws IOException {
        int nullFlag = in.readBits(1);
        if (nullFlag == 0) {
            return null;
        }
        String verb = this.readString(stringIndex, in);
        String state = this.readString(stringIndex, in);
        return new TargetName(verb, state);
    }

    protected void writeDouble(double d, double scale, int bits, BitOutputStream out) throws IOException {
        long mask;
        long val = Math.round(d * scale);
        if ((val & (mask = -1L << bits)) != 0L) {
            throw new IllegalArgumentException("Value (" + d + ") exceeds allowed scale:" + scale + " and bits:" + bits);
        }
        out.writeLongBits(val, bits);
    }

    protected double readDouble(double scale, int bits, BitInputStream in) throws IOException {
        long val = in.readLongBits(bits);
        return (double)val / scale;
    }

    protected void writeSignedDouble(double d, double scale, int bits, BitOutputStream out) throws IOException {
        long mask;
        long val = Math.round(d * scale);
        if ((val & (mask = -1L << bits - 1)) != 0L) {
            if (d >= 0.0) {
                throw new IllegalArgumentException("Value (" + d + ") exceeds allowed scale:" + scale + " and bits:" + bits);
            }
            if (d < 0.0 && (val & mask) != mask) {
                throw new IllegalArgumentException("Value (" + d + ") exceeds allowed scale:" + scale + " and bits:" + bits);
            }
        }
        out.writeLongBits(val, bits);
    }

    protected double readSignedDouble(double scale, int bits, BitInputStream in) throws IOException {
        long mask;
        long val = in.readLongBits(bits);
        if ((val & (mask = -1L << (int)((long)(bits - 1)))) != 0L) {
            val |= mask;
        }
        return (double)val / scale;
    }

    protected void writeVec3d(Vec3d v, double scale, int bits, BitOutputStream out) throws IOException {
        if (v == null) {
            out.writeBits(0, 1);
            return;
        }
        out.writeBits(1, 1);
        this.writeSignedDouble(v.x, scale, bits, out);
        this.writeSignedDouble(v.y, scale, bits, out);
        this.writeSignedDouble(v.z, scale, bits, out);
    }

    protected Vec3d readVec3d(double scale, int bits, BitInputStream in) throws IOException {
        int nullFlag = in.readBits(1);
        if (nullFlag == 0) {
            return null;
        }
        double x = this.readSignedDouble(scale, bits, in);
        double y = this.readSignedDouble(scale, bits, in);
        double z = this.readSignedDouble(scale, bits, in);
        return new Vec3d(x, y, z);
    }

    protected void writeQuatd(Quatd q, double scale, int bits, BitOutputStream out) throws IOException {
        if (q == null) {
            out.writeBits(0, 1);
            return;
        }
        out.writeBits(1, 1);
        this.writeSignedDouble(q.get(0), scale, bits, out);
        this.writeSignedDouble(q.get(1), scale, bits, out);
        this.writeSignedDouble(q.get(2), scale, bits, out);
        this.writeSignedDouble(q.get(3), scale, bits, out);
    }

    protected Quatd readQuatd(double scale, int bits, BitInputStream in) throws IOException {
        int nullFlag = in.readBits(1);
        if (nullFlag == 0) {
            return null;
        }
        double x = this.readSignedDouble(scale, bits, in);
        double y = this.readSignedDouble(scale, bits, in);
        double z = this.readSignedDouble(scale, bits, in);
        double w = this.readSignedDouble(scale, bits, in);
        return new Quatd(x, y, z, w);
    }

    protected void writeData(Subassembly data, Map<String, Integer> stringIndex, BitOutputStream out) throws IOException {
        if (data == null) {
            throw new IllegalArgumentException("Writing null Subassemblies is not supported.");
        }
        int typeBits = 2;
        if (data instanceof Joint) {
            out.writeBits(1, typeBits);
        } else {
            out.writeBits(0, typeBits);
        }
        this.writeString(data.getName(), stringIndex, out);
        this.writeShapeName(data.getShapeName(), stringIndex, out);
        this.writeVec3d(data.getLocation(), 10000.0, 20, out);
        this.writeQuatd(data.getOrientation(), 10000.0, 15, out);
        this.writeDouble(data.getScale(), 10000.0, 15, out);
        this.writeDouble(data.getMass(), 100.0, 14, out);
        if (data.getChildCount() > MAX_CHILDREN) {
            throw new IllegalArgumentException("Child count (" + data.getChildCount() + ") exceeds max size:" + MAX_CHILDREN);
        }
        out.writeBits(data.getChildCount(), 10);
        for (Subassembly child : data) {
            this.writeData(child, stringIndex, out);
        }
        if (data instanceof Joint) {
            this.writeJointData((Joint)data, stringIndex, out);
        }
    }

    protected void writeJointData(Joint data, Map<String, Integer> stringIndex, BitOutputStream out) throws IOException {
        this.writeTargetName(data.getRestingState(), stringIndex, out);
        this.writeTargetName(data.getTargetState(), stringIndex, out);
        this.writeVec3d(data.getTargetLocation(), 10000.0, 20, out);
        this.writeQuatd(data.getTargetOrientation(), 10000.0, 15, out);
        this.writeDouble(data.getDuration(), 100.0, 10, out);
    }

    protected Subassembly readData(Map<Integer, String> stringIndex, BitInputStream in) throws IOException {
        int typeBits = 2;
        int type = in.readBits(typeBits);
        Subassembly result = type == 0 ? new Subassembly() : new Joint();
        result.setName(this.readString(stringIndex, in));
        result.setShapeName(this.readShapeName(stringIndex, in));
        result.setLocation(this.readVec3d(10000.0, 20, in));
        result.setOrientation(this.readQuatd(10000.0, 15, in));
        result.setScale(this.readDouble(10000.0, 15, in));
        result.setMass(this.readDouble(100.0, 14, in));
        int childCount = in.readBits(10);
        for (int i = 0; i < childCount; ++i) {
            result.addChild(this.readData(stringIndex, in));
        }
        if (result instanceof Joint) {
            this.readJointData((Joint)result, stringIndex, in);
        }
        return result;
    }

    protected void readJointData(Joint result, Map<Integer, String> stringIndex, BitInputStream in) throws IOException {
        result.setRestingState(this.readTargetName(stringIndex, in));
        result.setTargetState(this.readTargetName(stringIndex, in));
        result.setTargetLocation(this.readVec3d(10000.0, 20, in));
        result.setTargetOrientation(this.readQuatd(10000.0, 15, in));
        result.setDuration(this.readDouble(100.0, 10, in));
    }

    public Subassembly read(BitInputStream in) throws IOException {
        int version = in.readBits(8);
        HashMap<Integer, String> stringIndex = new HashMap<Integer, String>(VERSION_0_REV_DEFAULTS);
        return this.readData(stringIndex, in);
    }

    static {
        int index = -1;
        VERSION_0_DEFAULTS.put(null, index--);
        VERSION_0_DEFAULTS.put("assembly", index--);
        VERSION_0_DEFAULTS.put("blocks", index--);
        VERSION_0_DEFAULTS.put("ca", index--);
        VERSION_0_DEFAULTS.put("limb", index--);
        VERSION_0_DEFAULTS.put("Open", index--);
        VERSION_0_DEFAULTS.put("Close", index--);
        VERSION_0_DEFAULTS.put("Closed", index--);
        VERSION_0_DEFAULTS.put("Lock", index--);
        VERSION_0_DEFAULTS.put("Locked", index--);
        VERSION_0_DEFAULTS.put("Unlock", index--);
        VERSION_0_DEFAULTS.put("Unlocked", index--);
        for (Map.Entry<String, Integer> e : VERSION_0_DEFAULTS.entrySet()) {
            VERSION_0_REV_DEFAULTS.put(e.getValue(), e.getKey());
        }
    }
}

