/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.local;

import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import mythruna.world.local.AbstractLocalSpaceValue;
import mythruna.world.local.BasisData;
import mythruna.world.local.TreeNeighborhood;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForestValue
extends AbstractLocalSpaceValue<Double, TreeNeighborhood> {
    static Logger log = LoggerFactory.getLogger(ForestValue.class);
    private Vec3i cell = new Vec3i();
    private Vec3i nearestTree;
    private double nearestDistSq;
    private Centroid audibleCentroid = new Centroid(this);
    private Centroid treeCentroid = new Centroid(this);
    private double forestFactor = 0.0;
    private Vec3d forestDirection = new Vec3d(0.0, 0.0, 0.0);

    public ForestValue(BasisData<TreeNeighborhood> basis) {
        super(basis, 0.0);
    }

    @Override
    public void updatePosition(Vec3d pos, Vec3i newCell, Vec3d look) {
        if (this.cell.equals((Object)newCell)) {
            return;
        }
        this.cell.set(newCell);
        this.invalidate();
    }

    @Override
    protected Double loadValue() {
        this.recalculateAmbientEffects();
        return this.forestFactor;
    }

    protected void recalculateAmbientEffects() {
        this.nearestTree = null;
        this.nearestDistSq = Double.MAX_VALUE;
        this.audibleCentroid.reset();
        this.treeCentroid.reset();
        double audibleDistance = 32.0;
        double startFalloff = 16.0;
        double audibleDistSq = audibleDistance * audibleDistance;
        ((TreeNeighborhood)this.getData()).visitTrees((origin, tree) -> {
            Vec3i loc = origin.add((int)tree.x, (int)tree.y, (int)tree.z);
            this.treeCentroid.add(loc);
            double distSq = this.cell.distanceSq(loc);
            if (distSq <= audibleDistSq) {
                this.audibleCentroid.add(loc);
            }
            if (distSq < this.nearestDistSq) {
                this.nearestTree = loc;
                this.nearestDistSq = distSq;
            }
        });
        this.treeCentroid.calculate();
        this.audibleCentroid.calculate();
        Vec3d relative = this.audibleCentroid.center.subtract(this.cell);
        double earshotDistance = relative.length();
        this.forestDirection = relative.normalize();
        relative = this.treeCentroid.center.subtract(this.cell);
        double countFactor = this.audibleCentroid.total == 0 ? 0.0 : Math.min(1.0, (double)this.audibleCentroid.total / 10.0);
        double distanceFactor = 1.0;
        if (earshotDistance > startFalloff) {
            distanceFactor = Math.max(0.0, 1.0 - (earshotDistance - startFalloff) / (audibleDistance - startFalloff));
        }
        this.forestFactor = countFactor * distanceFactor;
        if (log.isTraceEnabled()) {
            log.trace("count factor:" + countFactor + "  distFactor:" + distanceFactor + "  forestFactor:" + this.forestFactor);
        }
    }

    private class Centroid {
        Vec3d center = new Vec3d();
        int total;

        private Centroid(ForestValue forestValue) {
        }

        public void add(Vec3d v) {
            this.center.addLocal(v);
            ++this.total;
        }

        public void add(Vec3i v) {
            this.center.addLocal(v);
            ++this.total;
        }

        public void reset() {
            this.total = 0;
            this.center.set(0.0, 0.0, 0.0);
        }

        public void calculate() {
            if (this.total > 0) {
                this.center.divideLocal((double)this.total);
            }
        }
    }
}

