/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.river;

import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.FluidUtils;
import com.simsilica.mworld.CellDataStack;
import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.FluidData;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.morph.AbstractMorphology;
import java.util.ArrayList;
import java.util.Random;
import mythruna.world.TerrainTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RiverSection
extends AbstractMorphology {
    static Logger log = LoggerFactory.getLogger(RiverSection.class);
    private Vec3i start;
    private Vec3i end;
    private int depth;
    private int influence;
    private int width;
    private boolean special;

    public RiverSection(Vec3i start, Vec3i end, int depth, int influence, int width) {
        this.start = start;
        this.end = end;
        this.depth = depth;
        this.influence = influence;
        this.width = width;
    }

    public Vec3i getStart() {
        return this.start;
    }

    public Vec3i getEnd() {
        return this.end;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getInfluence() {
        return this.influence;
    }

    public int getWidth() {
        return this.width;
    }

    public Iterable<Short> getAffectedColumns(TileId tileId) {
        ArrayList<Short> results = new ArrayList<Short>();
        Vec3i origin = tileId.getWorld(null);
        int xMin = Math.min(this.start.x, this.end.x) - this.influence - origin.x;
        int zMin = Math.min(this.start.z, this.end.z) - this.influence - origin.z;
        int xMax = Math.max(this.start.x, this.end.x) + this.influence - origin.x;
        int zMax = Math.max(this.start.z, this.end.z) + this.influence - origin.z;
        if (xMax < 0 || zMax < 0) {
            return results;
        }
        if (xMin >= 1024 || zMin >= 1024) {
            return results;
        }
        xMin = Math.max(0, xMin);
        xMax = Math.min(xMax, 1023);
        zMin = Math.max(0, zMin);
        zMax = Math.min(zMax, 1023);
        Vec3i min = ColumnId.GRID.worldToCell((double)xMin, 0.0, (double)zMin);
        Vec3i max = ColumnId.GRID.worldToCell((double)xMax, 0.0, (double)zMax);
        for (int x = min.x; x <= max.x; ++x) {
            for (int z = min.z; z <= max.z; ++z) {
                short id = ColumnId.toTileLocalIndexId((int)x, (int)z);
                results.add(id);
            }
        }
        return results;
    }

    private double clamp(double v, double min, double max) {
        if (v <= min) {
            return min;
        }
        if (v >= max) {
            return max;
        }
        return v;
    }

    private int mix(int v1, int v2, double mix) {
        double d = (double)v1 * (1.0 - mix) + (double)v2 * mix;
        return (int)Math.round(d);
    }

    private double smoothStep(double edge0, double edge1, double x) {
        double t = this.clamp((x - edge0) / (edge1 - edge0), 0.0, 1.0);
        return t * t * (3.0 - 2.0 * t);
    }

    public boolean intersects(TileId tileId) {
        Vec3i tileOrigin = tileId.getWorld(null);
        Vec3i min = this.start.clone().minLocal(this.end);
        Vec3i max = this.start.clone().maxLocal(this.end);
        min.subtractLocal(this.influence, 0, this.influence);
        max.addLocal(this.influence, 0, this.influence);
        if (max.x < tileOrigin.x || max.z < tileOrigin.z) {
            return false;
        }
        return min.x < tileOrigin.x + 1024 && min.z < tileOrigin.z + 1024;
    }

    public double getDistanceSq(Vec3d pos) {
        Vec3d dir = new Vec3d((double)(this.end.x - this.start.x), 0.0, (double)(this.end.z - this.start.z));
        double length = dir.length();
        dir.normalizeLocal();
        Vec3d relative = pos.subtract(this.start);
        relative.y = 0.0;
        double project = dir.dot(relative);
        project = this.clamp(project, 0.0, length);
        Vec3d p = this.start.toVec3d().add(dir.mult(project));
        p.y = 0.0;
        return p.distanceSq(pos.x, 0.0, pos.z);
    }

    public boolean morph(Tile tile, Random rand) {
        TerrainImage terrain = (TerrainImage)tile.get((Object)TerrainImageType.Terrain, TerrainImage.class);
        TerrainImage fluid = (TerrainImage)tile.get((Object)TerrainImageType.Fluid, TerrainImage.class);
        int size = terrain.getSize();
        int spread = 1024 / size;
        TileId tileId = tile.getTileId();
        Vec3i origin = tileId.getWorld(null);
        int xMin = Math.min(this.start.x, this.end.x) - this.influence - origin.x;
        int zMin = Math.min(this.start.z, this.end.z) - this.influence - origin.z;
        int xMax = Math.max(this.start.x, this.end.x) + this.influence - origin.x;
        int zMax = Math.max(this.start.z, this.end.z) + this.influence - origin.z;
        xMin = Math.max(xMin, 0);
        zMin = Math.max(zMin, 0);
        xMax = Math.min(xMax, 1023);
        zMax = Math.min(zMax, 1023);
        xMin /= spread;
        zMin /= spread;
        xMax /= spread;
        zMax /= spread;
        int yStart = this.start.y;
        int yEnd = this.end.y;
        double radius = (double)this.width * 0.5;
        Vec3d dir = new Vec3d((double)(this.end.x - this.start.x), 0.0, (double)(this.end.z - this.start.z));
        double length = dir.length();
        dir.normalizeLocal();
        Vec3d localStart = this.start.subtract(origin).toVec3d();
        localStart.y = 0.0;
        int influenceSq = this.influence * this.influence;
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                int yDesired;
                Vec3d p;
                double dSq;
                double xRel = (double)(x * spread) - localStart.x;
                double zRel = (double)(z * spread) - localStart.z;
                double project = dir.dot(xRel, 0.0, zRel);
                boolean end = false;
                if (project < 0.0 || project > length) {
                    end = true;
                    project = this.clamp(project, 0.0, length);
                }
                if (!((dSq = (p = localStart.add(dir.mult(project))).distanceSq((double)(x * spread), 0.0, (double)(z * spread))) <= (double)influenceSq)) continue;
                int riverLevel = (int)((double)yStart + (double)(yEnd - yStart) * (project / length));
                double d = Math.sqrt(dSq);
                short y = terrain.getElevation(x, z);
                byte existingFluid = fluid.getType(x, z);
                if (d <= radius) {
                    double r = d / (radius + 1.0);
                    r *= r;
                    yDesired = (int)((double)(riverLevel - this.depth) + r * (double)this.depth);
                    if (existingFluid == -1) {
                        terrain.setElevation(x, z, (short)yDesired);
                        fluid.setElevation(x, z, (short)riverLevel);
                        fluid.setType(x, z, (byte)1);
                    } else if (!end) {
                        short waterLevel = fluid.getElevation(x, z);
                        if (waterLevel < riverLevel) {
                            fluid.setElevation(x, z, (short)riverLevel);
                            fluid.setType(x, z, (byte)1);
                        } else if (waterLevel > riverLevel) {
                            yDesired += waterLevel - riverLevel;
                        }
                        if (y > yDesired) {
                            terrain.setElevation(x, z, (short)yDesired);
                        }
                    }
                    int existingBase = TerrainTypes.getBaseType(terrain.getType(x, z));
                    terrain.setType(x, z, (byte)existingBase);
                    continue;
                }
                if (existingFluid != -1) continue;
                double mix = this.clamp(((double)this.influence - d) / ((double)this.influence - radius - 1.0), 0.0, 1.0);
                yDesired = this.mix(y, riverLevel, mix = this.smoothStep(0.0, 1.0, mix));
                if (y >= yDesired) continue;
                terrain.setElevation(x, z, (short)yDesired);
            }
        }
        return true;
    }

    public boolean morph(ColumnData colData, Tile tile, Random rand) {
        Vec3i origin = colData.getColumnId().getWorld(null);
        Vec3i localOrigin = origin.subtract(tile.getTileId().getWorld(null));
        int yStart = this.start.y;
        int yEnd = this.end.y;
        Vec3d dir = new Vec3d((double)(this.end.x - this.start.x), 0.0, (double)(this.end.z - this.start.z));
        double length = dir.length();
        dir.normalizeLocal();
        TerrainImage fluidImage = (TerrainImage)tile.get((Object)TerrainImageType.Fluid, TerrainImage.class);
        Vec3d localStart = this.start.subtract(origin).toVec3d();
        localStart.y = 0.0;
        double radius = (double)this.width * 0.5;
        boolean changed = false;
        for (int x = 0; x < 32; ++x) {
            for (int z = 0; z < 32; ++z) {
                short existingLevel;
                int value;
                FluidData fluid;
                int y;
                int layer;
                int baseLevel;
                int fluidLevel;
                Vec3d p;
                double dSq;
                double xRel = (double)x - localStart.x;
                double zRel = (double)z - localStart.z;
                double project = dir.dot(xRel, 0.0, zRel);
                boolean end = false;
                if (project < 0.0 || project > length) {
                    end = true;
                    project = this.clamp(project, 0.0, length);
                }
                if (!((dSq = (p = localStart.add(dir.mult(project))).distanceSq((double)x, 0.0, (double)z)) <= radius * radius)) continue;
                int rawRiverLevel = (int)((double)yStart + (double)(yEnd - yStart) * (project / length));
                double riverLevel = (double)yStart + (double)(yEnd - yStart) * (project / length);
                if ((fluidLevel = (int)(((riverLevel -= 1.25) - (double)(baseLevel = (int)riverLevel)) * 8.0)) > 0) {
                    layer = (baseLevel + 1) / 32;
                    y = (baseLevel + 1) % 32;
                    fluid = colData.getFluid()[layer];
                    value = fluid.getCell(x, y, z);
                    value = 1;
                    value = FluidUtils.setLevel((int)value, (int)fluidLevel);
                    if (!end) {
                        fluid.setCell(x, y, z, value);
                        changed = true;
                    } else {
                        existingLevel = fluidImage.getElevation(localOrigin.x + x, localOrigin.z + z);
                        if (rawRiverLevel <= existingLevel) {
                            fluid.setCell(x, y, z, value);
                            changed = true;
                        }
                    }
                }
                layer = baseLevel / 32;
                y = baseLevel % 32;
                fluid = colData.getFluid()[layer];
                value = FluidUtils.getType((int)fluid.getCell(x, y, z));
                if (value == 0) continue;
                value = 1;
                value = FluidUtils.setLevel((int)value, (int)8);
                if (!end) {
                    fluid.setCell(x, y, z, value);
                    changed = true;
                    continue;
                }
                existingLevel = fluidImage.getElevation(localOrigin.x + x, localOrigin.z + z);
                if (rawRiverLevel > existingLevel) continue;
                fluid.setCell(x, y, z, value);
                changed = true;
            }
        }
        return changed;
    }

    protected void renderTestLine(ColumnData colData) {
        CellDataStack blocks = new CellDataStack(32, (CellData[])colData.getLeafs());
        Vec3i origin = colData.getColumnId().getWorld(null);
        int yStart = this.start.y;
        int yEnd = this.end.y;
        Vec3d dir = new Vec3d((double)(this.end.x - this.start.x), 0.0, (double)(this.end.z - this.start.z));
        double length = dir.length();
        dir.normalizeLocal();
        Vec3i localStart = this.start.subtract(origin);
        Vec3i localEnd = this.end.subtract(origin);
        for (double d = 0.0; d <= length; d += 1.0) {
            int x = (int)((double)localStart.x + d * dir.x);
            int z = (int)((double)localStart.z + d * dir.z);
            if (x < 0 || x >= 32 || z < 0 || z >= 32) continue;
            int y = yStart + (int)((double)(yEnd - yStart) / length * d);
            blocks.setCell(x, --y, z, 2);
            if (!this.special) continue;
            blocks.setCell(x, y + 1, z, 1);
        }
        if (colData.getColumnId().contains(this.start)) {
            blocks.setCell(localStart.x, localStart.y, localStart.z, 3);
        }
        if (colData.getColumnId().contains(this.end)) {
            blocks.setCell(localEnd.x, localEnd.y + 1, localEnd.z, 4);
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[start:" + this.start + ", end:" + this.end + ", influence:" + this.influence + ", width:" + this.width + "]";
    }
}

