/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur;

import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.texture.image.ImageRaster;
import com.jme3.util.BufferUtils;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.Slider;
import com.simsilica.lemur.component.IconComponent;
import com.simsilica.lemur.component.QuadBackgroundComponent;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.event.CursorButtonEvent;
import com.simsilica.lemur.event.CursorEventControl;
import com.simsilica.lemur.event.CursorListener;
import com.simsilica.lemur.event.DefaultCursorListener;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.style.Styles;
import java.awt.Color;

public class ColorChooser
extends Panel {
    public static final String ELEMENT_ID = "colorChooser";
    public static final String CONTAINER_ID = "container";
    public static final String COLORS_ID = "colors";
    public static final String BRIGHTNESS_ID = "brightness.slider";
    public static final String VALUE_ID = "value";
    public static final String CROSSHAIR_ID = "crosshair";
    public static final String DEFAULT_CROSSHAIR = "com/simsilica/lemur/icons/tiny-crosshair.png";
    public static final Texture2D defaultTexture = new Texture2D(256, 256, Image.Format.RGBA8);
    private VersionedObject<ColorRGBA> model;
    private VersionedReference<ColorRGBA> modelRef;
    private Texture2D swatchTexture;
    private Panel value;
    private Container colorPanel;
    private Panel colors;
    private Panel crosshair;
    private Vector3f crosshairOffset;
    private QuadBackgroundComponent valueColor = new QuadBackgroundComponent();
    private QuadBackgroundComponent swatchComponent;
    private Slider brightness;
    private VersionedReference brightnessRef;
    private float hIndex = 0.0f;
    private float sIndex = 0.0f;
    private float bIndex = 0.5f;

    public ColorChooser() {
        this(true, null, new ElementId(ELEMENT_ID), null);
    }

    public ColorChooser(String style) {
        this(true, null, new ElementId(ELEMENT_ID), style);
    }

    public ColorChooser(ElementId elementId, String style) {
        this(true, null, elementId, style);
    }

    public ColorChooser(ElementId elementId) {
        this(true, null, elementId, null);
    }

    protected ColorChooser(boolean applyStyles, VersionedObject<ColorRGBA> model, ElementId elementId, String style) {
        super(false, elementId.child(CONTAINER_ID), style);
        this.swatchTexture = defaultTexture;
        SpringGridLayout layout = new SpringGridLayout();
        ((GuiControl)this.getControl(GuiControl.class)).setLayout((GuiLayout)layout);
        this.colorPanel = new Container(elementId.child(COLORS_ID), style);
        this.colorPanel.setLayout((GuiLayout)new SpringGridLayout());
        this.colors = new Panel();
        this.colorPanel.addChild((Node)this.colors, new Object[0]);
        this.swatchComponent = new QuadBackgroundComponent((Texture)this.swatchTexture);
        CursorEventControl.addListenersToSpatial((Spatial)this.colors, (CursorListener[])new CursorListener[]{new SwatchListener()});
        this.colors.setBackground((GuiComponent)this.swatchComponent);
        this.colors.setPreferredSize(new Vector3f(256.0f, 64.0f, 0.0f));
        layout.addChild((Node)this.colorPanel, new Object[]{2});
        this.brightness = new Slider(Axis.Y, elementId.child(BRIGHTNESS_ID), style);
        layout.addChild((Node)this.brightness, new Object[]{1});
        this.brightnessRef = this.brightness.getModel().createReference();
        this.value = new Panel(elementId.child(VALUE_ID), style);
        this.value.setPreferredSize(new Vector3f(64.0f, 64.0f, 0.0f));
        this.value.setBackground((GuiComponent)this.valueColor);
        layout.addChild((Node)this.value, new Object[]{0});
        this.crosshair = new Panel(elementId.child(CROSSHAIR_ID));
        if (this.crosshair.getBackground() == null) {
            IconComponent icon = new IconComponent(DEFAULT_CROSSHAIR);
            this.crosshair.setBackground((GuiComponent)icon);
        }
        Vector3f pref = this.crosshair.getPreferredSize();
        this.crosshairOffset = new Vector3f(pref.x * 0.5f, pref.y * 0.5f, pref.z);
        Node standoff = new Node("crosshair-standoff");
        standoff.attachChild((Spatial)this.crosshair);
        this.colors.attachChild((Spatial)standoff);
        if (applyStyles) {
            Styles styles = GuiGlobals.getInstance().getStyles();
            styles.applyStyles((Object)this, this.getElementId(), style);
        }
        this.setModel(model);
    }

    public void setModel(VersionedObject<ColorRGBA> model) {
        if (this.model != null) {
            // empty if block
        }
        if (model == null) {
            model = new VersionedHolder((Object)new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f));
        }
        this.model = model;
        this.modelRef = model.createReference();
        this.updateColorView();
    }

    public VersionedObject<ColorRGBA> getModel() {
        return this.model;
    }

    public void setColor(ColorRGBA color) {
        if (!(this.model instanceof VersionedHolder)) {
            throw new UnsupportedOperationException("Current model does not support externally setting the color");
        }
        ((VersionedHolder)this.model).setObject((Object)color);
    }

    public ColorRGBA getColor() {
        return this.model == null ? null : (ColorRGBA)this.model.getObject();
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.modelRef.update()) {
            this.updateColorView();
        }
        if (this.brightnessRef.update()) {
            this.updateBrightness();
        }
    }

    protected void updateModelValue(float h, float s, float b) {
        if (h == this.hIndex && s == this.sIndex && b == this.bIndex) {
            return;
        }
        this.hIndex = h;
        this.sIndex = s;
        this.bIndex = b;
        Color awtColor = Color.getHSBColor(this.hIndex, this.sIndex, this.bIndex);
        ((VersionedHolder)this.model).setObject((Object)ColorChooser.toJmeColor(awtColor));
    }

    protected void updateBrightness() {
        float v = (float)(this.brightness.getModel().getValue() / 100.0);
        this.updateModelValue(this.hIndex, this.sIndex, v);
    }

    protected static ColorRGBA toJmeColor(Color clr) {
        float r = (float)clr.getRed() / 255.0f;
        float g = (float)clr.getGreen() / 255.0f;
        float b = (float)clr.getBlue() / 255.0f;
        return new ColorRGBA(r, g, b, 1.0f);
    }

    protected void updateColorView() {
        ColorRGBA c = (ColorRGBA)this.model.getObject();
        int r = Math.round(c.getRed() * 255.0f);
        int g = Math.round(c.getGreen() * 255.0f);
        int b = Math.round(c.getBlue() * 255.0f);
        float[] hsb = Color.RGBtoHSB(r, g, b, null);
        this.hIndex = hsb[0];
        this.sIndex = hsb[1];
        this.bIndex = hsb[2];
        this.updateColorView(hsb[0], hsb[1], hsb[2]);
    }

    protected void updateColorView(float h, float s, float v) {
        Color awtColor = Color.getHSBColor(h, s, v);
        this.valueColor.setColor(ColorChooser.toJmeColor(awtColor));
        this.brightness.getModel().setValue((double)(v * 100.0f));
        Vector3f range = this.colors.getSize();
        this.crosshair.setLocalTranslation(h * range.x - this.crosshairOffset.x, s * range.y - range.y + this.crosshairOffset.y, this.crosshairOffset.z);
    }

    static {
        defaultTexture.getImage().setData(BufferUtils.createByteBuffer((int)262144));
        ImageRaster raster = ImageRaster.create((Image)defaultTexture.getImage());
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                Color hsb = Color.getHSBColor((float)i / 255.0f, (float)j / 255.0f, 0.5f);
                raster.setPixel(i, j, ColorChooser.toJmeColor(hsb));
            }
        }
    }

    private class SwatchListener
    extends DefaultCursorListener {
        private SwatchListener() {
        }

        protected void click(CursorButtonEvent event, Spatial target, Spatial capture) {
            Vector3f world = new Vector3f(event.getX(), event.getY(), 0.0f);
            Vector3f local = ColorChooser.this.colors.worldToLocal(world, null);
            Vector3f size = ColorChooser.this.colors.getSize();
            float h = local.x / size.x;
            float s = (size.y + local.y) / size.y;
            ColorChooser.this.updateModelValue(h, s, ColorChooser.this.bIndex);
        }
    }
}

